/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.repo.security.permissions.NodePermissionEntry;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.PermissionsDaoComponent;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionServiceImpl
implements PermissionServiceSPI,
InitializingBean {
    static SimplePermissionReference OLD_ALL_PERMISSIONS_REFERENCE = new SimplePermissionReference(QName.createQName("", "All"), "All");
    private static Log log = LogFactory.getLog(PermissionServiceImpl.class);
    private SimpleCache<Serializable, AccessStatus> accessCache;
    private ModelDAO modelDAO;
    private PermissionsDaoComponent permissionsDaoComponent;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private AuthenticationComponent authenticationComponent;
    private AuthorityService authorityService;
    private List<DynamicAuthority> dynamicAuthorities;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setModelDAO(ModelDAO modelDAO) {
        this.modelDAO = modelDAO;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionsDaoComponent(PermissionsDaoComponent permissionsDaoComponent) {
        this.permissionsDaoComponent = permissionsDaoComponent;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setDynamicAuthorities(List<DynamicAuthority> dynamicAuthorities) {
        this.dynamicAuthorities = dynamicAuthorities;
    }

    public void setAccessCache(SimpleCache<Serializable, AccessStatus> accessCache) {
        this.accessCache = accessCache;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dictionaryService == null) {
            throw new IllegalArgumentException("Property 'dictionaryService' has not been set");
        }
        if (this.modelDAO == null) {
            throw new IllegalArgumentException("Property 'modelDAO' has not been set");
        }
        if (this.nodeService == null) {
            throw new IllegalArgumentException("Property 'nodeService' has not been set");
        }
        if (this.permissionsDaoComponent == null) {
            throw new IllegalArgumentException("Property 'permissionsDAO' has not been set");
        }
        if (this.authenticationComponent == null) {
            throw new IllegalArgumentException("Property 'authenticationComponent' has not been set");
        }
        if (this.authorityService == null) {
            throw new IllegalArgumentException("Property 'authorityService' has not been set");
        }
        if (this.accessCache == null) {
            throw new IllegalArgumentException("Property 'accessCache' has not been set");
        }
    }

    @Override
    public String getOwnerAuthority() {
        return "ROLE_OWNER";
    }

    @Override
    public String getAllAuthorities() {
        return "GROUP_EVERYONE";
    }

    @Override
    public String getAllPermission() {
        return "All";
    }

    @Override
    public Set<AccessPermission> getPermissions(NodeRef nodeRef) {
        return this.getAllPermissionsImpl(nodeRef, true, true);
    }

    @Override
    public Set<AccessPermission> getAllSetPermissions(NodeRef nodeRef) {
        HashSet<AccessPermission> accessPermissions = new HashSet<AccessPermission>();
        NodePermissionEntry nodePremissionEntry = this.getSetPermissions(nodeRef);
        for (PermissionEntry permissionEntry : nodePremissionEntry.getPermissionEntries()) {
            accessPermissions.add(new AccessPermissionImpl(this.getPermission(permissionEntry.getPermissionReference()), permissionEntry.getAccessStatus(), permissionEntry.getAuthority()));
        }
        return accessPermissions;
    }

    private Set<AccessPermission> getAllPermissionsImpl(NodeRef nodeRef, boolean includeTrue, boolean includeFalse) {
        String userName = this.authenticationComponent.getCurrentUserName();
        HashSet<AccessPermission> accessPermissions = new HashSet<AccessPermission>();
        for (PermissionReference pr : this.getSettablePermissionReferences(nodeRef)) {
            if (this.hasPermission(nodeRef, pr) == AccessStatus.ALLOWED) {
                accessPermissions.add(new AccessPermissionImpl(this.getPermission(pr), AccessStatus.ALLOWED, userName));
                continue;
            }
            if (!includeFalse) continue;
            accessPermissions.add(new AccessPermissionImpl(this.getPermission(pr), AccessStatus.DENIED, userName));
        }
        return accessPermissions;
    }

    @Override
    public Set<String> getSettablePermissions(NodeRef nodeRef) {
        Set<PermissionReference> settable = this.getSettablePermissionReferences(nodeRef);
        HashSet<String> strings = new HashSet<String>(settable.size());
        for (PermissionReference pr : settable) {
            strings.add(this.getPermission(pr));
        }
        return strings;
    }

    @Override
    public Set<String> getSettablePermissions(QName type) {
        Set<PermissionReference> settable = this.getSettablePermissionReferences(type);
        HashSet<String> strings = new HashSet<String>(settable.size());
        for (PermissionReference pr : settable) {
            strings.add(this.getPermission(pr));
        }
        return strings;
    }

    @Override
    public NodePermissionEntry getSetPermissions(NodeRef nodeRef) {
        return this.permissionsDaoComponent.getPermissions(nodeRef);
    }

    @Override
    public AccessStatus hasPermission(NodeRef nodeRef, PermissionReference perm) {
        if (nodeRef == null) {
            return AccessStatus.ALLOWED;
        }
        if (perm == null) {
            return AccessStatus.DENIED;
        }
        if (!this.nodeService.exists(nodeRef)) {
            return AccessStatus.ALLOWED;
        }
        Authentication auth = this.authenticationComponent.getCurrentAuthentication();
        Set<String> authorisations = this.getAuthorisations(auth, nodeRef);
        Serializable key = PermissionServiceImpl.generateKey(authorisations, nodeRef, perm);
        AccessStatus status = this.accessCache.get(key);
        if (status != null) {
            return status;
        }
        Set<PermissionReference> available = this.modelDAO.getAllPermissions(nodeRef);
        available.add(this.getAllPermissionReference());
        available.add(OLD_ALL_PERMISSIONS_REFERENCE);
        if (!available.contains(perm)) {
            this.accessCache.put(key, AccessStatus.DENIED);
            return AccessStatus.DENIED;
        }
        QName typeQname = this.nodeService.getType(nodeRef);
        Set<QName> aspectQNames = this.nodeService.getAspects(nodeRef);
        if (perm.equals(OLD_ALL_PERMISSIONS_REFERENCE)) {
            perm = this.getAllPermissionReference();
        }
        NodeTest nt = new NodeTest(perm, typeQname, aspectQNames);
        boolean result = nt.evaluate(authorisations, nodeRef);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Permission <" + perm + "> is " + (result ? "allowed" : "denied") + " for " + this.authenticationComponent.getCurrentUserName() + " on node " + this.nodeService.getPath(nodeRef)));
        }
        status = result ? AccessStatus.ALLOWED : AccessStatus.DENIED;
        this.accessCache.put(key, status);
        return status;
    }

    static Serializable generateKey(Set<String> auths, NodeRef ref, PermissionReference perm) {
        HashSet<String> key = new HashSet<String>(auths);
        key.add(ref.getId());
        key.add(perm.toString());
        return key;
    }

    private Set<String> getAuthorisations(Authentication auth, NodeRef nodeRef) {
        HashSet<String> auths = new HashSet<String>();
        if (auth == null) {
            return auths;
        }
        User user = (User)auth.getPrincipal();
        auths.add(user.getUsername());
        for (GrantedAuthority authority : auth.getAuthorities()) {
            auths.add(authority.getAuthority());
        }
        if (this.dynamicAuthorities != null) {
            for (DynamicAuthority da : this.dynamicAuthorities) {
                if (!da.hasAuthority(nodeRef, user.getUsername())) continue;
                auths.add(da.getAuthority());
            }
        }
        auths.addAll(this.authorityService.getAuthorities());
        return auths;
    }

    @Override
    public NodePermissionEntry explainPermission(NodeRef nodeRef, PermissionReference perm) {
        return null;
    }

    @Override
    public void deletePermissions(NodeRef nodeRef) {
        this.permissionsDaoComponent.deletePermissions(nodeRef);
        this.accessCache.clear();
    }

    @Override
    public void deletePermissions(NodePermissionEntry nodePermissionEntry) {
        this.permissionsDaoComponent.deletePermissions(nodePermissionEntry.getNodeRef());
        this.accessCache.clear();
    }

    @Override
    public void deletePermission(PermissionEntry permissionEntry) {
        NodeRef nodeRef = permissionEntry.getNodeRef();
        String authority = permissionEntry.getAuthority();
        PermissionReference permission = permissionEntry.getPermissionReference();
        this.deletePermission(nodeRef, authority, permission);
    }

    public void deletePermission(NodeRef nodeRef, String authority, PermissionReference perm) {
        this.permissionsDaoComponent.deletePermission(nodeRef, authority, perm);
        this.accessCache.clear();
    }

    @Override
    public void clearPermission(NodeRef nodeRef, String authority) {
        this.permissionsDaoComponent.deletePermissions(nodeRef, authority);
        this.accessCache.clear();
    }

    public void setPermission(NodeRef nodeRef, String authority, PermissionReference perm, boolean allow) {
        this.permissionsDaoComponent.setPermission(nodeRef, authority, perm, allow);
        this.accessCache.clear();
    }

    @Override
    public void setPermission(PermissionEntry permissionEntry) {
        this.permissionsDaoComponent.setPermission(permissionEntry);
        this.accessCache.clear();
    }

    @Override
    public void setPermission(NodePermissionEntry nodePermissionEntry) {
        this.permissionsDaoComponent.setPermission(nodePermissionEntry);
        this.accessCache.clear();
    }

    @Override
    public void setInheritParentPermissions(NodeRef nodeRef, boolean inheritParentPermissions) {
        this.permissionsDaoComponent.setInheritParentPermissions(nodeRef, inheritParentPermissions);
        this.accessCache.clear();
    }

    @Override
    public boolean getInheritParentPermissions(NodeRef nodeRef) {
        return this.permissionsDaoComponent.getInheritParentPermissions(nodeRef);
    }

    @Override
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        return this.modelDAO.getPermissionReference(qname, permissionName);
    }

    @Override
    public PermissionReference getAllPermissionReference() {
        return this.getPermissionReference("All");
    }

    @Override
    public String getPermission(PermissionReference permissionReference) {
        if (this.modelDAO.isUnique(permissionReference)) {
            return permissionReference.getName();
        }
        return permissionReference.toString();
    }

    @Override
    public PermissionReference getPermissionReference(String permissionName) {
        return this.modelDAO.getPermissionReference(null, permissionName);
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(QName type) {
        return this.modelDAO.getExposedPermissions(type);
    }

    @Override
    public Set<PermissionReference> getSettablePermissionReferences(NodeRef nodeRef) {
        return this.modelDAO.getExposedPermissions(nodeRef);
    }

    @Override
    public void deletePermission(NodeRef nodeRef, String authority, String perm) {
        this.deletePermission(nodeRef, authority, this.getPermissionReference(perm));
    }

    @Override
    public AccessStatus hasPermission(NodeRef nodeRef, String perm) {
        return this.hasPermission(nodeRef, this.getPermissionReference(perm));
    }

    @Override
    public void setPermission(NodeRef nodeRef, String authority, String perm, boolean allow) {
        this.setPermission(nodeRef, authority, this.getPermissionReference(perm), allow);
    }

    @Override
    public void deletePermissions(String recipient) {
        this.permissionsDaoComponent.deletePermissions(recipient);
        this.accessCache.clear();
    }

    private static class MutableBoolean {
        private boolean value;

        MutableBoolean(boolean value) {
            this.value = value;
        }

        void setValue(boolean value) {
            this.value = value;
        }

        boolean getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Pair<A, B> {
        A a;
        B b;

        Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        A getA() {
            return this.a;
        }

        B getB() {
            return this.b;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(this instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            return EqualsHelper.nullSafeEquals(this.getA(), other.getA()) && EqualsHelper.nullSafeEquals(this.getB(), other.getB());
        }

        public int hashCode() {
            return (this.a == null ? 0 : this.a.hashCode()) * 37 + (this.b == null ? 0 : this.b.hashCode());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeTest {
        PermissionReference required;
        Set<PermissionReference> granters;
        Set<PermissionReference> nodeRequirements = new HashSet<PermissionReference>();
        Set<PermissionReference> parentRequirements = new HashSet<PermissionReference>();
        Set<PermissionReference> childrenRequirements = new HashSet<PermissionReference>();
        QName typeQName;
        Set<QName> aspectQNames;

        NodeTest(PermissionReference required, QName typeQName, Set<QName> aspectQNames) {
            this.required = required;
            this.typeQName = typeQName;
            this.aspectQNames = aspectQNames;
            this.nodeRequirements = PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.NODE);
            this.parentRequirements = PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.PARENT);
            this.childrenRequirements = PermissionServiceImpl.this.modelDAO.getRequiredPermissions(required, typeQName, aspectQNames, RequiredPermission.On.CHILDREN);
            this.granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(required);
            this.granters.add(PermissionServiceImpl.this.getAllPermissionReference());
            this.granters.add(OLD_ALL_PERMISSIONS_REFERENCE);
        }

        boolean evaluate(Set<String> authorisations, NodeRef nodeRef) {
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            return this.evaluate(authorisations, nodeRef, denied, null);
        }

        boolean evaluate(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied, MutableBoolean recursiveIn) {
            NodePermissionEntry nodePermissions;
            ChildAssociationRef car;
            MutableBoolean recursiveOut = null;
            HashSet<Pair<String, PermissionReference>> locallyDenied = new HashSet<Pair<String, PermissionReference>>();
            locallyDenied.addAll(denied);
            locallyDenied.addAll(this.getDenied(nodeRef));
            boolean success = true;
            if (this.required.equals(PermissionServiceImpl.this.getPermissionReference("All")) || PermissionServiceImpl.this.modelDAO.checkPermission(this.required)) {
                if (this.parentRequirements.contains(this.required)) {
                    if (this.checkGlobalPermissions(authorisations) || this.checkRequired(authorisations, nodeRef, locallyDenied)) {
                        recursiveOut = null;
                        if (recursiveIn != null) {
                            recursiveIn.setValue(true);
                        }
                    } else {
                        recursiveOut = new MutableBoolean(false);
                    }
                } else {
                    success &= this.hasSinglePermission(authorisations, nodeRef);
                }
                if (!success) {
                    return false;
                }
            }
            for (PermissionReference pr : this.nodeRequirements) {
                NodeTest nt = new NodeTest(pr, this.typeQName, this.aspectQNames);
                if (success &= nt.evaluate(authorisations, nodeRef, locallyDenied, null)) continue;
                return false;
            }
            if (success && (car = PermissionServiceImpl.this.nodeService.getPrimaryParent(nodeRef)).getParentRef() != null && ((nodePermissions = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(car.getChildRef())) == null || nodePermissions.inheritPermissions())) {
                locallyDenied.addAll(this.getDenied(car.getParentRef()));
                for (PermissionReference pr : this.parentRequirements) {
                    if (pr.equals(this.required)) {
                        success &= this.evaluate(authorisations, car.getParentRef(), locallyDenied, recursiveOut);
                        if (recursiveOut != null && recursiveOut.getValue() && recursiveIn != null) {
                            recursiveIn.setValue(true);
                        }
                    } else {
                        NodeTest nt = new NodeTest(pr, this.typeQName, this.aspectQNames);
                        success &= nt.evaluate(authorisations, car.getParentRef(), locallyDenied, null);
                    }
                    if (success) continue;
                    return false;
                }
            }
            if (recursiveOut != null && !recursiveOut.getValue()) {
                return false;
            }
            if (this.childrenRequirements.size() > 0) {
                List<ChildAssociationRef> childAssocRefs = PermissionServiceImpl.this.nodeService.getChildAssocs(nodeRef);
                for (PermissionReference pr : this.childrenRequirements) {
                    for (ChildAssociationRef child : childAssocRefs) {
                        if (success &= PermissionServiceImpl.this.hasPermission(child.getChildRef(), pr) == AccessStatus.ALLOWED) continue;
                        return false;
                    }
                }
            }
            return success;
        }

        public boolean hasSinglePermission(Set<String> authorisations, NodeRef nodeRef) {
            if (this.checkGlobalPermissions(authorisations)) {
                return true;
            }
            HashSet<Pair<String, PermissionReference>> denied = new HashSet<Pair<String, PermissionReference>>();
            ChildAssociationRef car = PermissionServiceImpl.this.nodeService.getPrimaryParent(nodeRef);
            while (car != null) {
                denied.addAll(this.getDenied(car.getChildRef()));
                if (this.checkRequired(authorisations, car.getChildRef(), denied)) {
                    return true;
                }
                if (car.getParentRef() != null) {
                    NodePermissionEntry nodePermissions = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(car.getChildRef());
                    if (nodePermissions == null || nodePermissions.inheritPermissions()) {
                        car = PermissionServiceImpl.this.nodeService.getPrimaryParent(car.getParentRef());
                        continue;
                    }
                    car = null;
                    continue;
                }
                car = null;
            }
            return false;
        }

        private boolean checkGlobalPermissions(Set<String> authorisations) {
            for (PermissionEntry permissionEntry : PermissionServiceImpl.this.modelDAO.getGlobalPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations, null)) continue;
                return true;
            }
            return false;
        }

        Set<Pair<String, PermissionReference>> getDenied(NodeRef nodeRef) {
            HashSet<Pair<String, PermissionReference>> deniedSet = new HashSet<Pair<String, PermissionReference>>();
            NodePermissionEntry nodeEntry = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
            if (nodeEntry != null) {
                for (PermissionEntry permissionEntry : nodeEntry.getPermissionEntries()) {
                    if (!permissionEntry.isDenied()) continue;
                    Set<PermissionReference> granters = PermissionServiceImpl.this.modelDAO.getGrantingPermissions(permissionEntry.getPermissionReference());
                    for (PermissionReference granter : granters) {
                        deniedSet.add(new Pair<String, PermissionReference>(permissionEntry.getAuthority(), granter));
                    }
                    Set<PermissionReference> grantees = PermissionServiceImpl.this.modelDAO.getGranteePermissions(permissionEntry.getPermissionReference());
                    for (PermissionReference grantee : grantees) {
                        deniedSet.add(new Pair<String, PermissionReference>(permissionEntry.getAuthority(), grantee));
                    }
                    if (!permissionEntry.getPermissionReference().equals(PermissionServiceImpl.this.getAllPermissionReference()) && !permissionEntry.getPermissionReference().equals(OLD_ALL_PERMISSIONS_REFERENCE)) continue;
                    for (PermissionReference deny : PermissionServiceImpl.this.modelDAO.getAllPermissions(nodeRef)) {
                        deniedSet.add(new Pair<String, PermissionReference>(permissionEntry.getAuthority(), deny));
                    }
                }
            }
            return deniedSet;
        }

        boolean checkRequired(Set<String> authorisations, NodeRef nodeRef, Set<Pair<String, PermissionReference>> denied) {
            NodePermissionEntry nodeEntry = PermissionServiceImpl.this.permissionsDaoComponent.getPermissions(nodeRef);
            if (nodeEntry == null) {
                return false;
            }
            for (PermissionEntry permissionEntry : nodeEntry.getPermissionEntries()) {
                if (!this.isGranted(permissionEntry, authorisations, denied)) continue;
                return true;
            }
            return false;
        }

        private boolean isGranted(PermissionEntry pe, Set<String> authorisations, Set<Pair<String, PermissionReference>> denied) {
            Pair<String, PermissionReference> specific;
            if (pe.isDenied()) {
                return false;
            }
            if (denied != null && denied.contains(specific = new Pair<String, PermissionReference>(pe.getAuthority(), this.required))) {
                return false;
            }
            return authorisations.contains(pe.getAuthority()) && this.granters.contains(pe.getPermissionReference());
        }
    }

    private class AccessPermissionImpl
    implements AccessPermission {
        private String permission;
        private AccessStatus accessStatus;
        private String authority;
        private AuthorityType authorityType;

        AccessPermissionImpl(String permission, AccessStatus accessStatus, String authority) {
            this.permission = permission;
            this.accessStatus = accessStatus;
            this.authority = authority;
            this.authorityType = AuthorityType.getAuthorityType(authority);
        }

        public String getPermission() {
            return this.permission;
        }

        public AccessStatus getAccessStatus() {
            return this.accessStatus;
        }

        public String getAuthority() {
            return this.authority;
        }

        public AuthorityType getAuthorityType() {
            return this.authorityType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AccessPermissionImpl)) {
                return false;
            }
            AccessPermissionImpl other = (AccessPermissionImpl)o;
            return this.getPermission().equals(other.getPermission()) && this.getAccessStatus() == other.getAccessStatus() && this.getAccessStatus().equals((Object)other.getAccessStatus());
        }

        public int hashCode() {
            return (this.authority.hashCode() * 37 + this.permission.hashCode()) * 37 + this.accessStatus.hashCode();
        }
    }
}

