/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.util.HashSet;
import java.util.Set;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.PermissionServiceImpl;
import org.alfresco.repo.security.permissions.impl.SimpleNodePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionServiceTest
extends AbstractPermissionTest {
    private SimplePermissionEntry denyAndyAll;
    private SimplePermissionEntry allowAndyAll;
    private SimplePermissionEntry denyAndyRead;
    private SimplePermissionEntry allowAndyRead;
    private SimplePermissionEntry denyAndyReadProperties;
    private SimplePermissionEntry allowAndyReadProperties;
    private SimplePermissionEntry allowAndyReadChildren;

    public void testAuthenticatedRoleIsPresent() {
        this.runAs("andy");
        Authentication auth = this.authenticationComponent.getCurrentAuthentication();
        for (GrantedAuthority authority : auth.getAuthorities()) {
            if (!authority.getAuthority().equals("ROLE_AUTHENTICATED")) continue;
            return;
        }
        PermissionServiceTest.fail((String)"Missing role ROLE_AUTHENTICATED ");
    }

    @Override
    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        this.denyAndyAll = new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "andy", AccessStatus.DENIED);
        this.allowAndyAll = new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "andy", AccessStatus.ALLOWED);
        this.denyAndyRead = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.DENIED);
        this.allowAndyRead = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED);
        this.denyAndyReadProperties = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED);
        this.allowAndyReadProperties = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED);
        this.allowAndyReadChildren = new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED);
    }

    public void testSetInheritFalse() {
        this.runAs("andy");
        this.permissionService.setInheritParentPermissions(this.rootNodeRef, false);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertFalse((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testSetInheritTrue() {
        this.runAs("andy");
        this.permissionService.setInheritParentPermissions(this.rootNodeRef, true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermissions(this.permissionService.getSetPermissions(this.rootNodeRef));
    }

    public void testAlterInherit() {
        this.runAs("andy");
        this.testSetInheritFalse();
        this.testSetInheritTrue();
        this.testSetInheritFalse();
        this.testSetInheritTrue();
        this.permissionService.deletePermissions(this.rootNodeRef);
    }

    public void testSetNodePermissionEntry() {
        this.runAs("andy");
        HashSet<SimplePermissionEntry> entries = new HashSet<SimplePermissionEntry>();
        entries.add(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName("A", "B"), "C"), "user-one", AccessStatus.ALLOWED));
        entries.add(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "user-two", AccessStatus.ALLOWED));
        entries.add(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName("D", "E"), "F"), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        entries.add(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        SimpleNodePermissionEntry entry = new SimpleNodePermissionEntry(this.rootNodeRef, false, entries);
        this.permissionService.setPermission(entry);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertFalse((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)4, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testSetNodePermissionEntry2() {
        HashSet<SimplePermissionEntry> entries = new HashSet<SimplePermissionEntry>();
        entries.add(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        SimpleNodePermissionEntry entry = new SimpleNodePermissionEntry(this.rootNodeRef, false, entries);
        this.permissionService.setPermission(entry);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertFalse((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testAlterNodePermissions() {
        this.testSetNodePermissionEntry();
        this.testSetNodePermissionEntry2();
        this.testSetNodePermissionEntry();
        this.testSetNodePermissionEntry2();
    }

    public void testDoubleSetAllowDeny() {
        Set<? extends PermissionEntry> permissionEntries = null;
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), false);
        this.permissionService.deletePermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission());
        permissionEntries = this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries();
        PermissionServiceTest.assertEquals((int)0, (int)permissionEntries.size());
        this.permissionService.setPermission(this.rootNodeRef, "andy", "Read", true);
        this.permissionService.setPermission(this.rootNodeRef, "andy", "Read", false);
        this.permissionService.deletePermission(this.rootNodeRef, "andy", "Read");
        permissionEntries = this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries();
        PermissionServiceTest.assertEquals((int)0, (int)permissionEntries.size());
    }

    public void testSetPermissionEntryElements() {
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        for (PermissionEntry permissionEntry : this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries()) {
            PermissionServiceTest.assertEquals((String)"andy", (String)permissionEntry.getAuthority());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.isAllowed());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getQName().equals(this.permissionService.getAllPermissionReference().getQName()));
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getName().equals(this.permissionService.getAllPermissionReference().getName()));
            PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)permissionEntry.getNodeRef());
        }
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.rootNodeRef, "other", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), false);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.rootNodeRef, "andy", "Read", false);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)3, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.rootNodeRef, "andy", "Read");
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission());
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.rootNodeRef, "other", this.permissionService.getAllPermission());
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testSetPermissionEntry() {
        this.permissionService.setPermission(this.allowAndyAll);
        this.permissionService.setPermission(this.rootNodeRef, "andy", this.permissionService.getAllPermission(), true);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        for (PermissionEntry permissionEntry : this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries()) {
            PermissionServiceTest.assertEquals((String)"andy", (String)permissionEntry.getAuthority());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.isAllowed());
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getQName().equals(this.permissionService.getAllPermissionReference().getQName()));
            PermissionServiceTest.assertTrue((boolean)permissionEntry.getPermissionReference().getName().equals(this.permissionService.getAllPermissionReference().getName()));
            PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)permissionEntry.getNodeRef());
        }
        this.permissionService.setPermission(this.allowAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "other", AccessStatus.ALLOWED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(this.denyAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName("A", "B"), "C"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)3, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, new SimplePermissionReference(QName.createQName("A", "B"), "C"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.denyAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), "other", AccessStatus.ALLOWED));
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
        this.permissionService.deletePermission(this.allowAndyAll);
        PermissionServiceTest.assertNotNull((Object)this.permissionService.getSetPermissions(this.rootNodeRef));
        PermissionServiceTest.assertTrue((boolean)this.permissionService.getSetPermissions(this.rootNodeRef).inheritPermissions());
        PermissionServiceTest.assertEquals((Object)this.rootNodeRef, (Object)this.permissionService.getSetPermissions(this.rootNodeRef).getNodeRef());
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getSetPermissions(this.rootNodeRef).getPermissionEntries().size());
    }

    public void testGetSettablePermissionsForType() {
        Set<String> answer = this.permissionService.getSettablePermissions(QName.createQName("sys", "base", this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)21, (int)answer.size());
        answer = this.permissionService.getSettablePermissions(QName.createQName("cm", "ownable", this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)0, (int)answer.size());
        answer = this.permissionService.getSettablePermissions(QName.createQName("cm", "content", this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)5, (int)answer.size());
        answer = this.permissionService.getSettablePermissions(QName.createQName("cm", "folder", this.namespacePrefixResolver));
        PermissionServiceTest.assertEquals((int)5, (int)answer.size());
    }

    public void testGetSettablePermissionsForNode() {
        QName ownable = QName.createQName("cm", "ownable", this.namespacePrefixResolver);
        Set<String> answer = this.permissionService.getSettablePermissions(this.rootNodeRef);
        PermissionServiceTest.assertEquals((int)25, (int)answer.size());
        this.nodeService.addAspect(this.rootNodeRef, ownable, null);
        answer = this.permissionService.getSettablePermissions(this.rootNodeRef);
        PermissionServiceTest.assertEquals((int)25, (int)answer.size());
        this.nodeService.removeAspect(this.rootNodeRef, ownable);
        answer = this.permissionService.getSettablePermissions(this.rootNodeRef);
        PermissionServiceTest.assertEquals((int)25, (int)answer.size());
    }

    public void testSimplePermissionOnRoot() {
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)25, (int)this.permissionService.getPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertEquals((int)0, (int)this.countGranted(this.permissionService.getPermissions(this.rootNodeRef)));
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)25, (int)this.permissionService.getPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertEquals((int)1, (int)this.countGranted(this.permissionService.getPermissions(this.rootNodeRef)));
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED));
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    private int countGranted(Set<AccessPermission> permissions) {
        int count = 0;
        for (AccessPermission ap : permissions) {
            if (ap.getAccessStatus() != AccessStatus.ALLOWED) continue;
            ++count;
        }
        return count;
    }

    public void testGlobalPermissionsForAdmin() {
        this.runAs("admin");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}two"), ContentModel.TYPE_CONTENT).getChildRef();
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "admin", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "admin", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "admin", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadContent"), "admin", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("All"), "admin", AccessStatus.DENIED));
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testPermissionGroupOnRoot() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)25, (int)this.permissionService.getPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertEquals((int)4, (int)this.countGranted(this.permissionService.getPermissions(this.rootNodeRef)));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("andy");
    }

    public void testSimplePermissionSimpleInheritance() {
        this.runAs("admin");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(this.allowAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyReadChildren);
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyReadProperties);
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyReadChildren);
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyReadProperties);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testPermissionGroupSimpleInheritance() {
        this.runAs("admin");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n1, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testDenySimplePermisionOnRootNode() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testDenyPermissionOnRootNOde() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testComplexDenyOnRootNode() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyReadProperties);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.allowAndyReadChildren);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testPerf() throws Exception {
        long end;
        long start;
        int i;
        this.runAs("admin");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n3 = this.nodeService.createNode(n2, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}three"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n4 = this.nodeService.createNode(n3, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}four"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n5 = this.nodeService.createNode(n4, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}five"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n6 = this.nodeService.createNode(n5, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}six"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n7 = this.nodeService.createNode(n6, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}seven"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n8 = this.nodeService.createNode(n7, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}eight"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n9 = this.nodeService.createNode(n8, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}nine"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n10 = this.nodeService.createNode(n9, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}ten"), ContentModel.TYPE_FOLDER).getChildRef();
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        long time = 0L;
        for (i = 0; i < 1000; ++i) {
            this.getSession().flush();
            start = System.nanoTime();
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n10, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            end = System.nanoTime();
            time += end - start;
        }
        System.out.println("Time is " + (double)time / 1.0E9);
        time = 0L;
        for (i = 0; i < 1000; ++i) {
            start = System.nanoTime();
            PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n10, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
            end = System.nanoTime();
            time += end - start;
        }
        System.out.println("Time is " + (double)time / 1.0E9);
    }

    public void testAllPermissions() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(this.allowAndyAll);
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyAll);
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testOldAllPermissions() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE, "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)1, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyRead);
        this.runAs("andy");
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.denyAndyAll);
        PermissionServiceTest.assertEquals((int)3, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("All")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, PermissionServiceImpl.OLD_ALL_PERMISSIONS_REFERENCE) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAuthenticatedAuthority() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAllAuthorities() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAllPermissionsAllAuthorities() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.permissionService.getAllPermissionReference(), this.permissionService.getAllAuthorities(), AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Write")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testGroupAndUserInteraction() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "ROLE_AUTHENTICATED", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testInheritPermissions() {
        this.runAs("admin");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setInheritParentPermissions(n2, false);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setInheritParentPermissions(n2, true);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAncestorRequirementAndInheritance() {
        this.runAs("admin");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}two"), ContentModel.TYPE_FOLDER).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), "andy", AccessStatus.DENIED));
        this.permissionService.setInheritParentPermissions(n2, false);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setInheritParentPermissions(n2, true);
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testEffectiveComposite() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testContentPermissions() {
        this.runAs("admin");
        NodeRef n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_FOLDER).getChildRef();
        NodeRef n2 = this.nodeService.createNode(n1, ContentModel.ASSOC_CONTAINS, QName.createQName("{namespace}two"), ContentModel.TYPE_CONTENT).getChildRef();
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n1, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(n2, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.deletePermission(new SimplePermissionEntry(n2, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.permissionService.deletePermission(new SimplePermissionEntry(n2, this.getPermission("ReadContent"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(n2, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(n2, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testAllPermissionSet() {
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("FullControl"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("FullControl"), "andy", AccessStatus.DENIED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadProperties"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.deletePermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("FullControl"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Read")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadProperties")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadContent")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testChildrenRequirements() {
        if (!this.personService.createMissingPeople()) {
            PermissionServiceTest.assertEquals((int)1, (int)this.nodeService.getChildAssocs(this.rootNodeRef).size());
        }
        this.runAs("andy");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Delete"), "andy", AccessStatus.ALLOWED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.systemNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Delete"), "andy", AccessStatus.DENIED));
        this.runAs("andy");
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertTrue((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("ReadChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.runAs("lemur");
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("Delete")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteChildren")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        PermissionServiceTest.assertFalse((this.permissionService.hasPermission(this.rootNodeRef, this.getPermission("DeleteNode")) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }

    public void testClearPermission() {
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "lemur", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "lemur", AccessStatus.ALLOWED));
        PermissionServiceTest.assertEquals((int)4, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.clearPermission(this.rootNodeRef, "andy");
        PermissionServiceTest.assertEquals((int)2, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
        this.permissionService.clearPermission(this.rootNodeRef, "lemur");
        PermissionServiceTest.assertEquals((int)0, (int)this.permissionService.getAllSetPermissions(this.rootNodeRef).size());
    }
}

