/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.acegisecurity.AccessDeniedException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLEntryAfterInvocationProvider
implements AfterInvocationProvider,
InitializingBean {
    private static Log log = LogFactory.getLog(ACLEntryAfterInvocationProvider.class);
    private static final String AFTER_ACL_NODE = "AFTER_ACL_NODE";
    private static final String AFTER_ACL_PARENT = "AFTER_ACL_PARENT";
    private PermissionService permissionService;
    private NamespacePrefixResolver nspr;
    private NodeService nodeService;
    private AuthenticationService authenticationService;

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.nspr;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver nspr) {
        this.nspr = nspr;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.permissionService == null) {
            throw new IllegalArgumentException("There must be a permission service");
        }
        if (this.nspr == null) {
            throw new IllegalArgumentException("There must be a namespace service");
        }
        if (this.nodeService == null) {
            throw new IllegalArgumentException("There must be a node service");
        }
        if (this.authenticationService == null) {
            throw new IllegalArgumentException("There must be an authentication service");
        }
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        if (log.isDebugEnabled()) {
            MethodInvocation mi = (MethodInvocation)object;
            log.debug((Object)("Method: " + mi.getMethod().toString()));
        }
        try {
            if (this.authenticationService.isCurrentUserTheSystemUser()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Allowing system user access");
                }
                return returnedObject;
            }
            if (returnedObject == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Allowing null object access");
                }
                return null;
            }
            if (StoreRef.class.isAssignableFrom(returnedObject.getClass())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Store access");
                }
                return this.decide(authentication, object, config, this.nodeService.getRootNode((StoreRef)returnedObject)).getStoreRef();
            }
            if (NodeRef.class.isAssignableFrom(returnedObject.getClass())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Node access");
                }
                return this.decide(authentication, object, config, (NodeRef)returnedObject);
            }
            if (FileInfo.class.isAssignableFrom(returnedObject.getClass())) {
                return this.decide(authentication, object, config, (FileInfo)returnedObject);
            }
            if (ChildAssociationRef.class.isAssignableFrom(returnedObject.getClass())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Child Association access");
                }
                return this.decide(authentication, object, config, (ChildAssociationRef)returnedObject);
            }
            if (ResultSet.class.isAssignableFrom(returnedObject.getClass())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Result Set access");
                }
                return this.decide(authentication, object, config, (ResultSet)returnedObject);
            }
            if (Collection.class.isAssignableFrom(returnedObject.getClass())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Collection Access");
                }
                return this.decide(authentication, object, config, (Collection)returnedObject);
            }
            if (returnedObject.getClass().isArray()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Array Access");
                }
                return this.decide(authentication, object, config, (Object[])returnedObject);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Uncontrolled object - access allowed for " + object.getClass().getName()));
            }
            return returnedObject;
        }
        catch (AccessDeniedException ade) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access denied");
                ade.printStackTrace();
            }
            throw ade;
        }
        catch (RuntimeException re) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Access denied by runtime exception");
                re.printStackTrace();
            }
            throw re;
        }
    }

    public NodeRef decide(Authentication authentication, Object object, ConfigAttributeDefinition config, NodeRef returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            NodeRef testNodeRef = null;
            if (cad.typeString.equals(AFTER_ACL_NODE)) {
                testNodeRef = returnedObject;
            } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                testNodeRef = this.nodeService.getPrimaryParent(returnedObject).getParentRef();
            }
            if (testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
            throw new AccessDeniedException("Access Denied");
        }
        return returnedObject;
    }

    public FileInfo decide(Authentication authentication, Object object, ConfigAttributeDefinition config, FileInfo returnedObject) throws AccessDeniedException {
        NodeRef nodeRef = returnedObject.getNodeRef();
        this.decide(authentication, object, config, nodeRef);
        return returnedObject;
    }

    private List<ConfigAttributeDefintion> extractSupportedDefinitions(ConfigAttributeDefinition config) {
        ArrayList<ConfigAttributeDefintion> definitions = new ArrayList<ConfigAttributeDefintion>();
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            definitions.add(new ConfigAttributeDefintion(attr));
        }
        return definitions;
    }

    public ChildAssociationRef decide(Authentication authentication, Object object, ConfigAttributeDefinition config, ChildAssociationRef returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        for (ConfigAttributeDefintion cad : supportedDefinitions) {
            NodeRef testNodeRef = null;
            if (cad.typeString.equals(AFTER_ACL_NODE)) {
                testNodeRef = returnedObject.getChildRef();
            } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                testNodeRef = returnedObject.getParentRef();
            }
            if (testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
            throw new AccessDeniedException("Access Denied");
        }
        return returnedObject;
    }

    public ResultSet decide(Authentication authentication, Object object, ConfigAttributeDefinition config, ResultSet returnedObject) throws AccessDeniedException {
        int i;
        if (returnedObject == null) {
            return null;
        }
        FilteringResultSet filteringResultSet = new FilteringResultSet(returnedObject);
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        Integer maxSize = null;
        if (returnedObject.getResultSetMetaData().getSearchParameters().getLimitBy() == LimitBy.FINAL_SIZE) {
            maxSize = new Integer(returnedObject.getResultSetMetaData().getSearchParameters().getLimit());
        }
        if (supportedDefinitions.size() == 0) {
            if (maxSize == null) {
                return returnedObject;
            }
            if (returnedObject.length() > maxSize) {
                for (i = 0; i < maxSize; ++i) {
                    filteringResultSet.setIncluded(i, true);
                }
                filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            } else {
                for (i = 0; i < maxSize; ++i) {
                    filteringResultSet.setIncluded(i, true);
                }
                filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            }
        }
        for (i = 0; i < returnedObject.length(); ++i) {
            filteringResultSet.setIncluded(i, true);
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                NodeRef testNodeRef = null;
                if (cad.typeString.equals(AFTER_ACL_NODE)) {
                    testNodeRef = returnedObject.getNodeRef(i);
                } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                    testNodeRef = returnedObject.getChildAssocRef(i).getParentRef();
                }
                if (!filteringResultSet.getIncluded(i) || testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
                filteringResultSet.setIncluded(i, false);
            }
            if (maxSize == null || filteringResultSet.length() <= maxSize) continue;
            filteringResultSet.setIncluded(i, false);
            filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.FINAL_SIZE, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
            return filteringResultSet;
        }
        filteringResultSet.setResultSetMetaData(new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, returnedObject.getResultSetMetaData().getSearchParameters()));
        return filteringResultSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Collection returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        HashSet removed = new HashSet();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entries are " + supportedDefinitions));
        }
        for (Object nextObject : returnedObject) {
            boolean allowed = true;
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                NodeRef testNodeRef = null;
                if (cad.typeString.equals(AFTER_ACL_NODE)) {
                    if (StoreRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = this.nodeService.getRootNode((StoreRef)nextObject);
                    } else if (NodeRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = (NodeRef)nextObject;
                    } else if (ChildAssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = ((ChildAssociationRef)nextObject).getChildRef();
                    } else {
                        if (!FileInfo.class.isAssignableFrom(nextObject.getClass())) throw new ACLEntryVoterException("The specified parameter is not a collection of NodeRefs, ChildAssociationRefs or FileInfos");
                        testNodeRef = ((FileInfo)nextObject).getNodeRef();
                    }
                } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                    if (StoreRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = null;
                    } else if (NodeRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = this.nodeService.getPrimaryParent((NodeRef)nextObject).getParentRef();
                    } else if (ChildAssociationRef.class.isAssignableFrom(nextObject.getClass())) {
                        testNodeRef = ((ChildAssociationRef)nextObject).getParentRef();
                    } else {
                        if (!FileInfo.class.isAssignableFrom(nextObject.getClass())) throw new ACLEntryVoterException("The specified parameter is not a collection of NodeRefs or ChildAssociationRefs");
                        testNodeRef = ((FileInfo)nextObject).getNodeRef();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\t" + cad.typeString + " test on " + testNodeRef + " from " + nextObject.getClass().getName()));
                }
                if (!allowed || testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
                allowed = false;
            }
            if (allowed) continue;
            removed.add(nextObject);
        }
        for (Object toRemove : removed) {
            while (returnedObject.remove(toRemove)) {
            }
        }
        return returnedObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object[] returnedObject) throws AccessDeniedException {
        BitSet incudedSet = new BitSet(returnedObject.length);
        if (returnedObject == null) {
            return null;
        }
        List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
        if (supportedDefinitions.size() == 0) {
            return returnedObject;
        }
        int l = returnedObject.length;
        for (int i = 0; i < l; ++i) {
            Object current = returnedObject[i];
            for (ConfigAttributeDefintion cad : supportedDefinitions) {
                incudedSet.set(i, true);
                NodeRef testNodeRef = null;
                if (cad.typeString.equals(AFTER_ACL_NODE)) {
                    if (StoreRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = this.nodeService.getRootNode((StoreRef)current);
                    } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = (NodeRef)current;
                    } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = ((ChildAssociationRef)current).getChildRef();
                    } else {
                        if (!FileInfo.class.isAssignableFrom(current.getClass())) throw new ACLEntryVoterException("The specified array is not of NodeRef or ChildAssociationRef");
                        testNodeRef = ((FileInfo)current).getNodeRef();
                    }
                } else if (cad.typeString.equals(AFTER_ACL_PARENT)) {
                    if (StoreRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = null;
                    } else if (NodeRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = this.nodeService.getPrimaryParent((NodeRef)current).getParentRef();
                    } else if (ChildAssociationRef.class.isAssignableFrom(current.getClass())) {
                        testNodeRef = ((ChildAssociationRef)current).getParentRef();
                    } else {
                        if (!FileInfo.class.isAssignableFrom(current.getClass())) throw new ACLEntryVoterException("The specified array is not of NodeRef or ChildAssociationRef");
                        testNodeRef = ((FileInfo)current).getNodeRef();
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\t" + cad.typeString + " test on " + testNodeRef + " from " + current.getClass().getName()));
                }
                if (!incudedSet.get(i) || testNodeRef == null || this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) continue;
                incudedSet.set(i, false);
            }
        }
        if (incudedSet.cardinality() == returnedObject.length) {
            return returnedObject;
        }
        Object[] answer = new Object[incudedSet.cardinality()];
        int i = incudedSet.nextSetBit(0);
        int p = 0;
        while (i >= 0) {
            answer[p] = returnedObject[i];
            ++i;
            i = incudedSet.nextSetBit(i);
            ++p;
        }
        return answer;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && (attribute.getAttribute().startsWith(AFTER_ACL_NODE) || attribute.getAttribute().startsWith(AFTER_ACL_PARENT));
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    private class ConfigAttributeDefintion {
        String typeString;
        SimplePermissionReference required;

        ConfigAttributeDefintion(ConfigAttribute attr) {
            StringTokenizer st = new StringTokenizer(attr.getAttribute(), ".", false);
            if (st.countTokens() != 3) {
                throw new ACLEntryVoterException("There must be three . separated tokens in each config attribute");
            }
            this.typeString = st.nextToken();
            String qNameString = st.nextToken();
            String permissionString = st.nextToken();
            if (!this.typeString.equals(ACLEntryAfterInvocationProvider.AFTER_ACL_NODE) && !this.typeString.equals(ACLEntryAfterInvocationProvider.AFTER_ACL_PARENT)) {
                throw new ACLEntryVoterException("Invalid type: must be ACL_NODE or ACL_PARENT");
            }
            QName qName = QName.createQName(qNameString, ACLEntryAfterInvocationProvider.this.nspr);
            this.required = new SimplePermissionReference(qName, permissionString);
        }
    }
}

