/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import net.sf.acegisecurity.vote.AccessDecisionVoter;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLEntryVoter
implements AccessDecisionVoter,
InitializingBean {
    private static Log log = LogFactory.getLog(ACLEntryVoter.class);
    private static final String ACL_NODE = "ACL_NODE";
    private static final String ACL_PARENT = "ACL_PARENT";
    private static final String ACL_ALLOW = "ACL_ALLOW";
    private static final String ACL_METHOD = "ACL_METHOD";
    private PermissionService permissionService;
    private NamespacePrefixResolver nspr;
    private NodeService nodeService;
    private AuthenticationService authenticationService;
    private AuthorityService authorityService;

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.nspr;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver nspr) {
        this.nspr = nspr;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.permissionService == null) {
            throw new IllegalArgumentException("There must be a permission service");
        }
        if (this.nspr == null) {
            throw new IllegalArgumentException("There must be a namespace service");
        }
        if (this.nodeService == null) {
            throw new IllegalArgumentException("There must be a node service");
        }
        if (this.authenticationService == null) {
            throw new IllegalArgumentException("There must be an authentication service");
        }
        if (this.authorityService == null) {
            throw new IllegalArgumentException("There must be an authority service");
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && (attribute.getAttribute().startsWith(ACL_NODE) || attribute.getAttribute().startsWith(ACL_PARENT) || attribute.getAttribute().startsWith(ACL_ALLOW) || attribute.getAttribute().startsWith(ACL_METHOD));
    }

    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        block28: {
            if (log.isDebugEnabled()) {
                MethodInvocation mi = (MethodInvocation)object;
                log.debug((Object)("Method: " + mi.getMethod().toString()));
            }
            if (this.authenticationService.isCurrentUserTheSystemUser()) {
                if (!log.isDebugEnabled()) return 1;
                log.debug((Object)"Access granted for the system user");
                return 1;
            }
            List<ConfigAttributeDefintion> supportedDefinitions = this.extractSupportedDefinitions(config);
            if (supportedDefinitions.size() == 0) {
                return 1;
            }
            MethodInvocation invocation = (MethodInvocation)object;
            Method method = invocation.getMethod();
            Class<?>[] params = method.getParameterTypes();
            Iterator<ConfigAttributeDefintion> i$ = supportedDefinitions.iterator();
            while (i$.hasNext()) {
                ConfigAttributeDefintion cad = i$.next();
                NodeRef testNodeRef = null;
                if (cad.typeString.equals(ACL_ALLOW)) {
                    return 1;
                }
                if (cad.typeString.equals(ACL_METHOD)) {
                    if (this.authenticationService.getCurrentUserName().equals(cad.authority)) {
                        return 1;
                    }
                    if (!this.authorityService.getAuthorities().contains(cad.authority)) return -1;
                    return 1;
                }
                if (cad.parameter >= invocation.getArguments().length) continue;
                if (cad.typeString.equals(ACL_NODE)) {
                    if (StoreRef.class.isAssignableFrom(params[cad.parameter])) {
                        if (invocation.getArguments()[cad.parameter] != null) {
                            StoreRef storeRef;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"\tPermission test against the store - using permissions on the root node");
                            }
                            if (this.nodeService.exists(storeRef = (StoreRef)invocation.getArguments()[cad.parameter])) {
                                testNodeRef = this.nodeService.getRootNode(storeRef);
                            }
                        }
                    } else if (NodeRef.class.isAssignableFrom(params[cad.parameter])) {
                        testNodeRef = (NodeRef)invocation.getArguments()[cad.parameter];
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                        }
                    } else {
                        if (!ChildAssociationRef.class.isAssignableFrom(params[cad.parameter])) throw new ACLEntryVoterException("The specified parameter is not a NodeRef or ChildAssociationRef");
                        if (invocation.getArguments()[cad.parameter] != null) {
                            testNodeRef = ((ChildAssociationRef)invocation.getArguments()[cad.parameter]).getChildRef();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\tPermission test on node " + this.nodeService.getPath(testNodeRef)));
                            }
                        }
                    }
                } else if (cad.typeString.equals(ACL_PARENT)) {
                    if (NodeRef.class.isAssignableFrom(params[cad.parameter])) {
                        NodeRef child = (NodeRef)invocation.getArguments()[cad.parameter];
                        if (child != null) {
                            testNodeRef = this.nodeService.getPrimaryParent(child).getParentRef();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\tPermission test for parent on node " + this.nodeService.getPath(testNodeRef)));
                            }
                        }
                    } else {
                        if (!ChildAssociationRef.class.isAssignableFrom(params[cad.parameter])) throw new ACLEntryVoterException("The specified parameter is not a ChildAssociationRef");
                        if (invocation.getArguments()[cad.parameter] != null) {
                            testNodeRef = ((ChildAssociationRef)invocation.getArguments()[cad.parameter]).getParentRef();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("\tPermission test for parent on child assoc ref for node " + this.nodeService.getPath(testNodeRef)));
                            }
                        }
                    }
                }
                if (testNodeRef == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"\t\tNode ref is not null");
                }
                if (this.permissionService.hasPermission(testNodeRef, cad.required.toString()) != AccessStatus.DENIED) {
                    continue;
                }
                break block28;
            }
            return 1;
        }
        if (!log.isDebugEnabled()) return -1;
        log.debug((Object)"\t\tPermission is denied");
        Thread.dumpStack();
        return -1;
    }

    private List<ConfigAttributeDefintion> extractSupportedDefinitions(ConfigAttributeDefinition config) {
        ArrayList<ConfigAttributeDefintion> definitions = new ArrayList<ConfigAttributeDefintion>();
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            definitions.add(new ConfigAttributeDefintion(attr));
        }
        return definitions;
    }

    private class ConfigAttributeDefintion {
        String typeString;
        SimplePermissionReference required;
        int parameter;
        String authority;

        ConfigAttributeDefintion(ConfigAttribute attr) {
            StringTokenizer st = new StringTokenizer(attr.getAttribute(), ".", false);
            if (st.countTokens() < 1) {
                throw new ACLEntryVoterException("There must be at least one token in a config attribute");
            }
            this.typeString = st.nextToken();
            if (!(this.typeString.equals(ACLEntryVoter.ACL_NODE) || this.typeString.equals(ACLEntryVoter.ACL_PARENT) || this.typeString.equals(ACLEntryVoter.ACL_ALLOW) || this.typeString.equals(ACLEntryVoter.ACL_METHOD))) {
                throw new ACLEntryVoterException("Invalid type: must be ACL_NODE, ACL_PARENT or ACL_ALLOW");
            }
            if (this.typeString.equals(ACLEntryVoter.ACL_NODE) || this.typeString.equals(ACLEntryVoter.ACL_PARENT)) {
                if (st.countTokens() != 3) {
                    throw new ACLEntryVoterException("There must be four . separated tokens in each config attribute");
                }
                String numberString = st.nextToken();
                String qNameString = st.nextToken();
                String permissionString = st.nextToken();
                this.parameter = Integer.parseInt(numberString);
                QName qName = QName.createQName(qNameString, ACLEntryVoter.this.nspr);
                this.required = new SimplePermissionReference(qName, permissionString);
            } else if (this.typeString.equals(ACLEntryVoter.ACL_METHOD)) {
                if (st.countTokens() != 1) {
                    throw new ACLEntryVoterException("There must be two . separated tokens in each group or role config attribute");
                }
                this.authority = st.nextToken();
            }
        }
    }
}

