/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoter;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.target.SingletonTargetSource;

public class ACLEntryVoterTest
extends AbstractPermissionTest {
    public void testBasicDenyNode() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            method.invoke(proxy, this.rootNodeRef);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            method.invoke(proxy, this.systemNodeRef);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.nodeService.deleteNode(this.systemNodeRef);
        ACLEntryVoterTest.assertNull((Object)method.invoke(proxy, this.systemNodeRef));
    }

    public void testBasicDenyStore() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneStoreRef", StoreRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            method.invoke(proxy, this.rootNodeRef.getStoreRef());
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testAllowNullNode() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[]{null});
    }

    public void testAllowNullStore() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneStoreRef", StoreRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[]{null});
    }

    public void testAllowNullParentOnRealChildAssoc() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_PARENT.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
    }

    public void testAllowNullParent() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_PARENT.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[]{null});
    }

    public void testAllowNullChild() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[]{null});
    }

    public void testBasicDenyChildAssocNode() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testBasicDenyParentAssocNode() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_PARENT.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testBasicAllowNode() throws Exception {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, this.rootNodeRef);
    }

    public void testBasicAllow() throws Exception {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_ALLOW")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, this.rootNodeRef);
    }

    public void testBasicAllowStore() throws Exception {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneStoreRef", StoreRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, this.rootNodeRef.getStoreRef());
    }

    public void testBasicAllowChildAssocNode() throws Exception {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
    }

    public void testBasicAllowParentAssocNode() throws Exception {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_PARENT.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
    }

    public void testDenyParentAssocNode() throws Exception {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_PARENT.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void testAllowChildAssocNode() throws Exception {
        this.runAs("andy");
        this.permissionService.setPermission(new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), "andy", AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
    }

    public void testMultiNodeMethodsArg0() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, this.rootNodeRef, null, null, null);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, this.rootNodeRef, null, null, null);
    }

    public void testMultiNodeMethodsArg1() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.1.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, null, this.rootNodeRef, null, null);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, null, this.rootNodeRef, null, null);
    }

    public void testMultiNodeMethodsArg2() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.2.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, null, null, this.rootNodeRef, null);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, null, null, this.rootNodeRef, null);
    }

    public void testMultiNodeMethodsArg3() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.3.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, null, null, null, this.rootNodeRef);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, null, null, null, this.rootNodeRef);
    }

    public void testMultiChildAssocRefMethodsArg0() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.0.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef), null, null, null);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef), null, null, null);
    }

    public void testMultiChildAssocRefMethodsArg1() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.1.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, null, this.nodeService.getPrimaryParent(this.rootNodeRef), null, null);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, null, this.nodeService.getPrimaryParent(this.rootNodeRef), null, null);
    }

    public void testMultiChildAssocRefMethodsArg2() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.2.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, null, null, this.nodeService.getPrimaryParent(this.rootNodeRef), null);
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, null, null, this.nodeService.getPrimaryParent(this.rootNodeRef), null);
    }

    public void testMultiChildAssocRefMethodsArg3() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_NODE.3.sys:base.Read")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, null, null, null, null);
        try {
            method.invoke(proxy, null, null, null, this.nodeService.getPrimaryParent(this.rootNodeRef));
            ACLEntryVoterTest.assertNotNull(null);
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        this.permissionService.setPermission(new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), "andy", AccessStatus.ALLOWED));
        method.invoke(proxy, null, null, null, this.nodeService.getPrimaryParent(this.rootNodeRef));
    }

    public void testMethodACL() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testMethod", new Class[0]);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_METHOD.andy")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[0]);
    }

    public void testMethodACL2() throws Exception {
        this.runAs("andy");
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testMethod", new Class[0]);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_METHOD.GROUP_EVERYONE")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[0]);
    }

    public class Interceptor
    implements MethodInterceptor {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();

        Interceptor(final String config) {
            this.cad.addConfigAttribute(new ConfigAttribute(){
                private static final long serialVersionUID = 1L;

                public String getAttribute() {
                    return config;
                }
            });
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            ACLEntryVoter voter = new ACLEntryVoter();
            voter.setNamespacePrefixResolver(ACLEntryVoterTest.this.namespacePrefixResolver);
            voter.setPermissionService(ACLEntryVoterTest.this.permissionService);
            voter.setNodeService(ACLEntryVoterTest.this.nodeService);
            voter.setAuthenticationService(ACLEntryVoterTest.this.authenticationService);
            voter.setAuthorityService(ACLEntryVoterTest.this.authorityService);
            if (voter.vote(null, invocation, this.cad) != -1) {
                return invocation.proceed();
            }
            throw new ACLEntryVoterException("Access denied");
        }
    }

    public static class ClassWithMethods {
        public void testMethod() {
        }

        public void testOneStoreRef(StoreRef storeRef) {
        }

        public void testOneNodeRef(NodeRef nodeRef) {
        }

        public void testManyNodeRef(NodeRef nodeRef1, NodeRef nodeRef2, NodeRef nodeRef3, NodeRef nodeRef4) {
        }

        public void testOneChildAssociationRef(ChildAssociationRef car) {
        }

        public void testManyChildAssociationRef(ChildAssociationRef car1, ChildAssociationRef car2, ChildAssociationRef car3, ChildAssociationRef car4) {
        }
    }
}

