/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.alfresco.repo.search.ResultSetRowIterator;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryAfterInvocationProvider;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringResultSet
extends ACLEntryAfterInvocationProvider
implements ResultSet {
    private ResultSet unfiltered;
    private BitSet inclusionMask;
    private ResultSetMetaData resultSetMetaData;

    FilteringResultSet(ResultSet unfiltered) {
        this.unfiltered = unfiltered;
        this.inclusionMask = new BitSet(unfiltered.length());
    }

    ResultSet getUnFilteredResultSet() {
        return this.unfiltered;
    }

    void setIncluded(int i, boolean excluded) {
        this.inclusionMask.set(i, excluded);
    }

    boolean getIncluded(int i) {
        return this.inclusionMask.get(i);
    }

    @Override
    public Path[] getPropertyPaths() {
        return this.unfiltered.getPropertyPaths();
    }

    @Override
    public int length() {
        return this.inclusionMask.cardinality();
    }

    private int translateIndex(int n) {
        if (n > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        int count = -1;
        int l = this.unfiltered.length();
        for (int i = 0; i < l; ++i) {
            if (this.inclusionMask.get(i)) {
                ++count;
            }
            if (count != n) continue;
            return i;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public NodeRef getNodeRef(int n) {
        return this.unfiltered.getNodeRef(this.translateIndex(n));
    }

    @Override
    public float getScore(int n) {
        return this.unfiltered.getScore(this.translateIndex(n));
    }

    @Override
    public void close() {
        this.unfiltered.close();
    }

    @Override
    public ResultSetRow getRow(int i) {
        return this.unfiltered.getRow(this.translateIndex(i));
    }

    @Override
    public List<NodeRef> getNodeRefs() {
        List<NodeRef> answer = this.unfiltered.getNodeRefs();
        for (int i = this.unfiltered.length() - 1; i >= 0; --i) {
            if (this.inclusionMask.get(i)) continue;
            answer.remove(i);
        }
        return answer;
    }

    @Override
    public List<ChildAssociationRef> getChildAssocRefs() {
        List<ChildAssociationRef> answer = this.unfiltered.getChildAssocRefs();
        for (int i = this.unfiltered.length() - 1; i >= 0; --i) {
            if (this.inclusionMask.get(i)) continue;
            answer.remove(i);
        }
        return answer;
    }

    @Override
    public ChildAssociationRef getChildAssocRef(int n) {
        return this.unfiltered.getChildAssocRef(this.translateIndex(n));
    }

    @Override
    public ListIterator<ResultSetRow> iterator() {
        return new FilteringIterator();
    }

    @Override
    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public void setResultSetMetaData(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
    }

    class FilteringIterator
    implements ResultSetRowIterator {
        int underlyingPosition = -1;

        FilteringIterator() {
        }

        public boolean hasNext() {
            return FilteringResultSet.this.inclusionMask.nextSetBit(this.underlyingPosition + 1) != -1;
        }

        public ResultSetRow next() {
            this.underlyingPosition = FilteringResultSet.this.inclusionMask.nextSetBit(this.underlyingPosition + 1);
            if (this.underlyingPosition == -1) {
                throw new IllegalStateException();
            }
            return FilteringResultSet.this.unfiltered.getRow(this.underlyingPosition);
        }

        public boolean hasPrevious() {
            if (this.underlyingPosition <= 0) {
                return false;
            }
            for (int i = this.underlyingPosition - 1; i >= 0; --i) {
                if (!FilteringResultSet.this.inclusionMask.get(i)) continue;
                return true;
            }
            return false;
        }

        public ResultSetRow previous() {
            if (this.underlyingPosition <= 0) {
                throw new IllegalStateException();
            }
            for (int i = this.underlyingPosition - 1; i >= 0; --i) {
                if (!FilteringResultSet.this.inclusionMask.get(i)) continue;
                this.underlyingPosition = i;
                return FilteringResultSet.this.unfiltered.getRow(this.underlyingPosition);
            }
            throw new IllegalStateException();
        }

        public int nextIndex() {
            return FilteringResultSet.this.inclusionMask.nextSetBit(this.underlyingPosition + 1);
        }

        public int previousIndex() {
            if (this.underlyingPosition <= 0) {
                return -1;
            }
            for (int i = this.underlyingPosition - 1; i >= 0; --i) {
                if (!FilteringResultSet.this.inclusionMask.get(i)) continue;
                return i;
            }
            return -1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(ResultSetRow o) {
            throw new UnsupportedOperationException();
        }

        public void add(ResultSetRow o) {
            throw new UnsupportedOperationException();
        }
    }
}

