/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.results.ChildAssocRefResultSet;
import org.alfresco.repo.security.permissions.impl.acegi.FilteringResultSet;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.namespace.QName;

public class FilteringResultSetTest
extends TestCase {
    public FilteringResultSetTest() {
    }

    public FilteringResultSetTest(String arg0) {
        super(arg0);
    }

    public void test() {
        int i;
        StoreRef storeRef = new StoreRef("protocol", "test");
        NodeRef root = new NodeRef(storeRef, "n0");
        NodeRef n1 = new NodeRef(storeRef, "n1");
        NodeRef n2 = new NodeRef(storeRef, "n2");
        NodeRef n3 = new NodeRef(storeRef, "n3");
        NodeRef n4 = new NodeRef(storeRef, "n4");
        NodeRef n5 = new NodeRef(storeRef, "n5");
        ArrayList<ChildAssociationRef> cars = new ArrayList<ChildAssociationRef>();
        ChildAssociationRef car0 = new ChildAssociationRef(null, null, null, root);
        ChildAssociationRef car1 = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, root, QName.createQName("{test}n2"), n1);
        ChildAssociationRef car2 = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, n1, QName.createQName("{test}n3"), n2);
        ChildAssociationRef car3 = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, n2, QName.createQName("{test}n4"), n3);
        ChildAssociationRef car4 = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, n3, QName.createQName("{test}n5"), n4);
        ChildAssociationRef car5 = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, n4, QName.createQName("{test}n6"), n5);
        cars.add(car0);
        cars.add(car1);
        cars.add(car2);
        cars.add(car3);
        cars.add(car4);
        cars.add(car5);
        ChildAssocRefResultSet in = new ChildAssocRefResultSet(null, cars, null);
        FilteringResultSet filtering = new FilteringResultSet(in);
        FilteringResultSetTest.assertEquals((int)0, (int)filtering.length());
        for (i = 0; i < 6; ++i) {
            filtering.setIncluded(i, true);
            FilteringResultSetTest.assertEquals((int)1, (int)filtering.length());
            FilteringResultSetTest.assertEquals((String)("n" + i), (String)filtering.getNodeRef(0).getId());
            filtering.setIncluded(i, false);
            FilteringResultSetTest.assertEquals((int)0, (int)filtering.length());
        }
        for (i = 0; i < 6; ++i) {
            filtering.setIncluded(i, true);
            FilteringResultSetTest.assertEquals((int)(i + 1), (int)filtering.length());
            FilteringResultSetTest.assertEquals((String)("n" + i), (String)filtering.getNodeRef(i).getId());
        }
        int count = 0;
        for (ResultSetRow row : filtering) {
            FilteringResultSetTest.assertNotNull((Object)row);
            FilteringResultSetTest.assertTrue((count < 6 ? 1 : 0) != 0);
            ++count;
        }
        ResultSetRow last = null;
        Iterator it = filtering.iterator();
        while (it.hasNext()) {
            ResultSetRow row = (ResultSetRow)it.next();
            if (last != null) {
                FilteringResultSetTest.assertTrue((boolean)it.hasPrevious());
                ResultSetRow previous = (ResultSetRow)it.previous();
                FilteringResultSetTest.assertEquals((int)last.getIndex(), (int)previous.getIndex());
                row = (ResultSetRow)it.next();
            } else {
                FilteringResultSetTest.assertFalse((boolean)it.hasPrevious());
            }
            last = row;
        }
    }
}

