/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.hibernate;

import java.io.Serializable;
import org.alfresco.repo.domain.DbAccessControlEntry;
import org.alfresco.repo.domain.DbAccessControlList;
import org.alfresco.repo.domain.DbAuthority;
import org.alfresco.repo.domain.DbPermission;
import org.alfresco.repo.domain.Node;
import org.alfresco.repo.domain.Store;
import org.alfresco.repo.domain.hibernate.DbAccessControlEntryImpl;
import org.alfresco.repo.domain.hibernate.DbAccessControlListImpl;
import org.alfresco.repo.domain.hibernate.DbAuthorityImpl;
import org.alfresco.repo.domain.hibernate.DbPermissionImpl;
import org.alfresco.repo.node.db.NodeDaoService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.hibernate.ObjectDeletedException;

public class HibernatePermissionTest
extends BaseSpringTest {
    private NodeDaoService nodeDaoService;
    private Node node;
    private QName qname;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeDaoService = (NodeDaoService)this.applicationContext.getBean("nodeDaoService");
        Store store = this.nodeDaoService.createStore("workspace", this.getName() + "_" + System.currentTimeMillis());
        this.qname = QName.createQName("http://www.alfresco.org", this.getName());
        this.node = this.nodeDaoService.newNode(store, GUID.generate(), this.qname);
    }

    protected void onTearDownInTransaction() {
        try {
            this.getSession().flush();
            this.getSession().clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void testSimpleAccessControlList() throws Exception {
        DbAccessControlList accessControlList = new DbAccessControlListImpl();
        accessControlList.setInherits(true);
        Serializable id = this.getSession().save((Object)accessControlList);
        this.node.setAccessControlList(accessControlList);
        accessControlList = (DbAccessControlList)this.getSession().load(DbAccessControlListImpl.class, id);
        HibernatePermissionTest.assertNotNull((String)"Access control list not found", (Object)accessControlList);
        HibernatePermissionTest.assertTrue((boolean)accessControlList.getInherits());
        accessControlList.setInherits(false);
        id = this.getSession().save((Object)accessControlList);
        accessControlList = (DbAccessControlList)this.getSession().load(DbAccessControlListImpl.class, id);
        HibernatePermissionTest.assertNotNull((String)"Node not found", (Object)accessControlList);
        HibernatePermissionTest.assertFalse((boolean)accessControlList.getInherits());
    }

    public void testSimplePermission() {
        DbPermission permission = new DbPermissionImpl();
        permission.setTypeQname(this.qname);
        permission.setName("Test");
        Serializable id = this.getSession().save((Object)permission);
        permission = (DbPermission)this.getSession().load(DbPermissionImpl.class, id);
        HibernatePermissionTest.assertNotNull((String)"Permission not found", (Object)permission);
        HibernatePermissionTest.assertEquals((Object)this.qname, (Object)permission.getTypeQname());
    }

    public void testSimpleAuthority() {
        DbAuthority authority = new DbAuthorityImpl();
        authority.setRecipient("Test");
        authority.getExternalKeys().add("One");
        Serializable id = this.getSession().save((Object)authority);
        authority = (DbAuthority)this.getSession().load(DbAuthorityImpl.class, id);
        HibernatePermissionTest.assertNotNull((String)"Node not found", (Object)authority);
        HibernatePermissionTest.assertEquals((String)"Test", (String)authority.getRecipient());
        HibernatePermissionTest.assertEquals((int)1, (int)authority.getExternalKeys().size());
        authority.getExternalKeys().add("Two");
        id = this.getSession().save((Object)authority);
        authority = (DbAuthority)this.getSession().load(DbAuthorityImpl.class, id);
        HibernatePermissionTest.assertNotNull((String)"Node not found", (Object)authority);
        HibernatePermissionTest.assertEquals((String)"Test", (String)authority.getRecipient());
        HibernatePermissionTest.assertEquals((int)2, (int)authority.getExternalKeys().size());
        authority.getExternalKeys().add("Three");
        authority.getExternalKeys().remove("One");
        authority.getExternalKeys().remove("Two");
        id = this.getSession().save((Object)authority);
        authority = (DbAuthority)this.getSession().load(DbAuthorityImpl.class, id);
        HibernatePermissionTest.assertNotNull((String)"Node not found", (Object)authority);
        HibernatePermissionTest.assertEquals((String)"Test", (String)authority.getRecipient());
        HibernatePermissionTest.assertEquals((int)1, (int)authority.getExternalKeys().size());
    }

    public void testAccessControlList() {
        DbAccessControlListImpl accessControlList = new DbAccessControlListImpl();
        accessControlList.setInherits(true);
        Serializable nodeAclId = this.getSession().save((Object)accessControlList);
        this.node.setAccessControlList(accessControlList);
        DbAuthorityImpl recipient = new DbAuthorityImpl();
        recipient.setRecipient("Test");
        recipient.getExternalKeys().add("One");
        this.getSession().save((Object)recipient);
        DbPermissionImpl permission = new DbPermissionImpl();
        permission.setTypeQname(this.qname);
        permission.setName("Test");
        this.getSession().save((Object)permission);
        DbAccessControlEntry accessControlEntry = accessControlList.newEntry(permission, recipient, true);
        Long aceEntryId = accessControlEntry.getId();
        HibernatePermissionTest.assertNotNull((String)"Entry is still transient", (Object)aceEntryId);
        accessControlEntry = (DbAccessControlEntry)this.getSession().load(DbAccessControlEntryImpl.class, (Serializable)aceEntryId);
        HibernatePermissionTest.assertNotNull((String)"Permission entry not found", (Object)accessControlEntry);
        HibernatePermissionTest.assertTrue((boolean)accessControlEntry.isAllowed());
        HibernatePermissionTest.assertNotNull((Object)accessControlEntry.getAccessControlList());
        HibernatePermissionTest.assertTrue((boolean)accessControlEntry.getAccessControlList().getInherits());
        HibernatePermissionTest.assertNotNull((Object)accessControlEntry.getPermission());
        HibernatePermissionTest.assertEquals((String)"Test", (String)accessControlEntry.getPermission().getKey().getName());
        HibernatePermissionTest.assertNotNull((Object)accessControlEntry.getAuthority());
        HibernatePermissionTest.assertEquals((String)"Test", (String)accessControlEntry.getAuthority().getRecipient());
        HibernatePermissionTest.assertEquals((int)1, (int)accessControlEntry.getAuthority().getExternalKeys().size());
        this.node.setAccessControlList(null);
        this.getSession().delete((Object)accessControlList);
        try {
            this.getSession().get(DbAccessControlListImpl.class, nodeAclId);
            HibernatePermissionTest.fail((String)"Access control list was not deleted");
        }
        catch (ObjectDeletedException e) {
            // empty catch block
        }
        try {
            this.getSession().get(DbAccessControlEntryImpl.class, (Serializable)aceEntryId);
            HibernatePermissionTest.fail((String)"Access control entries were not cascade deleted");
        }
        catch (ObjectDeletedException e) {
            // empty catch block
        }
    }
}

