/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.model.GlobalPermissionEntry;
import org.alfresco.repo.security.permissions.impl.model.Permission;
import org.alfresco.repo.security.permissions.impl.model.PermissionGroup;
import org.alfresco.repo.security.permissions.impl.model.PermissionModelException;
import org.alfresco.repo.security.permissions.impl.model.PermissionSet;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionModel
implements ModelDAO,
InitializingBean {
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private static final String NAMESPACES = "namespaces";
    private static final String NAMESPACE = "namespace";
    private static final String NAMESPACE_URI = "uri";
    private static final String NAMESPACE_PREFIX = "prefix";
    private static final String PERMISSION_SET = "permissionSet";
    private static final String GLOBAL_PERMISSION = "globalPermission";
    private static final String DENY = "deny";
    private static final String ALLOW = "allow";
    private static final String DEFAULT_PERMISSION = "defaultPermission";
    private String model;
    private Map<QName, PermissionSet> permissionSets = new HashMap<QName, PermissionSet>();
    private Set<GlobalPermissionEntry> globalPermissions = new HashSet<GlobalPermissionEntry>();
    private AccessStatus defaultPermission;
    private HashMap<PermissionReference, Set<PermissionReference>> grantingPermissions = new HashMap();
    private HashMap<PermissionReference, Set<PermissionReference>> granteePermissions = new HashMap();
    private HashMap<PermissionGroup, PermissionGroup> groupsToBaseGroup = new HashMap();
    private HashMap<String, PermissionReference> uniqueMap;
    private HashMap<PermissionReference, Permission> permissionMap;
    private HashMap<PermissionReference, PermissionGroup> permissionGroupMap;
    private HashMap<String, PermissionReference> permissionReferenceMap;

    public void setModel(String model) {
        this.model = model;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterPropertiesSet() {
        Document document = this.createDocument(this.model);
        Element root = document.getRootElement();
        Attribute defaultPermissionAttribute = root.attribute(DEFAULT_PERMISSION);
        if (defaultPermissionAttribute != null) {
            if (defaultPermissionAttribute.getStringValue().equalsIgnoreCase(ALLOW)) {
                this.defaultPermission = AccessStatus.ALLOWED;
            } else {
                if (!defaultPermissionAttribute.getStringValue().equalsIgnoreCase(DENY)) throw new PermissionModelException("The default permission must be deny or allow");
                this.defaultPermission = AccessStatus.DENIED;
            }
        } else {
            this.defaultPermission = AccessStatus.DENIED;
        }
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver();
        Iterator nsit = root.elementIterator(NAMESPACES);
        while (nsit.hasNext()) {
            Element namespacesElement = (Element)nsit.next();
            Iterator it = namespacesElement.elementIterator(NAMESPACE);
            while (it.hasNext()) {
                Element nameSpaceElement = (Element)it.next();
                nspr.registerNamespace(nameSpaceElement.attributeValue(NAMESPACE_PREFIX), nameSpaceElement.attributeValue(NAMESPACE_URI));
            }
        }
        Iterator psit = root.elementIterator(PERMISSION_SET);
        while (psit.hasNext()) {
            Element permissionSetElement = (Element)psit.next();
            PermissionSet permissionSet = new PermissionSet();
            permissionSet.initialise(permissionSetElement, nspr, this);
            this.permissionSets.put(permissionSet.getQName(), permissionSet);
        }
        this.buildUniquePermissionMap();
        Iterator npit = root.elementIterator(GLOBAL_PERMISSION);
        while (npit.hasNext()) {
            Element globalPermissionElement = (Element)npit.next();
            GlobalPermissionEntry globalPermission = new GlobalPermissionEntry();
            globalPermission.initialise(globalPermissionElement, nspr, this);
            this.globalPermissions.add(globalPermission);
        }
    }

    private Document createDocument(String model) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(model);
        if (is == null) {
            throw new PermissionModelException("File not found: " + model);
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(is);
            is.close();
            return document;
        }
        catch (DocumentException e) {
            throw new PermissionModelException("Failed to create permission model document ", e);
        }
        catch (IOException e) {
            throw new PermissionModelException("Failed to close permission model document ", e);
        }
    }

    public AccessStatus getDefaultPermission() {
        return this.defaultPermission;
    }

    public AccessStatus getDefaultPermission(PermissionReference pr) {
        Permission p = this.permissionMap.get(pr);
        if (p == null) {
            return this.defaultPermission;
        }
        return p.getDefaultPermission();
    }

    @Override
    public Set<? extends PermissionEntry> getGlobalPermissionEntries() {
        return Collections.unmodifiableSet(this.globalPermissions);
    }

    public Map<QName, PermissionSet> getPermissionSets() {
        return Collections.unmodifiableMap(this.permissionSets);
    }

    @Override
    public Set<PermissionReference> getAllPermissions(QName type) {
        return this.getAllPermissionsImpl(type, false);
    }

    @Override
    public Set<PermissionReference> getExposedPermissions(QName type) {
        return this.getAllPermissionsImpl(type, true);
    }

    private Set<PermissionReference> getAllPermissionsImpl(QName type, boolean exposedOnly) {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>();
        if (this.dictionaryService.getClass(type).isAspect()) {
            this.addAspectPermissions(type, permissions, exposedOnly);
        } else {
            this.mergeGeneralAspectPermissions(permissions, exposedOnly);
            this.addTypePermissions(type, permissions, exposedOnly);
        }
        return permissions;
    }

    private void addTypePermissions(QName type, Set<PermissionReference> permissions, boolean exposedOnly) {
        TypeDefinition typeDef = this.dictionaryService.getType(type);
        if (typeDef.getParentName() != null) {
            PermissionSet permissionSet = this.permissionSets.get(type);
            if (!exposedOnly || permissionSet == null || permissionSet.exposeAll()) {
                this.addTypePermissions(typeDef.getParentName(), permissions, exposedOnly);
            }
        }
        for (AspectDefinition ad : typeDef.getDefaultAspects()) {
            this.addAspectPermissions(ad.getName(), permissions, exposedOnly);
        }
        this.mergePermissions(permissions, type, exposedOnly, true);
    }

    private void addAspectPermissions(QName type, Set<PermissionReference> permissions, boolean exposedOnly) {
        AspectDefinition aspectDef = this.dictionaryService.getAspect(type);
        if (aspectDef.getParentName() != null) {
            PermissionSet permissionSet = this.permissionSets.get(type);
            if (!exposedOnly || permissionSet == null || permissionSet.exposeAll()) {
                this.addAspectPermissions(aspectDef.getParentName(), permissions, exposedOnly);
            }
        }
        this.mergePermissions(permissions, type, exposedOnly, true);
    }

    private void mergePermissions(Set<PermissionReference> target, QName type, boolean exposedOnly, boolean typeRequired) {
        PermissionSet permissionSet = this.permissionSets.get(type);
        if (permissionSet != null) {
            for (PermissionGroup pg : permissionSet.getPermissionGroups()) {
                if (exposedOnly && !permissionSet.exposeAll() && !pg.isExposed()) continue;
                if (!pg.isExtends()) {
                    if (pg.isTypeRequired() != typeRequired) continue;
                    target.add(pg);
                    continue;
                }
                if (!exposedOnly || pg.isTypeRequired() != typeRequired) continue;
                target.add(this.getBasePermissionGroup(pg));
            }
            for (Permission p : permissionSet.getPermissions()) {
                if (exposedOnly && !permissionSet.exposeAll() && !p.isExposed() || p.isTypeRequired() != typeRequired) continue;
                target.add(p);
            }
        }
    }

    private void mergeGeneralAspectPermissions(Set<PermissionReference> target, boolean exposedOnly) {
        for (QName aspect : this.dictionaryService.getAllAspects()) {
            this.mergePermissions(target, aspect, exposedOnly, false);
        }
    }

    @Override
    public Set<PermissionReference> getAllPermissions(NodeRef nodeRef) {
        return this.getExposedPermissionsImpl(nodeRef, false);
    }

    @Override
    public Set<PermissionReference> getExposedPermissions(NodeRef nodeRef) {
        return this.getExposedPermissionsImpl(nodeRef, true);
    }

    public Set<PermissionReference> getExposedPermissionsImpl(NodeRef nodeRef, boolean exposedOnly) {
        QName typeName = this.nodeService.getType(nodeRef);
        Set<PermissionReference> permissions = this.getAllPermissions(typeName);
        this.mergeGeneralAspectPermissions(permissions, exposedOnly);
        HashSet<QName> defaultAspects = new HashSet<QName>();
        for (AspectDefinition aspDef : this.dictionaryService.getType(typeName).getDefaultAspects()) {
            defaultAspects.add(aspDef.getName());
        }
        for (QName aspect : this.nodeService.getAspects(nodeRef)) {
            if (defaultAspects.contains(aspect)) continue;
            this.addAspectPermissions(aspect, permissions, exposedOnly);
        }
        return permissions;
    }

    @Override
    public synchronized Set<PermissionReference> getGrantingPermissions(PermissionReference permissionReference) {
        Set<PermissionReference> granters = this.grantingPermissions.get(permissionReference);
        if (granters == null) {
            granters = this.getGrantingPermissionsImpl(permissionReference);
            this.grantingPermissions.put(permissionReference, granters);
        }
        return granters;
    }

    private Set<PermissionReference> getGrantingPermissionsImpl(PermissionReference permissionReference) {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>();
        permissions.add(permissionReference);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (this.grants(pg, permissionReference)) {
                    permissions.add(this.getBasePermissionGroup(pg));
                }
                if (!pg.isAllowFullControl()) continue;
                permissions.add(pg);
            }
            block2: for (Permission p : ps.getPermissions()) {
                if (p.equals(permissionReference)) {
                    for (PermissionReference pg : p.getGrantedToGroups()) {
                        permissions.add(this.getBasePermissionGroup(this.getPermissionGroup(pg)));
                    }
                }
                for (RequiredPermission rp : p.getRequiredPermissions()) {
                    if (!rp.equals(permissionReference) || !rp.isImplies()) continue;
                    permissions.add(p);
                    continue block2;
                }
            }
        }
        return permissions;
    }

    private boolean grants(PermissionGroup pg, PermissionReference permissionReference) {
        if (pg.getIncludedPermissionGroups().contains(permissionReference)) {
            return true;
        }
        if (this.getGranteePermissions(pg).contains(permissionReference)) {
            return true;
        }
        for (PermissionReference nested : pg.getIncludedPermissionGroups()) {
            if (!this.grants(this.getPermissionGroup(nested), permissionReference)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Set<PermissionReference> getGranteePermissions(PermissionReference permissionReference) {
        Set<PermissionReference> grantees = this.granteePermissions.get(permissionReference);
        if (grantees == null) {
            grantees = this.getGranteePermissionsImpl(permissionReference);
            this.granteePermissions.put(permissionReference, grantees);
        }
        return grantees;
    }

    private Set<PermissionReference> getGranteePermissionsImpl(PermissionReference permissionReference) {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>();
        permissions.add(permissionReference);
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (!pg.equals(permissionReference)) continue;
                for (PermissionReference included : pg.getIncludedPermissionGroups()) {
                    permissions.addAll(this.getGranteePermissions(included));
                }
                if (pg.isExtends()) {
                    if (pg.getTypeQName() != null) {
                        permissions.addAll(this.getGranteePermissions(new SimplePermissionReference(pg.getTypeQName(), pg.getName())));
                    } else {
                        ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                        QName parent = classDefinition.getParentName();
                        if (parent != null) {
                            classDefinition = this.dictionaryService.getClass(parent);
                            PermissionGroup attempt = this.getPermissionGroupOrNull(new SimplePermissionReference(parent, pg.getName()));
                            if (attempt != null) {
                                permissions.addAll(this.getGranteePermissions(attempt));
                            }
                        }
                    }
                }
                if (!pg.isAllowFullControl()) continue;
                permissions.addAll(this.getAllPermissions());
            }
            PermissionGroup baseGroup = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(permissionReference));
            if (baseGroup == null) continue;
            for (Permission p : ps.getPermissions()) {
                for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                    if (!baseGroup.equals(base)) continue;
                    permissions.add(p);
                }
            }
        }
        return permissions;
    }

    private Set<PermissionReference> getAllPermissions() {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>();
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                permissions.add(pg);
            }
            for (Permission p : ps.getPermissions()) {
                permissions.add(p);
            }
        }
        return permissions;
    }

    private PermissionGroup getPermissionGroupOrNull(PermissionReference target) {
        PermissionGroup pg = this.permissionGroupMap.get(target);
        return pg == null ? null : pg;
    }

    private PermissionGroup getPermissionGroup(PermissionReference target) {
        PermissionGroup pg = this.getPermissionGroupOrNull(target);
        if (pg == null) {
            throw new PermissionModelException("There is no permission group :" + target.getQName() + " " + target.getName());
        }
        return pg;
    }

    private synchronized PermissionGroup getBasePermissionGroupOrNull(PermissionGroup pg) {
        if (this.groupsToBaseGroup.containsKey(pg)) {
            return this.groupsToBaseGroup.get(pg);
        }
        PermissionGroup answer = this.getBasePermissionGroupOrNullImpl(pg);
        this.groupsToBaseGroup.put(pg, answer);
        return answer;
    }

    private PermissionGroup getBasePermissionGroupOrNullImpl(PermissionGroup pg) {
        if (pg == null) {
            return null;
        }
        if (pg.isExtends()) {
            QName parent;
            if (pg.getTypeQName() != null) {
                return this.getPermissionGroup(new SimplePermissionReference(pg.getTypeQName(), pg.getName()));
            }
            ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
            while ((parent = classDefinition.getParentName()) != null) {
                classDefinition = this.dictionaryService.getClass(parent);
                PermissionGroup attempt = this.getPermissionGroupOrNull(new SimplePermissionReference(parent, pg.getName()));
                if (attempt == null || attempt.isExtends()) continue;
                return attempt;
            }
            return null;
        }
        return pg;
    }

    private PermissionGroup getBasePermissionGroup(PermissionGroup target) {
        PermissionGroup pg = this.getBasePermissionGroupOrNull(target);
        if (pg == null) {
            throw new PermissionModelException("There is no parent for permission group :" + target.getQName() + " " + target.getName());
        }
        return pg;
    }

    @Override
    public Set<PermissionReference> getRequiredPermissions(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
        PermissionGroup pg = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(required));
        if (pg == null) {
            return this.getRequirementsForPermission(required, on);
        }
        return this.getRequirementsForPermissionGroup(pg, on, qName, aspectQNames);
    }

    private Set<PermissionReference> getRequirementsForPermission(PermissionReference required, RequiredPermission.On on) {
        HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>();
        Permission p = this.getPermissionOrNull(required);
        if (p != null) {
            for (RequiredPermission rp : p.getRequiredPermissions()) {
                if (rp.isImplies() || !rp.getOn().equals((Object)on)) continue;
                requiredPermissions.add(rp);
            }
        }
        return requiredPermissions;
    }

    private Set<PermissionReference> getRequirementsForPermissionGroup(PermissionGroup target, RequiredPermission.On on, QName qName, Set<QName> aspectQNames) {
        HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>();
        if (target == null) {
            return requiredPermissions;
        }
        for (PermissionSet ps : this.permissionSets.values()) {
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (!target.equals(this.getBasePermissionGroupOrNull(pg)) || !this.isPartOfDynamicPermissionGroup(pg, qName, aspectQNames)) continue;
                for (PermissionReference pr : pg.getIncludedPermissionGroups()) {
                    requiredPermissions.addAll(this.getRequirementsForPermissionGroup(this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(pr)), on, qName, aspectQNames));
                }
            }
            for (Permission p : ps.getPermissions()) {
                for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                    if (!target.equals(base) || base.isTypeRequired() && !this.isPartOfDynamicPermissionGroup(grantedTo, qName, aspectQNames) || on != RequiredPermission.On.NODE) continue;
                    requiredPermissions.add(p);
                }
            }
        }
        return requiredPermissions;
    }

    private boolean isPartOfDynamicPermissionGroup(PermissionReference pr, QName typeQname, Set<QName> aspects) {
        if (this.dictionaryService.isSubClass(typeQname, pr.getQName())) {
            return true;
        }
        for (QName aspect : aspects) {
            if (!this.dictionaryService.isSubClass(aspect, pr.getQName())) continue;
            return true;
        }
        return false;
    }

    private Permission getPermissionOrNull(PermissionReference perm) {
        Permission p = this.permissionMap.get(perm);
        return p == null ? null : p;
    }

    @Override
    public boolean checkPermission(PermissionReference required) {
        Permission permission = this.getPermissionOrNull(required);
        if (permission != null) {
            return true;
        }
        PermissionGroup pg = this.getPermissionGroupOrNull(required);
        if (pg != null) {
            if (pg.isExtends()) {
                QName parent;
                if (pg.getTypeQName() != null) {
                    return this.checkPermission(new SimplePermissionReference(pg.getTypeQName(), pg.getName()));
                }
                ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                while ((parent = classDefinition.getParentName()) != null) {
                    classDefinition = this.dictionaryService.getClass(parent);
                    PermissionGroup attempt = this.getPermissionGroupOrNull(new SimplePermissionReference(parent, pg.getName()));
                    if (attempt == null || !attempt.isAllowFullControl()) continue;
                    return true;
                }
                return false;
            }
            return pg.isAllowFullControl();
        }
        return false;
    }

    @Override
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        if (permissionName == null) {
            return null;
        }
        PermissionReference pr = this.uniqueMap.get(permissionName);
        if (pr == null && (pr = this.permissionReferenceMap.get(permissionName)) == null) {
            throw new UnsupportedOperationException("Can not find " + permissionName);
        }
        return pr;
    }

    @Override
    public boolean isUnique(PermissionReference permissionReference) {
        return this.uniqueMap.containsKey(permissionReference.getName());
    }

    private void buildUniquePermissionMap() {
        HashSet<String> excluded = new HashSet<String>();
        this.uniqueMap = new HashMap();
        this.permissionReferenceMap = new HashMap();
        this.permissionGroupMap = new HashMap();
        this.permissionMap = new HashMap();
        for (PermissionSet ps : this.permissionSets.values()) {
            PermissionReference value;
            for (PermissionGroup pg : ps.getPermissionGroups()) {
                if (this.uniqueMap.containsKey(pg.getName()) && !excluded.contains(pg.getName())) {
                    value = this.uniqueMap.get(pg.getName());
                    if (!value.equals(this.getBasePermissionGroup(pg))) {
                        this.uniqueMap.remove(pg.getName());
                        excluded.add(pg.getName());
                    }
                } else {
                    this.uniqueMap.put(pg.getName(), this.getBasePermissionGroup(pg));
                }
                this.permissionReferenceMap.put(pg.toString(), pg);
                this.permissionGroupMap.put(pg, pg);
            }
            for (Permission p : ps.getPermissions()) {
                if (this.uniqueMap.containsKey(p.getName()) && !excluded.contains(p.getName())) {
                    value = this.uniqueMap.get(p.getName());
                    if (!value.equals(p)) {
                        this.uniqueMap.remove(p.getName());
                        excluded.add(p.getName());
                    }
                } else {
                    this.uniqueMap.put(p.getName(), p);
                }
                this.permissionReferenceMap.put(p.toString(), p);
                this.permissionMap.put(p, p);
            }
        }
        if (this.uniqueMap.containsKey("All")) {
            throw new IllegalStateException("There must not be a permission with the same name as the ALL_PERMISSION constant: All");
        }
        this.uniqueMap.put("All", new SimplePermissionReference(QName.createQName("http://www.alfresco.org/model/security/1.0", "All"), "All"));
    }
}

