/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.util.Set;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.service.namespace.QName;

public class PermissionModelTest
extends AbstractPermissionTest {
    public void testIncludePermissionGroups() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(new SimplePermissionReference(QName.createQName("cm", "cmobject", this.namespacePrefixResolver), "Consumer"));
        PermissionModelTest.assertEquals((int)5, (int)grantees.size());
    }

    public void testIncludePermissionGroups2() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(new SimplePermissionReference(QName.createQName("cm", "cmobject", this.namespacePrefixResolver), "Contributor"));
        PermissionModelTest.assertEquals((int)11, (int)grantees.size());
    }

    public void testIncludePermissionGroups3() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(new SimplePermissionReference(QName.createQName("cm", "cmobject", this.namespacePrefixResolver), "Editor"));
        PermissionModelTest.assertEquals((int)11, (int)grantees.size());
    }

    public void testIncludePermissionGroups4() {
        Set<PermissionReference> grantees = this.permissionModelDAO.getGranteePermissions(new SimplePermissionReference(QName.createQName("cm", "cmobject", this.namespacePrefixResolver), "Collaborator"));
        PermissionModelTest.assertEquals((int)16, (int)grantees.size());
    }

    public void testGetGrantingPermissions() {
        Set<PermissionReference> granters = this.permissionModelDAO.getGrantingPermissions(new SimplePermissionReference(QName.createQName("sys", "base", this.namespacePrefixResolver), "ReadProperties"));
        PermissionModelTest.assertEquals((int)9, (int)granters.size());
    }

    public void testGlobalPermissions() {
        Set<? extends PermissionEntry> globalPermissions = this.permissionModelDAO.getGlobalPermissionEntries();
        PermissionModelTest.assertEquals((int)5, (int)globalPermissions.size());
    }
}

