/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonServiceImpl
implements PersonService {
    public static final String SYSTEM_FOLDER = "/sys:system";
    public static final String PEOPLE_FOLDER = "/sys:system/sys:people";
    private StoreRef storeRef;
    private NodeService nodeService;
    private SearchService searchService;
    private AuthorityService authorityService;
    private PermissionServiceSPI permissionServiceSPI;
    private NamespacePrefixResolver namespacePrefixResolver;
    private boolean createMissingPeople;
    private boolean userNamesAreCaseSensitive;
    private String companyHomePath;
    private NodeRef companyHomeNodeRef;
    private static Set<QName> mutableProperties;

    @Override
    public boolean getUserNamesAreCaseSensitive() {
        return this.userNamesAreCaseSensitive;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    @Override
    public NodeRef getPerson(String caseSensitiveUserName) {
        String userName = this.userNamesAreCaseSensitive ? caseSensitiveUserName : caseSensitiveUserName.toLowerCase();
        NodeRef personNode = this.getPersonOrNull(userName);
        if (personNode == null) {
            if (this.createMissingPeople()) {
                return this.createMissingPerson(userName);
            }
            throw new NoSuchPersonException(userName);
        }
        return personNode;
    }

    @Override
    public boolean personExists(String caseSensitiveUserName) {
        return this.getPersonOrNull(caseSensitiveUserName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef getPersonOrNull(String caseSensitiveUserName) {
        String userName = this.userNamesAreCaseSensitive ? caseSensitiveUserName : caseSensitiveUserName.toLowerCase();
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\\{http\\://www.alfresco.org/model/content/1.0\\}person +@cm\\:userName:\"" + userName + "\"");
        sp.addStore(this.storeRef);
        sp.excludeDataInTheCurrentTransaction(false);
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            for (ResultSetRow row : rs) {
                NodeRef nodeRef = row.getNodeRef();
                if (!this.nodeService.exists(nodeRef)) continue;
                String realUserName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME));
                String string = realUserName = this.userNamesAreCaseSensitive ? realUserName : realUserName.toLowerCase();
                if (!realUserName.equals(userName)) continue;
                NodeRef nodeRef2 = nodeRef;
                return nodeRef2;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return null;
    }

    @Override
    public boolean createMissingPeople() {
        return this.createMissingPeople;
    }

    @Override
    public Set<QName> getMutableProperties() {
        return mutableProperties;
    }

    @Override
    public void setPersonProperties(String caseSensitiveUserName, Map<QName, Serializable> properties) {
        String userName = this.userNamesAreCaseSensitive ? caseSensitiveUserName : caseSensitiveUserName.toLowerCase();
        NodeRef personNode = this.getPersonOrNull(userName);
        if (personNode == null) {
            if (this.createMissingPeople()) {
                personNode = this.createMissingPerson(userName);
            } else {
                throw new PersonException("No person found for user name " + userName);
            }
        }
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        this.nodeService.setProperties(personNode, properties);
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    private NodeRef createMissingPerson(String userName) {
        HashMap<QName, Serializable> properties = this.getDefaultProperties(userName);
        return this.createPerson(properties);
    }

    private HashMap<QName, Serializable> getDefaultProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_HOMEFOLDER, this.getHomeFolder());
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)""));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)""));
        return properties;
    }

    private NodeRef getHomeFolder() {
        return this.getCompanyHome();
    }

    @Override
    public NodeRef createPerson(Map<QName, Serializable> properties) {
        String caseSensitiveUserName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_USERNAME));
        String userName = this.userNamesAreCaseSensitive ? caseSensitiveUserName : caseSensitiveUserName.toLowerCase();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return this.nodeService.createNode(this.getPeopleContainer(), ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_PERSON, ContentModel.TYPE_PERSON, properties).getChildRef();
    }

    @Override
    public NodeRef getPeopleContainer() {
        NodeRef rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        List<NodeRef> results = this.searchService.selectNodes(rootNodeRef, PEOPLE_FOLDER, null, this.namespacePrefixResolver, false);
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required people system path not found: /sys:system/sys:people");
        }
        return results.get(0);
    }

    @Override
    public void deletePerson(String userName) {
        NodeRef personNodeRef = this.getPersonOrNull(userName);
        if (personNodeRef != null) {
            this.nodeService.deleteNode(personNodeRef);
        }
        String authorityName = this.userNamesAreCaseSensitive ? userName : userName.toLowerCase();
        Set<String> containerAuthorities = this.authorityService.getContainingAuthorities(null, userName, true);
        for (String containerAuthority : containerAuthorities) {
            this.authorityService.removeAuthority(containerAuthority, authorityName);
        }
        this.permissionServiceSPI.deletePermissions(authorityName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<NodeRef> getAllPeople() {
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("TYPE:\"" + ContentModel.TYPE_PERSON + "\"");
        sp.addStore(this.storeRef);
        sp.excludeDataInTheCurrentTransaction(false);
        LinkedHashSet<NodeRef> nodes = new LinkedHashSet<NodeRef>();
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            for (ResultSetRow row : rs) {
                NodeRef nodeRef = row.getNodeRef();
                if (!this.nodeService.exists(nodeRef)) continue;
                nodes.add(nodeRef);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return nodes;
    }

    @Override
    public void setCreateMissingPeople(boolean createMissingPeople) {
        this.createMissingPeople = createMissingPeople;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPermissionServiceSPI(PermissionServiceSPI permissionServiceSPI) {
        this.permissionServiceSPI = permissionServiceSPI;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setStoreUrl(String storeUrl) {
        this.storeRef = new StoreRef(storeUrl);
    }

    public void setCompanyHomePath(String companyHomePath) {
        this.companyHomePath = companyHomePath;
    }

    public synchronized NodeRef getCompanyHome() {
        if (this.companyHomeNodeRef == null) {
            List<NodeRef> refs = this.searchService.selectNodes(this.nodeService.getRootNode(this.storeRef), this.companyHomePath, null, this.namespacePrefixResolver, false);
            if (refs.size() != 1) {
                throw new IllegalStateException("Invalid company home path: found : " + refs.size());
            }
            this.companyHomeNodeRef = refs.get(0);
        }
        return this.companyHomeNodeRef;
    }

    static {
        HashSet<QName> props = new HashSet<QName>();
        props.add(ContentModel.PROP_HOMEFOLDER);
        props.add(ContentModel.PROP_FIRSTNAME);
        props.add(ContentModel.PROP_LASTNAME);
        props.add(ContentModel.PROP_EMAIL);
        props.add(ContentModel.PROP_ORGID);
        mutableProperties = Collections.unmodifiableSet(props);
    }
}

