/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.person.PersonException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonTest
extends BaseSpringTest {
    private PersonService personService;
    private NodeService nodeService;
    private NodeRef rootNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        for (NodeRef nodeRef : this.personService.getAllPeople()) {
            this.nodeService.deleteNode(nodeRef);
        }
    }

    protected void onTearDownInTransaction() throws Exception {
        super.onTearDownInTransaction();
    }

    public void xtestPerformance() {
        this.personService.setCreateMissingPeople(false);
        this.personService.createPerson(this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        long create = 0L;
        long count = 0L;
        for (int i = 0; i < 10000; ++i) {
            String id = "TestUser-" + i;
            long start = System.nanoTime();
            this.personService.createPerson(this.createDefaultProperties(id, id, id, id, id, this.rootNodeRef));
            long end = System.nanoTime();
            create += end - start;
            if (i <= 0 || i % 100 != 0) continue;
            System.out.println("Count = " + i);
            System.out.println("Average create : " + (float)(create / (long)i) / 1000000.0f);
            start = System.nanoTime();
            this.personService.personExists(id);
            end = System.nanoTime();
            System.out.println("Exists : " + (float)(end - start) / 1000000.0f);
            start = System.nanoTime();
            int size = this.personService.getAllPeople().size();
            end = System.nanoTime();
            System.out.println("Size (" + size + ") : " + (float)(end - start) / 1000000.0f);
        }
    }

    public void testCreateMissingPeople1() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertFalse((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(true);
        PersonTest.assertTrue((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(false);
        try {
            this.personService.getPerson("andy");
            PersonTest.fail((String)"Getting Andy should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testCreateMissingPeople2() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertFalse((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(true);
        PersonTest.assertTrue((boolean)this.personService.createMissingPeople());
        NodeRef nodeRef = this.personService.getPerson("andy");
        PersonTest.assertNotNull((Object)nodeRef);
        this.testProperties(nodeRef, "andy", "andy", "", "", "");
        this.personService.setCreateMissingPeople(false);
        try {
            this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
            PersonTest.fail((String)"Getting Derek should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testCreateMissingPeople() {
        this.personService.setCreateMissingPeople(false);
        PersonTest.assertFalse((boolean)this.personService.createMissingPeople());
        this.personService.setCreateMissingPeople(true);
        PersonTest.assertTrue((boolean)this.personService.createMissingPeople());
        NodeRef nodeRef = this.personService.getPerson("andy");
        PersonTest.assertNotNull((Object)nodeRef);
        this.testProperties(nodeRef, "andy", "andy", "", "", "");
        this.personService.setCreateMissingPeople(true);
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        this.testProperties(this.personService.getPerson("andy"), "andy", "andy", "", "", "");
        PersonTest.assertEquals((int)2, (int)this.personService.getAllPeople().size());
        PersonTest.assertTrue((boolean)this.personService.getAllPeople().contains(this.personService.getPerson("andy")));
        PersonTest.assertTrue((boolean)this.personService.getAllPeople().contains(this.personService.getPerson("derek")));
    }

    public void testMutableProperties() {
        PersonTest.assertEquals((int)5, (int)this.personService.getMutableProperties().size());
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_HOMEFOLDER));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_FIRSTNAME));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_LASTNAME));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_EMAIL));
        PersonTest.assertTrue((boolean)this.personService.getMutableProperties().contains(ContentModel.PROP_ORGID));
    }

    public void testPersonCRUD1() {
        this.personService.setCreateMissingPeople(false);
        try {
            this.personService.getPerson("derek");
            PersonTest.fail((String)"Getting Derek should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testPersonCRUD2() {
        this.personService.setCreateMissingPeople(false);
        this.personService.createPerson(this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek_", "Hulley_", "dh@dh_", "alfresco_", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek_", "Hulley_", "dh@dh_", "alfresco_");
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        PersonTest.assertEquals((int)1, (int)this.personService.getAllPeople().size());
        PersonTest.assertTrue((boolean)this.personService.getAllPeople().contains(this.personService.getPerson("derek")));
        this.personService.deletePerson("derek");
        PersonTest.assertEquals((int)0, (int)this.personService.getAllPeople().size());
        try {
            this.personService.getPerson("derek");
            PersonTest.fail((String)"Getting Derek should fail");
        }
        catch (PersonException personException) {
            // empty catch block
        }
    }

    public void testPersonCRUD() {
        this.personService.setCreateMissingPeople(false);
        this.personService.createPerson(this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek_", "Hulley_", "dh@dh_", "alfresco_", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek_", "Hulley_", "dh@dh_", "alfresco_");
        this.personService.setPersonProperties("derek", this.createDefaultProperties("derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
        this.testProperties(this.personService.getPerson("derek"), "derek", "Derek", "Hulley", "dh@dh", "alfresco");
        PersonTest.assertEquals((int)1, (int)this.personService.getAllPeople().size());
        PersonTest.assertTrue((boolean)this.personService.getAllPeople().contains(this.personService.getPerson("derek")));
        this.personService.deletePerson("derek");
        PersonTest.assertEquals((int)0, (int)this.personService.getAllPeople().size());
    }

    private void testProperties(NodeRef nodeRef, String userName, String firstName, String lastName, String email, String orgId) {
        PersonTest.assertEquals((String)userName, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USERNAME)));
        PersonTest.assertNotNull((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_HOMEFOLDER));
        PersonTest.assertEquals((String)firstName, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_FIRSTNAME)));
        PersonTest.assertEquals((String)lastName, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_LASTNAME)));
        PersonTest.assertEquals((String)email, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_EMAIL)));
        PersonTest.assertEquals((String)orgId, (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_ORGID)));
    }

    private Map<QName, Serializable> createDefaultProperties(String userName, String firstName, String lastName, String email, String orgId, NodeRef home) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        properties.put(ContentModel.PROP_HOMEFOLDER, home);
        properties.put(ContentModel.PROP_FIRSTNAME, (Serializable)((Object)firstName));
        properties.put(ContentModel.PROP_LASTNAME, (Serializable)((Object)lastName));
        properties.put(ContentModel.PROP_EMAIL, (Serializable)((Object)email));
        properties.put(ContentModel.PROP_ORGID, (Serializable)((Object)orgId));
        return properties;
    }

    public void testCaseSensitive() {
        if (this.personService.getUserNamesAreCaseSensitive()) {
            this.personService.createPerson(this.createDefaultProperties("Derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
            try {
                this.personService.getPerson("derek");
                PersonTest.assertNotNull(null);
            }
            catch (PersonException pe) {
                // empty catch block
            }
            try {
                this.personService.getPerson("deRek");
                PersonTest.assertNotNull(null);
            }
            catch (PersonException pe) {
                // empty catch block
            }
            try {
                this.personService.getPerson("DEREK");
                PersonTest.assertNotNull(null);
            }
            catch (PersonException personException) {
                // empty catch block
            }
            this.personService.getPerson("Derek");
        }
    }

    public void testCaseInsensitive() {
        if (!this.personService.getUserNamesAreCaseSensitive()) {
            this.personService.createPerson(this.createDefaultProperties("Derek", "Derek", "Hulley", "dh@dh", "alfresco", this.rootNodeRef));
            this.personService.getPerson("derek");
            this.personService.getPerson("deRek");
            this.personService.getPerson("Derek");
            this.personService.getPerson("DEREK");
        }
    }
}

