/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.service.BeanServiceDescriptor;
import org.alfresco.repo.service.ServiceDescriptorMetaData;
import org.alfresco.repo.service.StoreRedirector;
import org.alfresco.service.ServiceDescriptor;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptorRegistry
implements BeanFactoryAware,
BeanFactoryPostProcessor,
ServiceRegistry {
    private BeanFactory beanFactory = null;
    private Map<QName, BeanServiceDescriptor> descriptors = new HashMap<QName, BeanServiceDescriptor>();

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Map beans = beanFactory.getBeansOfType(ServiceDescriptorMetaData.class);
        for (Map.Entry entry : beans.entrySet()) {
            ServiceDescriptorMetaData metaData = (ServiceDescriptorMetaData)entry.getValue();
            QName serviceName = QName.createQName(metaData.getNamespace(), (String)entry.getKey());
            StoreRedirector redirector = entry.getValue() instanceof StoreRedirector ? (StoreRedirector)entry.getValue() : null;
            BeanServiceDescriptor serviceDescriptor = new BeanServiceDescriptor(serviceName, metaData, redirector);
            this.descriptors.put(serviceDescriptor.getQualifiedName(), serviceDescriptor);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public Collection<QName> getServices() {
        return Collections.unmodifiableSet(this.descriptors.keySet());
    }

    @Override
    public boolean isServiceProvided(QName service) {
        return this.descriptors.containsKey(service);
    }

    @Override
    public ServiceDescriptor getServiceDescriptor(QName service) {
        return this.descriptors.get(service);
    }

    @Override
    public Object getService(QName service) {
        return this.beanFactory.getBean(service.getLocalName());
    }

    @Override
    public DescriptorService getDescriptorService() {
        return (DescriptorService)this.getService(DESCRIPTOR_SERVICE);
    }

    @Override
    public NodeService getNodeService() {
        return (NodeService)this.getService(NODE_SERVICE);
    }

    @Override
    public AuthenticationService getAuthenticationService() {
        return (AuthenticationService)this.getService(AUTHENTICATION_SERVICE);
    }

    @Override
    public ContentService getContentService() {
        return (ContentService)this.getService(CONTENT_SERVICE);
    }

    @Override
    public MimetypeService getMimetypeService() {
        return (MimetypeService)this.getService(MIMETYPE_SERVICE);
    }

    @Override
    public VersionService getVersionService() {
        return (VersionService)this.getService(VERSION_SERVICE);
    }

    @Override
    public LockService getLockService() {
        return (LockService)this.getService(LOCK_SERVICE);
    }

    @Override
    public DictionaryService getDictionaryService() {
        return (DictionaryService)this.getService(DICTIONARY_SERVICE);
    }

    @Override
    public SearchService getSearchService() {
        return (SearchService)this.getService(SEARCH_SERVICE);
    }

    @Override
    public TransactionService getTransactionService() {
        return (TransactionService)this.getService(TRANSACTION_SERVICE);
    }

    @Override
    public CopyService getCopyService() {
        return (CopyService)this.getService(COPY_SERVICE);
    }

    @Override
    public CheckOutCheckInService getCheckOutCheckInService() {
        return (CheckOutCheckInService)this.getService(COCI_SERVICE);
    }

    @Override
    public CategoryService getCategoryService() {
        return (CategoryService)this.getService(CATEGORY_SERVICE);
    }

    @Override
    public NamespaceService getNamespaceService() {
        return (NamespaceService)this.getService(NAMESPACE_SERVICE);
    }

    @Override
    public ImporterService getImporterService() {
        return (ImporterService)this.getService(IMPORTER_SERVICE);
    }

    @Override
    public ExporterService getExporterService() {
        return (ExporterService)this.getService(EXPORTER_SERVICE);
    }

    @Override
    public RuleService getRuleService() {
        return (RuleService)this.getService(RULE_SERVICE);
    }

    @Override
    public ActionService getActionService() {
        return (ActionService)this.getService(ACTION_SERVICE);
    }

    @Override
    public PermissionService getPermissionService() {
        return (PermissionService)this.getService(PERMISSIONS_SERVICE);
    }

    @Override
    public AuthorityService getAuthorityService() {
        return (AuthorityService)this.getService(AUTHORITY_SERVICE);
    }

    @Override
    public TemplateService getTemplateService() {
        return (TemplateService)this.getService(TEMPLATE_SERVICE);
    }

    @Override
    public FileFolderService getFileFolderService() {
        return (FileFolderService)this.getService(FILE_FOLDER_SERVICE);
    }

    @Override
    public ScriptService getScriptService() {
        return (ScriptService)this.getService(SCRIPT_SERVICE);
    }
}

