/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.service;

import java.util.Collection;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.service.StoreRedirector;
import org.alfresco.service.ServiceDescriptor;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ServiceDescriptorRegistryTest
extends TestCase {
    private ApplicationContext factory = null;
    private static String TEST_NAMESPACE = "http://www.alfresco.org/test/serviceregistrytest";
    private static QName invalidService = QName.createQName(TEST_NAMESPACE, "invalid");
    private static QName service1 = QName.createQName(TEST_NAMESPACE, "service1");
    private static QName service2 = QName.createQName(TEST_NAMESPACE, "service2");
    private static QName service3 = QName.createQName(TEST_NAMESPACE, "service3");

    public void setUp() {
        this.factory = new ClassPathXmlApplicationContext("org/alfresco/repo/service/testregistry.xml");
    }

    public void testDescriptor() {
        ServiceRegistry registry = (ServiceRegistry)this.factory.getBean("serviceRegistry");
        Collection<QName> services = registry.getServices();
        ServiceDescriptorRegistryTest.assertNotNull(services);
        ServiceDescriptorRegistryTest.assertEquals((int)3, (int)services.size());
        ServiceDescriptorRegistryTest.assertTrue((boolean)registry.isServiceProvided(service1));
        ServiceDescriptorRegistryTest.assertFalse((boolean)registry.isServiceProvided(invalidService));
        ServiceDescriptor invalid = registry.getServiceDescriptor(invalidService);
        ServiceDescriptorRegistryTest.assertNull((Object)invalid);
        ServiceDescriptor desc1 = registry.getServiceDescriptor(service1);
        ServiceDescriptorRegistryTest.assertNotNull((Object)desc1);
        ServiceDescriptorRegistryTest.assertEquals((Object)service1, (Object)desc1.getQualifiedName());
        ServiceDescriptorRegistryTest.assertEquals((String)"Test Service 1", (String)desc1.getDescription());
        ServiceDescriptorRegistryTest.assertEquals(TestServiceInterface.class, (Object)desc1.getInterface());
        ServiceDescriptor desc2 = registry.getServiceDescriptor(service2);
        ServiceDescriptorRegistryTest.assertNotNull((Object)desc2);
        ServiceDescriptorRegistryTest.assertEquals((Object)service2, (Object)desc2.getQualifiedName());
        ServiceDescriptorRegistryTest.assertEquals((String)"Test Service 2", (String)desc2.getDescription());
        ServiceDescriptorRegistryTest.assertEquals(TestServiceInterface.class, (Object)desc2.getInterface());
    }

    public void testService() {
        ServiceRegistry registry = (ServiceRegistry)this.factory.getBean("serviceRegistry");
        TestServiceInterface theService1 = (TestServiceInterface)registry.getService(service1);
        ServiceDescriptorRegistryTest.assertNotNull((Object)service1);
        ServiceDescriptorRegistryTest.assertEquals((String)"Test1:service1", (String)theService1.test("service1"));
        TestServiceInterface theService2 = (TestServiceInterface)registry.getService(service2);
        ServiceDescriptorRegistryTest.assertNotNull((Object)service2);
        ServiceDescriptorRegistryTest.assertEquals((String)"Test2:service2", (String)theService2.test("service2"));
    }

    public void testStores() {
        ServiceRegistry registry = (ServiceRegistry)this.factory.getBean("serviceRegistry");
        ServiceDescriptor desc3 = registry.getServiceDescriptor(service3);
        ServiceDescriptorRegistryTest.assertNotNull((Object)desc3);
        StoreRedirector theService3 = (StoreRedirector)registry.getService(service3);
        ServiceDescriptorRegistryTest.assertNotNull((Object)service3);
        Collection<String> descStores = desc3.getSupportedStoreProtocols();
        ServiceDescriptorRegistryTest.assertTrue((boolean)descStores.contains("Type1"));
        ServiceDescriptorRegistryTest.assertTrue((boolean)descStores.contains("Type2"));
        ServiceDescriptorRegistryTest.assertFalse((boolean)descStores.contains("Invalid"));
        Collection<String> serviceStores = theService3.getSupportedStoreProtocols();
        for (String store : descStores) {
            ServiceDescriptorRegistryTest.assertTrue((boolean)serviceStores.contains(store));
        }
    }

    public void testAppContext() {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("alfresco/application-context.xml");
        ServiceRegistry registry = (ServiceRegistry)appContext.getBean("ServiceRegistry");
        ServiceDescriptorRegistryTest.assertNotNull((Object)registry);
        NodeService s1 = registry.getNodeService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s1);
        CheckOutCheckInService s2 = registry.getCheckOutCheckInService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s2);
        ContentService s3 = registry.getContentService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s3);
        CopyService s4 = registry.getCopyService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s4);
        DictionaryService s5 = registry.getDictionaryService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s5);
        LockService s6 = registry.getLockService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s6);
        MimetypeService s7 = registry.getMimetypeService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s7);
        SearchService s8 = registry.getSearchService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s8);
        TransactionService transactionService = registry.getTransactionService();
        UserTransaction s9 = transactionService.getUserTransaction();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s9);
        UserTransaction s10 = transactionService.getUserTransaction();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s10);
        ServiceDescriptorRegistryTest.assertFalse((boolean)s9.equals(s10));
        VersionService s11 = registry.getVersionService();
        ServiceDescriptorRegistryTest.assertNotNull((Object)s11);
    }

    public static class Test2Component
    extends Component {
        private Test2Component() {
            super("Test2");
        }
    }

    public static class Test1Component
    extends Component {
        private Test1Component() {
            super("Test1");
        }
    }

    public static abstract class Component
    implements TestServiceInterface {
        private String type;

        private Component(String type) {
            this.type = type;
        }

        public String test(String arg) {
            return this.type + ":" + arg;
        }
    }

    public static interface TestServiceInterface {
        public String test(String var1);
    }
}

