/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.template.BaseTemplateMap;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateNode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSearchResultsMap
extends BaseTemplateMap {
    public BaseSearchResultsMap(TemplateNode parent, ServiceRegistry services) {
        super(parent, services);
    }

    protected List<TemplateNode> query(String search) {
        List<TemplateNode> nodes = null;
        if (search != null && search.length() != 0) {
            ResultSet results = null;
            try {
                results = this.services.getSearchService().query(this.parent.getNodeRef().getStoreRef(), "lucene", search);
                if (results.length() != 0) {
                    nodes = new ArrayList<TemplateNode>(results.length());
                    for (ResultSetRow row : results) {
                        NodeRef nodeRef = row.getNodeRef();
                        nodes.add(new TemplateNode(nodeRef, this.services, this.parent.getImageResolver()));
                    }
                }
            }
            catch (Throwable err) {
                throw new AlfrescoRuntimeException("Failed to execute search: " + search, err);
            }
            finally {
                if (results != null) {
                    results.close();
                }
            }
        }
        return nodes != null ? nodes : Collections.emptyList();
    }
}

