/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;

public class ClassPathRepoTemplateLoader
implements TemplateLoader {
    private NodeService nodeService;
    private ContentService contentService;

    public ClassPathRepoTemplateLoader(NodeService nodeService, ContentService contentService) {
        if (nodeService == null) {
            throw new IllegalArgumentException("NodeService is mandatory.");
        }
        if (contentService == null) {
            throw new IllegalArgumentException("ContentService is mandatory.");
        }
        this.nodeService = nodeService;
        this.contentService = contentService;
    }

    public Object findTemplateSource(String name) throws IOException {
        if (name.indexOf("://") != -1) {
            NodeRef ref = new NodeRef(name);
            if (this.nodeService.exists(ref)) {
                return new RepoTemplateSource(ref);
            }
            return null;
        }
        URL url = this.getClass().getClassLoader().getResource(name);
        return url == null ? null : new ClassPathTemplateSource(url);
    }

    public long getLastModified(Object templateSource) {
        return ((BaseTemplateSource)templateSource).lastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return ((BaseTemplateSource)templateSource).getReader();
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
        ((BaseTemplateSource)templateSource).close();
    }

    class RepoTemplateSource
    extends BaseTemplateSource {
        private final NodeRef nodeRef;
        private InputStream inputStream;
        private ContentReader conn;

        RepoTemplateSource(NodeRef ref) throws IOException {
            this.nodeRef = ref;
            this.conn = ClassPathRepoTemplateLoader.this.contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        }

        public boolean equals(Object o) {
            if (o instanceof RepoTemplateSource) {
                return this.nodeRef.equals(((RepoTemplateSource)o).nodeRef);
            }
            return false;
        }

        public int hashCode() {
            return this.nodeRef.hashCode();
        }

        public String toString() {
            return this.nodeRef.toString();
        }

        public long lastModified() {
            return this.conn.getLastModified();
        }

        public Reader getReader() throws IOException {
            this.inputStream = this.conn.getContentInputStream();
            return new InputStreamReader(this.inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            finally {
                this.inputStream = null;
                this.conn = null;
            }
        }
    }

    class ClassPathTemplateSource
    extends BaseTemplateSource {
        private final URL url;
        private URLConnection conn;
        private InputStream inputStream;

        ClassPathTemplateSource(URL url) throws IOException {
            this.url = url;
            this.conn = url.openConnection();
        }

        public boolean equals(Object o) {
            if (o instanceof ClassPathTemplateSource) {
                return this.url.equals(((ClassPathTemplateSource)o).url);
            }
            return false;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        public String toString() {
            return this.url.toString();
        }

        public long lastModified() {
            return this.conn.getLastModified();
        }

        public Reader getReader() throws IOException {
            this.inputStream = this.conn.getInputStream();
            return new InputStreamReader(this.inputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            finally {
                this.inputStream = null;
                this.conn = null;
            }
        }
    }

    abstract class BaseTemplateSource {
        BaseTemplateSource() {
        }

        public abstract Reader getReader() throws IOException;

        public abstract void close() throws IOException;

        public abstract long lastModified();
    }
}

