/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.Writer;
import org.alfresco.repo.template.ClassPathRepoTemplateLoader;
import org.alfresco.repo.template.QNameAwareObjectWrapper;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateProcessor;
import org.apache.log4j.Logger;

public class FreeMarkerProcessor
implements TemplateProcessor {
    private static final String MSG_ERROR_NO_TEMPLATE = "error_no_template";
    private static final String MSG_ERROR_TEMPLATE_FAIL = "error_template_fail";
    private static final String MSG_ERROR_TEMPLATE_IO = "error_template_io";
    private static Logger logger = Logger.getLogger(FreeMarkerProcessor.class);
    private Configuration config = null;
    private NodeService nodeService;
    private ContentService contentService;
    private static final String PATH = "string://fixed";

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    private Configuration getConfig() {
        if (this.config == null) {
            Configuration config = new Configuration();
            config.setCacheStorage((CacheStorage)new MruCacheStorage(20, 0));
            config.setTemplateLoader((TemplateLoader)new ClassPathRepoTemplateLoader(this.nodeService, this.contentService));
            config.setObjectWrapper((ObjectWrapper)new QNameAwareObjectWrapper());
            config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
            this.config = config;
        }
        return this.config;
    }

    private Configuration getStringConfig(String path, String template) {
        Configuration config = new Configuration();
        config.setCacheStorage((CacheStorage)new MruCacheStorage(20, 0));
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(path, template);
        config.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        config.setObjectWrapper((ObjectWrapper)new QNameAwareObjectWrapper());
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return config;
    }

    public void process(String template, Object model, Writer out) {
        block9: {
            if (template == null || template.length() == 0) {
                throw new IllegalArgumentException("Template name is mandatory.");
            }
            if (model == null) {
                throw new IllegalArgumentException("Model is mandatory.");
            }
            if (out == null) {
                throw new IllegalArgumentException("Output Writer is mandatory.");
            }
            try {
                Template t;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing template: " + template + " on model: " + model));
                }
                if ((t = this.getConfig().getTemplate(template)) != null) {
                    try {
                        t.process(model, out);
                        break block9;
                    }
                    catch (Throwable err) {
                        throw new TemplateException(MSG_ERROR_TEMPLATE_FAIL, new Object[]{err.getMessage()}, err);
                    }
                }
                throw new TemplateException(MSG_ERROR_NO_TEMPLATE, new Object[]{template});
            }
            catch (IOException ioerr) {
                throw new TemplateException(MSG_ERROR_TEMPLATE_IO, new Object[]{template}, ioerr);
            }
        }
    }

    public void processString(String template, Object model, Writer out) {
        block9: {
            if (template == null || template.length() == 0) {
                throw new IllegalArgumentException("Template is mandatory.");
            }
            if (model == null) {
                throw new IllegalArgumentException("Model is mandatory.");
            }
            if (out == null) {
                throw new IllegalArgumentException("Output Writer is mandatory.");
            }
            try {
                Template t;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing template: " + template + " on model: " + model));
                }
                if ((t = this.getStringConfig(PATH, template).getTemplate(PATH)) != null) {
                    try {
                        t.process(model, out);
                        break block9;
                    }
                    catch (Throwable err) {
                        throw new TemplateException(MSG_ERROR_TEMPLATE_FAIL, new Object[]{err.getMessage()}, err);
                    }
                }
                throw new TemplateException(MSG_ERROR_NO_TEMPLATE, new Object[]{template});
            }
            catch (IOException ioerr) {
                throw new TemplateException(MSG_ERROR_TEMPLATE_IO, new Object[]{template}, ioerr);
            }
        }
    }
}

