/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateProcessor;
import org.alfresco.service.cmr.repository.TemplateService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateServiceImpl
implements TemplateService,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(TemplateService.class);
    private ApplicationContext applicationContext;
    private String defaultTemplateEngine;
    private Map<String, String> templateEngines;
    private static ThreadLocal<Map<String, TemplateProcessor>> processors = new ThreadLocal();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setDefaultTemplateEngine(String defaultTemplateEngine) {
        this.defaultTemplateEngine = defaultTemplateEngine;
    }

    public void setTemplateEngines(Map<String, String> templateEngines) {
        this.templateEngines = templateEngines;
    }

    @Override
    public TemplateProcessor getTemplateProcessor(String engine) {
        try {
            return this.getTemplateProcessorImpl(engine);
        }
        catch (Throwable err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Unable to load template processor.", err);
            }
            return null;
        }
    }

    @Override
    public void processTemplate(String engine, String template, Object model, Writer out) throws TemplateException {
        try {
            TemplateProcessor processor = this.getTemplateProcessorImpl(engine);
            processor.process(template, model, out);
        }
        catch (TemplateException terr) {
            throw terr;
        }
        catch (Throwable err) {
            throw new TemplateException(err.getMessage(), err);
        }
    }

    @Override
    public String processTemplate(String engine, String template, Object model) throws TemplateException {
        StringWriter out = new StringWriter(1024);
        this.processTemplate(engine, template, model, out);
        return ((Object)out).toString();
    }

    @Override
    public void processTemplateString(String engine, String template, Object model, Writer out) throws TemplateException {
        try {
            TemplateProcessor processor = this.getTemplateProcessorImpl(engine);
            processor.processString(template, model, out);
        }
        catch (TemplateException terr) {
            throw terr;
        }
        catch (Throwable err) {
            throw new TemplateException(err.getMessage(), err);
        }
    }

    @Override
    public String processTemplateString(String engine, String template, Object model) throws TemplateException {
        StringWriter out = new StringWriter(1024);
        this.processTemplateString(engine, template, model, out);
        return ((Object)out).toString();
    }

    private TemplateProcessor getTemplateProcessorImpl(String name) {
        TemplateProcessor processor;
        Map<String, TemplateProcessor> procMap = processors.get();
        if (procMap == null) {
            procMap = new HashMap<String, TemplateProcessor>(7, 1.0f);
            processors.set(procMap);
        }
        if (name == null) {
            name = this.defaultTemplateEngine;
        }
        if ((processor = procMap.get(name)) == null) {
            String className = this.templateEngines.get(name);
            if (className == null) {
                throw new AlfrescoRuntimeException("Unable to find configured ClassName for template engine: " + name);
            }
            try {
                Object obj;
                try {
                    obj = this.applicationContext.getBean(className);
                }
                catch (BeansException err) {
                    obj = Class.forName(className).newInstance();
                }
                if (!(obj instanceof TemplateProcessor)) {
                    throw new AlfrescoRuntimeException("Supplied template processors does not implement TemplateProcessor: " + className);
                }
                processor = (TemplateProcessor)obj;
            }
            catch (ClassNotFoundException err1) {
                throw new AlfrescoRuntimeException("Unable to load class for supplied template processors: " + className, (Throwable)err1);
            }
            catch (IllegalAccessException err2) {
                throw new AlfrescoRuntimeException("Unable to load class for supplied template processors: " + className, (Throwable)err2);
            }
            catch (InstantiationException err3) {
                throw new AlfrescoRuntimeException("Unable to instantiate class for supplied template processors: " + className, (Throwable)err3);
            }
            procMap.put(name, processor);
        }
        return processor;
    }
}

