/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.InputStream;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateNode;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class TemplateServiceImplTest
extends TestCase {
    private static final ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private ContentService contentService;
    private TemplateService templateService;
    private NodeService nodeService;
    private TransactionService transactionService;
    private ServiceRegistry serviceRegistry;
    private AuthenticationComponent authenticationComponent;
    private static final String TEMPLATE_1 = "org/alfresco/repo/template/test_template1.ftl";

    protected void setUp() throws Exception {
        super.setUp();
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.templateService = (TemplateService)ctx.getBean("templateService");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        TemplateServiceImplTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        TemplateServiceImplTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel(modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        BaseNodeServiceTest.loadModel(ctx);
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    public void testTemplates() {
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                StoreRef store = TemplateServiceImplTest.this.nodeService.createStore("workspace", "template_" + System.currentTimeMillis());
                NodeRef root = TemplateServiceImplTest.this.nodeService.getRootNode(store);
                BaseNodeServiceTest.buildNodeGraph(TemplateServiceImplTest.this.nodeService, root);
                Assert.assertNotNull((Object)TemplateServiceImplTest.this.templateService.getTemplateProcessor("freemarker"));
                HashMap<String, TemplateNode> model = new HashMap<String, TemplateNode>(7, 1.0f);
                model.put("root", new TemplateNode(root, TemplateServiceImplTest.this.serviceRegistry, null));
                String output = TemplateServiceImplTest.this.templateService.processTemplate("freemarker", TemplateServiceImplTest.TEMPLATE_1, model);
                Assert.assertTrue((output.indexOf(root.getId()) != -1 ? 1 : 0) != 0);
                System.out.print(output);
                return null;
            }
        });
    }
}

