/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionComponent;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionComponentTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private PlatformTransactionManager transactionManager;
    private TransactionComponent transactionComponent;
    private NodeService nodeService;

    public void setUp() throws Exception {
        this.transactionManager = (PlatformTransactionManager)ctx.getBean("transactionManager");
        this.transactionComponent = new TransactionComponent();
        this.transactionComponent.setTransactionManager(this.transactionManager);
        this.transactionComponent.setAllowWrite(true);
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
    }

    public void testPropagatingTxn() throws Exception {
        UserTransaction txnOuter = this.transactionComponent.getUserTransaction();
        txnOuter.begin();
        String txnIdOuter = AlfrescoTransactionSupport.getTransactionId();
        UserTransaction txnInner = this.transactionComponent.getUserTransaction();
        txnInner.begin();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        TransactionComponentTest.assertEquals((String)"Txn ID not propagated", (String)txnIdOuter, (String)txnIdInner);
        txnInner.rollback();
        TransactionComponentTest.assertEquals((String)"Inner txn not marked rolled back", (int)4, (int)txnInner.getStatus());
        TransactionComponentTest.assertEquals((String)"Outer txn not marked for rolled back", (int)1, (int)txnOuter.getStatus());
        try {
            txnOuter.commit();
            TransactionComponentTest.fail((String)"Outer txn not marked for rollback");
        }
        catch (RollbackException e) {
            txnOuter.rollback();
        }
    }

    public void testNonPropagatingTxn() throws Exception {
        UserTransaction txnOuter = this.transactionComponent.getUserTransaction();
        txnOuter.begin();
        String txnIdOuter = AlfrescoTransactionSupport.getTransactionId();
        UserTransaction txnInner = this.transactionComponent.getNonPropagatingUserTransaction();
        txnInner.begin();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        TransactionComponentTest.assertNotSame((String)"Txn ID not propagated", (Object)txnIdOuter, (Object)txnIdInner);
        txnInner.rollback();
        txnOuter.commit();
    }

    public void testReadOnlyTxn() throws Exception {
        this.transactionComponent.setAllowWrite(false);
        UserTransaction txn = this.transactionComponent.getUserTransaction();
        txn.begin();
        try {
            this.nodeService.createStore("workspace", this.getName() + "_" + System.currentTimeMillis());
            txn.commit();
            TransactionComponentTest.fail((String)"Read-only transaction wasn't detected");
        }
        catch (InvalidDataAccessApiUsageException e) {
            boolean bl = false;
        }
    }
}

