/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionUtil {
    private static Log logger = LogFactory.getLog(TransactionUtil.class);

    public static void flush() {
        AlfrescoTransactionSupport.flush();
    }

    public static <R> R executeInUserTransaction(TransactionService transactionService, TransactionWork<R> transactionWork) {
        return TransactionUtil.executeInTransaction(transactionService, transactionWork, false, false);
    }

    public static <R> R executeInUserTransaction(TransactionService transactionService, TransactionWork<R> transactionWork, boolean readOnly) {
        return TransactionUtil.executeInTransaction(transactionService, transactionWork, false, readOnly);
    }

    public static <R> R executeInNonPropagatingUserTransaction(TransactionService transactionService, TransactionWork<R> transactionWork) {
        return TransactionUtil.executeInTransaction(transactionService, transactionWork, true, false);
    }

    public static <R> R executeInNonPropagatingUserTransaction(TransactionService transactionService, TransactionWork<R> transactionWork, boolean readOnly) {
        return TransactionUtil.executeInTransaction(transactionService, transactionWork, true, readOnly);
    }

    private static <R> R executeInTransaction(TransactionService transactionService, TransactionWork<R> transactionWork, boolean nonPropagatingUserTransaction, boolean readOnly) {
        ParameterCheck.mandatory((String)"transactionWork", transactionWork);
        R result = null;
        UserTransaction txn = null;
        txn = nonPropagatingUserTransaction ? transactionService.getNonPropagatingUserTransaction() : transactionService.getUserTransaction(readOnly);
        try {
            txn.begin();
            result = transactionWork.doWork();
            if (txn.getStatus() == 1) {
                txn.rollback();
            } else {
                txn.commit();
            }
        }
        catch (RollbackException exception) {
            throw new AlfrescoRuntimeException("Unexpected rollback of exception: \n" + exception.getMessage(), (Throwable)exception);
        }
        catch (Throwable exception) {
            try {
                txn.rollback();
            }
            catch (Throwable rollbackException) {
                logger.error((Object)"Error rolling back transaction", rollbackException);
            }
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Error during execution of transaction.", exception);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TransactionWork<Result> {
        public Result doWork() throws Exception;
    }
}

