/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.version.common.counter.VersionCounterService;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TestWithUserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseVersionStoreTest
extends BaseSpringTest {
    protected NodeService dbNodeService;
    protected VersionService versionService;
    protected VersionCounterService versionCounterDaoService;
    protected ContentService contentService;
    protected DictionaryDAO dictionaryDAO;
    protected AuthenticationService authenticationService;
    protected TransactionService transactionService;
    protected MutableAuthenticationDao authenticationDAO;
    protected StoreRef testStoreRef;
    protected NodeRef rootNodeRef;
    protected Map<String, Serializable> versionProperties;
    protected HashMap<QName, Serializable> nodeProperties;
    protected HashMap<String, NodeRef> versionableNodes;
    protected static final String TEST_NAMESPACE = "http://www.alfresco.org/test/versionstorebasetest/1.0";
    protected static final QName TEST_TYPE_QNAME = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "testtype");
    protected static final QName TEST_ASPECT_QNAME = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "testaspect");
    protected static final QName PROP_1 = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "prop1");
    protected static final QName PROP_2 = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "prop2");
    protected static final QName PROP_3 = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "prop3");
    protected static final QName MULTI_PROP = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "multiProp");
    protected static final String VERSION_PROP_1 = "versionProp1";
    protected static final String VERSION_PROP_2 = "versionProp2";
    protected static final String VERSION_PROP_3 = "versionProp3";
    protected static final String VALUE_1 = "value1";
    protected static final String VALUE_2 = "value2";
    protected static final String VALUE_3 = "value3";
    protected static final QName TEST_CHILD_ASSOC_1 = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "childassoc1");
    protected static final QName TEST_CHILD_ASSOC_2 = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "childassoc2");
    protected static final QName TEST_ASSOC = QName.createQName("http://www.alfresco.org/test/versionstorebasetest/1.0", "assoc1");
    protected Collection<String> multiValue = null;
    protected static final String MULTI_VALUE_1 = "multi1";
    protected static final String MULTI_VALUE_2 = "multi2";
    protected static final String TEST_CONTENT = "This is the versioned test content.";
    private static final String PWD = "admin";
    private static final String USER_NAME = "admin";

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    protected void onSetUpInTransaction() throws Exception {
        if (this.multiValue == null) {
            this.multiValue = new ArrayList<String>();
            this.multiValue.add(MULTI_VALUE_1);
            this.multiValue.add(MULTI_VALUE_2);
        }
        this.dbNodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.versionService = (VersionService)this.applicationContext.getBean("versionService");
        this.versionCounterDaoService = (VersionCounterService)this.applicationContext.getBean("versionCounterService");
        this.contentService = (ContentService)this.applicationContext.getBean("contentService");
        this.authenticationService = (AuthenticationService)this.applicationContext.getBean("authenticationService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("transactionComponent");
        this.authenticationDAO = (MutableAuthenticationDao)this.applicationContext.getBean("alfDaoImpl");
        this.authenticationService.clearCurrentSecurityContext();
        this.createTestModel();
        this.versionProperties = new HashMap<String, Serializable>();
        this.versionProperties.put(VERSION_PROP_1, (Serializable)((Object)VALUE_1));
        this.versionProperties.put(VERSION_PROP_2, (Serializable)((Object)VALUE_2));
        this.versionProperties.put(VERSION_PROP_3, (Serializable)((Object)VALUE_3));
        this.nodeProperties = new HashMap();
        this.nodeProperties.put(PROP_1, (Serializable)((Object)VALUE_1));
        this.nodeProperties.put(PROP_2, (Serializable)((Object)VALUE_2));
        this.nodeProperties.put(PROP_3, (Serializable)((Object)VALUE_3));
        this.nodeProperties.put(MULTI_PROP, (Serializable)((Object)this.multiValue));
        this.nodeProperties.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-8"));
        this.testStoreRef = this.dbNodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.dbNodeService.getRootNode(this.testStoreRef);
        if (!this.authenticationDAO.userExists("admin")) {
            this.authenticationService.createAuthentication("admin", "admin".toCharArray());
        }
        TestWithUserUtils.authenticateUser("admin", "admin", this.rootNodeRef, this.authenticationService);
    }

    private void createTestModel() {
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("org/alfresco/repo/version/VersionStoreBaseTest_model.xml");
        M2Model model = M2Model.createModel(is);
        this.dictionaryDAO.putModel(model);
    }

    protected NodeRef createNewVersionableNode() {
        this.versionableNodes = new HashMap();
        NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}MyVersionableNode"), TEST_TYPE_QNAME, this.nodeProperties).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, new HashMap<QName, Serializable>());
        BaseVersionStoreTest.assertNotNull((Object)nodeRef);
        this.versionableNodes.put(nodeRef.getId(), nodeRef);
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(TEST_CONTENT);
        NodeRef child1 = this.dbNodeService.createNode(nodeRef, TEST_CHILD_ASSOC_1, TEST_CHILD_ASSOC_1, TEST_TYPE_QNAME, this.nodeProperties).getChildRef();
        this.dbNodeService.addAspect(child1, ContentModel.ASPECT_VERSIONABLE, new HashMap<QName, Serializable>());
        BaseVersionStoreTest.assertNotNull((Object)child1);
        this.versionableNodes.put(child1.getId(), child1);
        NodeRef child2 = this.dbNodeService.createNode(nodeRef, TEST_CHILD_ASSOC_2, TEST_CHILD_ASSOC_2, TEST_TYPE_QNAME, this.nodeProperties).getChildRef();
        this.dbNodeService.addAspect(child2, ContentModel.ASPECT_VERSIONABLE, new HashMap<QName, Serializable>());
        BaseVersionStoreTest.assertNotNull((Object)child2);
        this.versionableNodes.put(child2.getId(), child2);
        NodeRef assocNode = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}MyAssocNode"), TEST_TYPE_QNAME, this.nodeProperties).getChildRef();
        BaseVersionStoreTest.assertNotNull((Object)assocNode);
        this.dbNodeService.createAssociation(nodeRef, assocNode, TEST_ASSOC);
        return nodeRef;
    }

    protected Version createVersion(NodeRef versionableNode) {
        return this.createVersion(versionableNode, this.versionProperties);
    }

    protected Version createVersion(NodeRef versionableNode, Map<String, Serializable> versionProperties) {
        int nextVersion = this.peekNextVersionNumber();
        String nextVersionLabel = this.peekNextVersionLabel(versionableNode, nextVersion, versionProperties);
        long beforeVersionTime = System.currentTimeMillis();
        Version newVersion = this.versionService.createVersion(versionableNode, this.versionProperties);
        this.checkNewVersion(beforeVersionTime, nextVersion, nextVersionLabel, newVersion, versionableNode);
        return newVersion;
    }

    protected String peekNextVersionLabel(NodeRef nodeRef, int versionNumber, Map<String, Serializable> versionProperties) {
        Version version = this.versionService.getCurrentVersion(nodeRef);
        SerialVersionLabelPolicy policy = new SerialVersionLabelPolicy();
        return policy.calculateVersionLabel(ContentModel.TYPE_CMOBJECT, version, versionNumber, versionProperties);
    }

    protected void checkNewVersion(long beforeVersionTime, int expectedVersionNumber, String expectedVersionLabel, Version newVersion, NodeRef versionableNode) {
        BaseVersionStoreTest.assertNotNull((Object)newVersion);
        BaseVersionStoreTest.assertEquals((String)"The expected version number was not used.", (String)Integer.toString(expectedVersionNumber), (String)newVersion.getVersionProperty("versionNumber").toString());
        BaseVersionStoreTest.assertEquals((String)"The expected version label was not used.", (String)expectedVersionLabel, (String)newVersion.getVersionLabel());
        long afterVersionTime = System.currentTimeMillis();
        long createdDate = newVersion.getCreatedDate().getTime();
        if (createdDate < beforeVersionTime || createdDate > afterVersionTime) {
            BaseVersionStoreTest.fail((String)"The created date of the version is incorrect.");
        }
        BaseVersionStoreTest.assertEquals((String)"admin", (String)newVersion.getCreator());
        Map<String, Serializable> props = newVersion.getVersionProperties();
        BaseVersionStoreTest.assertNotNull((String)"The version properties collection should not be null.", props);
        for (String key : this.versionProperties.keySet()) {
            BaseVersionStoreTest.assertEquals((Object)this.versionProperties.get(key), (Object)newVersion.getVersionProperty(key));
        }
        NodeRef nodeRef = newVersion.getFrozenStateNodeRef();
        BaseVersionStoreTest.assertNotNull((Object)nodeRef);
        BaseVersionStoreTest.assertEquals((String)"lightWeightVersionStore", (String)nodeRef.getStoreRef().getIdentifier());
        BaseVersionStoreTest.assertEquals((String)"versionStore", (String)nodeRef.getStoreRef().getProtocol());
        BaseVersionStoreTest.assertNotNull((Object)nodeRef.getId());
        String currentVersionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        BaseVersionStoreTest.assertEquals((String)newVersion.getVersionLabel(), (String)currentVersionLabel);
    }

    protected int peekNextVersionNumber() {
        StoreRef lwVersionStoreRef = this.versionService.getVersionStoreReference();
        return this.versionCounterDaoService.currentVersionNumber(lwVersionStoreRef) + 1;
    }
}

