/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeServiceImpl
implements NodeService,
VersionModel {
    private static final String MSG_UNSUPPORTED = "This operation is not supported by a version store implementation of the node service.";
    private static final QName rootAssocName = QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "versionedState");
    protected NodeService dbNodeService;
    private SearchService searcher;
    protected DictionaryService dicitionaryService;

    public void setDbNodeService(NodeService nodeService) {
        this.dbNodeService = nodeService;
    }

    public void setSearcher(SearchService searcher) {
        this.searcher = searcher;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dicitionaryService = dictionaryService;
    }

    @Override
    public List<StoreRef> getStores() {
        return this.dbNodeService.getStores();
    }

    @Override
    public StoreRef createStore(String protocol, String identifier) {
        return this.dbNodeService.createStore(protocol, identifier);
    }

    @Override
    public boolean exists(StoreRef storeRef) {
        return this.dbNodeService.exists(storeRef);
    }

    @Override
    public boolean exists(NodeRef nodeRef) {
        return this.dbNodeService.exists(this.convertNodeRef(nodeRef));
    }

    @Override
    public NodeRef.Status getNodeStatus(NodeRef nodeRef) {
        return this.dbNodeService.getNodeStatus(nodeRef);
    }

    private NodeRef convertNodeRef(NodeRef nodeRef) {
        return new NodeRef(new StoreRef("workspace", "lightWeightVersionStore"), nodeRef.getId());
    }

    @Override
    public NodeRef getRootNode(StoreRef storeRef) {
        return this.dbNodeService.getRootNode(storeRef);
    }

    @Override
    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public void deleteNode(NodeRef nodeRef) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public ChildAssociationRef addChild(NodeRef parentRef, NodeRef childRef, QName assocTypeQName, QName qname) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public void removeChild(NodeRef parentRef, NodeRef childRef) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public ChildAssociationRef moveNode(NodeRef nodeToMoveRef, NodeRef newParentRef, QName assocTypeQName, QName assocQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public void setChildAssociationIndex(ChildAssociationRef childAssocRef, int index) throws InvalidChildAssociationRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public QName getType(NodeRef nodeRef) throws InvalidNodeRefException {
        return (QName)this.dbNodeService.getProperty(this.convertNodeRef(nodeRef), PROP_QNAME_FROZEN_NODE_TYPE);
    }

    @Override
    public void setType(NodeRef nodeRef, QName typeQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public void addAspect(NodeRef nodeRef, QName aspectRef, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public boolean hasAspect(NodeRef nodeRef, QName aspectRef) throws InvalidNodeRefException, InvalidAspectException {
        return this.getAspects(nodeRef).contains(aspectRef);
    }

    @Override
    public void removeAspect(NodeRef nodeRef, QName aspectRef) throws InvalidNodeRefException, InvalidAspectException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        return new HashSet<QName>((ArrayList)this.dbNodeService.getProperty(this.convertNodeRef(nodeRef), PROP_QNAME_FROZEN_ASPECTS));
    }

    @Override
    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        List<ChildAssociationRef> children = this.dbNodeService.getChildAssocs(this.convertNodeRef(nodeRef));
        for (ChildAssociationRef child : children) {
            if (!child.getQName().equals(CHILD_QNAME_VERSIONED_ATTRIBUTES)) continue;
            NodeRef versionedAttribute = child.getChildRef();
            Serializable value = null;
            QName qName = (QName)this.dbNodeService.getProperty(versionedAttribute, PROP_QNAME_QNAME);
            Boolean isMultiValue = (Boolean)this.dbNodeService.getProperty(versionedAttribute, PROP_QNAME_IS_MULTI_VALUE);
            value = isMultiValue == false ? this.dbNodeService.getProperty(versionedAttribute, PROP_QNAME_VALUE) : this.dbNodeService.getProperty(versionedAttribute, PROP_QNAME_MULTI_VALUE);
            result.put(qName, value);
        }
        return result;
    }

    @Override
    public Serializable getProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Map<QName, Serializable> properties = this.getProperties(this.convertNodeRef(nodeRef));
        return properties.get(qname);
    }

    @Override
    public void setProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public void setProperty(NodeRef nodeRef, QName qame, Serializable value) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef) {
        return this.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    @Override
    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        if (qnamePattern.isMatch(rootAssocName)) {
            result.add(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.dbNodeService.getRootNode(new StoreRef("workspace", "lightWeightVersionStore")), rootAssocName, nodeRef));
        }
        return result;
    }

    @Override
    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        return this.getChildAssocs(this.convertNodeRef(nodeRef), RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    @Override
    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) throws InvalidNodeRefException {
        List<ChildAssociationRef> childAssocRefs = this.dbNodeService.getChildAssocs(this.convertNodeRef(nodeRef), RegexQNamePattern.MATCH_ALL, CHILD_QNAME_VERSIONED_CHILD_ASSOCS);
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            NodeRef childRef = childAssocRef.getChildRef();
            NodeRef referencedNode = (NodeRef)this.dbNodeService.getProperty(childRef, ContentModel.PROP_REFERENCE);
            QName qName = (QName)this.dbNodeService.getProperty(childRef, PROP_QNAME_ASSOC_QNAME);
            if (!qnamePattern.isMatch(qName)) continue;
            QName assocType = (QName)this.dbNodeService.getProperty(childRef, PROP_QNAME_ASSOC_TYPE_QNAME);
            boolean isPrimary = (Boolean)this.dbNodeService.getProperty(childRef, PROP_QNAME_IS_PRIMARY);
            int nthSibling = (Integer)this.dbNodeService.getProperty(childRef, PROP_QNAME_NTH_SIBLING);
            ChildAssociationRef newChildAssocRef = new ChildAssociationRef(assocType, nodeRef, qName, referencedNode, isPrimary, nthSibling);
            result.add(newChildAssocRef);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) throws InvalidNodeRefException {
        return new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.dbNodeService.getRootNode(new StoreRef("workspace", "lightWeightVersionStore")), rootAssocName, nodeRef);
    }

    @Override
    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException, AssociationExistsException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public void removeAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        List<ChildAssociationRef> childAssocRefs = this.dbNodeService.getChildAssocs(this.convertNodeRef(sourceRef), RegexQNamePattern.MATCH_ALL, CHILD_QNAME_VERSIONED_ASSOCS);
        ArrayList<AssociationRef> result = new ArrayList<AssociationRef>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            NodeRef childRef = childAssocRef.getChildRef();
            NodeRef referencedNode = (NodeRef)this.dbNodeService.getProperty(childRef, ContentModel.PROP_REFERENCE);
            QName qName = (QName)this.dbNodeService.getProperty(childRef, PROP_QNAME_ASSOC_TYPE_QNAME);
            if (!qnamePattern.isMatch(qName)) continue;
            AssociationRef newAssocRef = new AssociationRef(sourceRef, qName, referencedNode);
            result.add(newAssocRef);
        }
        return result;
    }

    @Override
    public List<AssociationRef> getSourceAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public Path getPath(NodeRef nodeRef) throws InvalidNodeRefException {
        ChildAssociationRef childAssocRef = this.getPrimaryParent(nodeRef);
        Path path = new Path();
        path.append(new Path.ChildAssocElement(childAssocRef));
        return path;
    }

    @Override
    public List<Path> getPaths(NodeRef nodeRef, boolean primaryOnly) throws InvalidNodeRefException {
        ArrayList<Path> paths = new ArrayList<Path>(1);
        paths.add(this.getPath(nodeRef));
        return paths;
    }

    @Override
    public NodeRef getStoreArchiveNode(StoreRef storeRef) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    @Override
    public NodeRef restoreNode(NodeRef archivedNodeRef, NodeRef targetParentNodeRef, QName assocTypeQName, QName assocQName) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }
}

