/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.common.AbstractVersionServiceImpl;
import org.alfresco.repo.version.common.VersionHistoryImpl;
import org.alfresco.repo.version.common.VersionImpl;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.repo.version.common.counter.VersionCounterService;
import org.alfresco.repo.version.common.versionlabel.SerialVersionLabelPolicy;
import org.alfresco.service.cmr.repository.AspectMissingException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.version.ReservedVersionNameException;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ParameterCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionServiceImpl
extends AbstractVersionServiceImpl
implements VersionService,
VersionModel {
    private static final String MSGID_ERR_NOT_FOUND = "version_service.err_not_found";
    private static final String MSGID_ERR_NO_BRANCHES = "version_service.err_unsupported";
    private static final String MSGID_ERR_RESTORE_EXISTS = "version_service.err_restore_exists";
    private static final String MSGID_ERR_ONE_PRECEEDING = "version_service.err_one_preceeding";
    private static final String MSGID_ERR_RESTORE_NO_VERSION = "version_service.err_restore_no_version";
    private static final String MSGID_ERR_REVERT_MISMATCH = "version_service.err_revert_mismatch";
    private VersionCounterService versionCounterService;
    protected NodeService dbNodeService;
    private BehaviourFilter policyBehaviourFilter;
    private SearchService searcher;

    public void setDbNodeService(NodeService nodeService) {
        this.dbNodeService = nodeService;
    }

    public void setSearcher(SearchService searcher) {
        this.searcher = searcher;
    }

    public void setVersionCounterService(VersionCounterService versionCounterService) {
        this.versionCounterService = versionCounterService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    @Override
    public void initialise() {
        super.initialise();
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "calculateVersionLabel"), ContentModel.TYPE_CMOBJECT, (Behaviour)new JavaBehaviour(new SerialVersionLabelPolicy(), "calculateVersionLabel"));
    }

    @Override
    public StoreRef getVersionStoreReference() {
        return new StoreRef("workspace", "lightWeightVersionStore");
    }

    @Override
    public Version createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        int versionNumber = this.versionCounterService.nextVersionNumber(this.getVersionStoreReference());
        return this.createVersion(nodeRef, versionProperties, versionNumber);
    }

    @Override
    public Collection<Version> createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties, boolean versionChildren) throws ReservedVersionNameException, AspectMissingException {
        int versionNumber = this.versionCounterService.nextVersionNumber(this.getVersionStoreReference());
        return this.createVersion(nodeRef, versionProperties, versionChildren, versionNumber);
    }

    private Collection<Version> createVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties, boolean versionChildren, int versionNumber) throws ReservedVersionNameException, AspectMissingException {
        ArrayList<Version> result = new ArrayList<Version>();
        if (versionChildren) {
            List<ChildAssociationRef> children = this.dbNodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssoc : children) {
                Collection<Version> childVersions = this.createVersion(childAssoc.getChildRef(), versionProperties, versionChildren, versionNumber);
                result.addAll(childVersions);
            }
        }
        result.add(this.createVersion(nodeRef, versionProperties, versionNumber));
        return result;
    }

    @Override
    public Collection<Version> createVersion(Collection<NodeRef> nodeRefs, Map<String, Serializable> versionProperties) throws ReservedVersionNameException, AspectMissingException {
        ArrayList<Version> result = new ArrayList<Version>(nodeRefs.size());
        int versionNumber = this.versionCounterService.nextVersionNumber(this.getVersionStoreReference());
        for (NodeRef nodeRef : nodeRefs) {
            result.add(this.createVersion(nodeRef, versionProperties, versionNumber));
        }
        return result;
    }

    private Version createVersion(NodeRef nodeRef, Map<String, Serializable> origVersionProperties, int versionNumber) throws ReservedVersionNameException {
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        if (origVersionProperties != null) {
            versionProperties.putAll(origVersionProperties);
        }
        if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        }
        this.invokeBeforeCreateVersion(nodeRef);
        VersionUtil.checkVersionPropertyNames(versionProperties.keySet());
        NodeRef versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef);
        NodeRef currentVersionRef = null;
        if (versionHistoryRef == null) {
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
            props.put(PROP_QNAME_VERSIONED_NODE_ID, (Serializable)((Object)nodeRef.getId()));
            ChildAssociationRef childAssocRef = this.dbNodeService.createNode(this.getRootNode(), ContentModel.ASSOC_CHILDREN, CHILD_QNAME_VERSION_HISTORIES, TYPE_QNAME_VERSION_HISTORY, props);
            versionHistoryRef = childAssocRef.getChildRef();
        } else {
            Version currentVersion;
            currentVersionRef = this.getCurrentVersionNodeRef(versionHistoryRef, nodeRef);
            if (currentVersionRef == null) {
                throw new VersionServiceException(MSGID_ERR_NOT_FOUND);
            }
            VersionHistory versionHistory = this.buildVersionHistory(versionHistoryRef, nodeRef);
            if (versionHistory.getSuccessors(currentVersion = this.getVersion(currentVersionRef)).size() != 0) {
                throw new VersionServiceException(MSGID_ERR_NO_BRANCHES);
            }
        }
        QName classRef = this.nodeService.getType(nodeRef);
        PolicyScope nodeDetails = new PolicyScope(classRef);
        this.invokeOnCreateVersion(nodeRef, versionProperties, nodeDetails);
        NodeRef newVersionRef = this.createNewVersion(nodeRef, versionHistoryRef, this.getStandardVersionProperties(versionProperties, nodeRef, currentVersionRef, versionNumber), versionProperties, nodeDetails);
        if (currentVersionRef == null) {
            this.dbNodeService.createAssociation(versionHistoryRef, newVersionRef, ASSOC_ROOT_VERSION);
        } else {
            this.dbNodeService.createAssociation(currentVersionRef, newVersionRef, ASSOC_SUCCESSOR);
        }
        Version version = this.getVersion(newVersionRef);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)version.getVersionLabel()));
        return version;
    }

    @Override
    public VersionHistory getVersionHistory(NodeRef nodeRef) {
        NodeRef versionHistoryRef;
        VersionHistory versionHistory = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && (versionHistoryRef = this.getVersionHistoryNodeRef(nodeRef)) != null) {
            versionHistory = this.buildVersionHistory(versionHistoryRef, nodeRef);
        }
        return versionHistory;
    }

    @Override
    public Version getCurrentVersion(NodeRef nodeRef) {
        VersionHistory versionHistory;
        Version version = null;
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && (versionHistory = this.getVersionHistory(nodeRef)) != null) {
            String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
            version = versionHistory.getVersion(versionLabel);
        }
        return version;
    }

    private Map<QName, Serializable> getStandardVersionProperties(Map<String, Serializable> versionProperties, NodeRef nodeRef, NodeRef preceedingNodeRef, int versionNumber) {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>(10);
        result.put(QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "versionNumber"), (Serializable)((Object)Integer.toString(versionNumber)));
        result.put(QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "frozenNodeId"), (Serializable)((Object)nodeRef.getId()));
        result.put(QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "frozenNodeStoreProtocol"), (Serializable)((Object)nodeRef.getStoreRef().getProtocol()));
        result.put(QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "frozenNodeStoreId"), (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
        QName nodeType = this.nodeService.getType(nodeRef);
        result.put(QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "frozenNodeType"), nodeType);
        Set<QName> aspects = this.nodeService.getAspects(nodeRef);
        result.put(QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "frozenAspects"), (Serializable)((Object)aspects));
        QName classRef = this.nodeService.getType(nodeRef);
        Version preceedingVersion = this.getVersion(preceedingNodeRef);
        String versionLabel = this.invokeCalculateVersionLabel(classRef, preceedingVersion, versionNumber, versionProperties);
        result.put(QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "versionLabel"), (Serializable)((Object)versionLabel));
        return result;
    }

    private NodeRef createNewVersion(NodeRef versionableNodeRef, NodeRef versionHistoryRef, Map<QName, Serializable> standardVersionProperties, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        ChildAssociationRef childAssocRef = this.dbNodeService.createNode(versionHistoryRef, CHILD_QNAME_VERSIONS, CHILD_QNAME_VERSIONS, TYPE_QNAME_VERSION, standardVersionProperties);
        NodeRef versionNodeRef = childAssocRef.getChildRef();
        this.storeVersionMetaData(versionNodeRef, versionProperties);
        this.freezeProperties(versionNodeRef, nodeDetails.getProperties());
        this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations());
        this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations());
        this.freezeAspects(nodeDetails, versionNodeRef, nodeDetails.getAspects());
        return versionNodeRef;
    }

    private void storeVersionMetaData(NodeRef versionNodeRef, Map<String, Serializable> versionProperties) {
        for (Map.Entry<String, Serializable> entry : versionProperties.entrySet()) {
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(PROP_QNAME_META_DATA_NAME, (Serializable)((Object)entry.getKey()));
            properties.put(PROP_QNAME_META_DATA_VALUE, entry.getValue());
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSION_META_DATA, CHILD_QNAME_VERSION_META_DATA, TYPE_QNAME_VERSION_META_DATA_VALUE, properties);
        }
    }

    private void freezeAspects(PolicyScope nodeDetails, NodeRef versionNodeRef, Set<QName> aspects) {
        for (QName aspect : aspects) {
            this.freezeProperties(versionNodeRef, nodeDetails.getProperties(aspect));
            this.freezeChildAssociations(versionNodeRef, nodeDetails.getChildAssociations(aspect));
            this.freezeAssociations(versionNodeRef, nodeDetails.getAssociations(aspect));
        }
    }

    private void freezeAssociations(NodeRef versionNodeRef, List<AssociationRef> associations) {
        for (AssociationRef targetAssoc : associations) {
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(PROP_QNAME_ASSOC_TYPE_QNAME, targetAssoc.getTypeQName());
            properties.put(ContentModel.PROP_REFERENCE, targetAssoc.getTargetRef());
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSIONED_ASSOCS, CHILD_QNAME_VERSIONED_ASSOCS, TYPE_QNAME_VERSIONED_ASSOC, properties);
        }
    }

    private void freezeChildAssociations(NodeRef versionNodeRef, List<ChildAssociationRef> childAssociations) {
        for (ChildAssociationRef childAssocRef : childAssociations) {
            HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
            properties.put(PROP_QNAME_ASSOC_QNAME, childAssocRef.getQName());
            properties.put(PROP_QNAME_ASSOC_TYPE_QNAME, childAssocRef.getTypeQName());
            properties.put(PROP_QNAME_IS_PRIMARY, Boolean.valueOf(childAssocRef.isPrimary()));
            properties.put(PROP_QNAME_NTH_SIBLING, Integer.valueOf(childAssocRef.getNthSibling()));
            properties.put(ContentModel.PROP_REFERENCE, childAssocRef.getChildRef());
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSIONED_CHILD_ASSOCS, CHILD_QNAME_VERSIONED_CHILD_ASSOCS, TYPE_QNAME_VERSIONED_CHILD_ASSOC, properties);
        }
    }

    private void freezeProperties(NodeRef versionNodeRef, Map<QName, Serializable> properties) {
        for (Map.Entry<QName, Serializable> entry : properties.entrySet()) {
            HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
            props.put(PROP_QNAME_QNAME, entry.getKey());
            if (entry.getValue() instanceof Collection) {
                props.put(PROP_QNAME_MULTI_VALUE, entry.getValue());
                props.put(PROP_QNAME_IS_MULTI_VALUE, Boolean.valueOf(true));
            } else {
                props.put(PROP_QNAME_VALUE, entry.getValue());
                props.put(PROP_QNAME_IS_MULTI_VALUE, Boolean.valueOf(false));
            }
            this.dbNodeService.createNode(versionNodeRef, CHILD_QNAME_VERSIONED_ATTRIBUTES, CHILD_QNAME_VERSIONED_ATTRIBUTES, TYPE_QNAME_VERSIONED_PROPERTY, props);
        }
    }

    private NodeRef getRootNode() {
        return this.dbNodeService.getRootNode(this.getVersionStoreReference());
    }

    private VersionHistory buildVersionHistory(NodeRef versionHistoryRef, NodeRef nodeRef) {
        VersionHistoryImpl versionHistory = null;
        ArrayList<NodeRef> versionHistoryNodeRefs = new ArrayList<NodeRef>();
        NodeRef currentVersion = this.getCurrentVersionNodeRef(versionHistoryRef, nodeRef);
        while (currentVersion != null) {
            AssociationRef preceedingVersion = null;
            versionHistoryNodeRefs.add(0, currentVersion);
            List<AssociationRef> preceedingVersions = this.dbNodeService.getSourceAssocs(currentVersion, VersionModel.ASSOC_SUCCESSOR);
            if (preceedingVersions.size() == 1) {
                preceedingVersion = (AssociationRef)preceedingVersions.toArray()[0];
                currentVersion = preceedingVersion.getSourceRef();
                continue;
            }
            if (preceedingVersions.size() > 1) {
                throw new VersionServiceException(MSGID_ERR_ONE_PRECEEDING);
            }
            currentVersion = null;
        }
        boolean isRoot = true;
        Version preceeding = null;
        for (NodeRef versionRef : versionHistoryNodeRefs) {
            Version version = this.getVersion(versionRef);
            if (isRoot) {
                versionHistory = new VersionHistoryImpl(version);
                isRoot = false;
            } else {
                ((VersionHistoryImpl)versionHistory).addVersion(version, preceeding);
            }
            preceeding = version;
        }
        return versionHistory;
    }

    private Version getVersion(NodeRef versionRef) {
        if (versionRef == null) {
            return null;
        }
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        Map<QName, Serializable> nodeProperties = this.dbNodeService.getProperties(versionRef);
        for (QName key : nodeProperties.keySet()) {
            Serializable value = nodeProperties.get(key);
            versionProperties.put(key.getLocalName(), value);
        }
        List<ChildAssociationRef> metaData = this.dbNodeService.getChildAssocs(versionRef, RegexQNamePattern.MATCH_ALL, CHILD_QNAME_VERSION_META_DATA);
        for (ChildAssociationRef ref : metaData) {
            NodeRef metaDataValue = ref.getChildRef();
            String name = (String)((Object)this.dbNodeService.getProperty(metaDataValue, PROP_QNAME_META_DATA_NAME));
            Serializable value = this.dbNodeService.getProperty(metaDataValue, PROP_QNAME_META_DATA_VALUE);
            versionProperties.put(name, value);
        }
        NodeRef newNodeRef = new NodeRef(new StoreRef("versionStore", "lightWeightVersionStore"), versionRef.getId());
        VersionImpl result = new VersionImpl(versionProperties, newNodeRef);
        return result;
    }

    private NodeRef getVersionHistoryNodeRef(NodeRef nodeRef) {
        NodeRef result = null;
        List<ChildAssociationRef> versionHistories = this.dbNodeService.getChildAssocs(this.getRootNode());
        for (ChildAssociationRef versionHistory : versionHistories) {
            String nodeId = (String)((Object)this.dbNodeService.getProperty(versionHistory.getChildRef(), VersionModel.PROP_QNAME_VERSIONED_NODE_ID));
            if (nodeId == null || !nodeId.equals(nodeRef.getId())) continue;
            result = versionHistory.getChildRef();
            break;
        }
        return result;
    }

    private NodeRef getCurrentVersionNodeRef(NodeRef versionHistory, NodeRef nodeRef) {
        NodeRef result = null;
        String versionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
        List<ChildAssociationRef> versions = this.dbNodeService.getChildAssocs(versionHistory);
        for (ChildAssociationRef version : versions) {
            String tempLabel = (String)((Object)this.dbNodeService.getProperty(version.getChildRef(), VersionModel.PROP_QNAME_VERSION_LABEL));
            if (tempLabel == null || !tempLabel.equals(versionLabel)) continue;
            result = version.getChildRef();
            break;
        }
        return result;
    }

    private void checkForVersionAspect(NodeRef nodeRef) throws AspectMissingException {
        QName aspectRef = ContentModel.ASPECT_VERSIONABLE;
        if (!this.nodeService.hasAspect(nodeRef, aspectRef)) {
            throw new AspectMissingException(aspectRef, nodeRef);
        }
    }

    @Override
    public void revert(NodeRef nodeRef) {
        this.revert(nodeRef, this.getCurrentVersion(nodeRef), true);
    }

    @Override
    public void revert(NodeRef nodeRef, boolean deep) {
        this.revert(nodeRef, this.getCurrentVersion(nodeRef), deep);
    }

    @Override
    public void revert(NodeRef nodeRef, Version version) {
        this.revert(nodeRef, version, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revert(NodeRef nodeRef, Version version, boolean deep) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"version", (Object)version);
        if (!nodeRef.getId().equals(version.getVersionProperty("frozenNodeId"))) {
            throw new VersionServiceException(MSGID_ERR_REVERT_MISMATCH);
        }
        this.policyBehaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        try {
            String currentVersionLabel = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_LABEL));
            NodeRef versionNodeRef = version.getFrozenStateNodeRef();
            this.nodeService.setProperties(nodeRef, this.nodeService.getProperties(versionNodeRef));
            HashSet<QName> aspects = new HashSet<QName>(this.nodeService.getAspects(nodeRef));
            for (QName versionAspect : this.nodeService.getAspects(versionNodeRef)) {
                if (!aspects.contains(versionAspect)) {
                    this.nodeService.addAspect(nodeRef, versionAspect, null);
                    continue;
                }
                aspects.remove(versionAspect);
            }
            for (QName aspect : aspects) {
                this.nodeService.removeAspect(nodeRef, aspect);
            }
            if (!this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
                this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
            }
            this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, (Serializable)((Object)currentVersionLabel));
            ArrayList<ChildAssociationRef> children = new ArrayList<ChildAssociationRef>(this.nodeService.getChildAssocs(nodeRef));
            for (ChildAssociationRef versionedChild : this.nodeService.getChildAssocs(versionNodeRef)) {
                if (!children.contains(versionedChild)) {
                    if (this.nodeService.exists(versionedChild.getChildRef())) {
                        this.nodeService.addChild(nodeRef, versionedChild.getChildRef(), versionedChild.getTypeQName(), versionedChild.getQName());
                        continue;
                    }
                    if (!versionedChild.isPrimary() || !deep || this.getVersionHistoryNodeRef(versionedChild.getChildRef()) == null) continue;
                    this.restore(versionedChild.getChildRef(), nodeRef, versionedChild.getTypeQName(), versionedChild.getQName());
                    continue;
                }
                children.remove(versionedChild);
            }
            for (ChildAssociationRef ref : children) {
                this.nodeService.removeChild(nodeRef, ref.getChildRef());
            }
            for (AssociationRef assocRef : this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL)) {
                this.nodeService.removeAssociation(assocRef.getSourceRef(), assocRef.getTargetRef(), assocRef.getTypeQName());
            }
            for (AssociationRef versionedAssoc : this.nodeService.getTargetAssocs(versionNodeRef, RegexQNamePattern.MATCH_ALL)) {
                if (!this.nodeService.exists(versionedAssoc.getTargetRef())) continue;
                this.nodeService.createAssociation(nodeRef, versionedAssoc.getTargetRef(), versionedAssoc.getTypeQName());
            }
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(nodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
    }

    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName) {
        return this.restore(nodeRef, parentNodeRef, assocTypeQName, assocQName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeRef restore(NodeRef nodeRef, NodeRef parentNodeRef, QName assocTypeQName, QName assocQName, boolean deep) {
        NodeRef restoredNodeRef = null;
        if (this.nodeService.exists(nodeRef)) {
            throw new VersionServiceException(MSGID_ERR_RESTORE_EXISTS, new Object[]{nodeRef.toString()});
        }
        Version version = this.getHeadVersion(nodeRef);
        if (version == null) {
            throw new VersionServiceException(MSGID_ERR_RESTORE_NO_VERSION, new Object[]{nodeRef.toString()});
        }
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1);
        props.put(ContentModel.PROP_NODE_UUID, version.getVersionProperty("frozenNodeId"));
        QName type = (QName)version.getVersionProperty("frozenNodeType");
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        try {
            restoredNodeRef = this.nodeService.createNode(parentNodeRef, assocTypeQName, assocQName, type, props).getChildRef();
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        }
        this.revert(restoredNodeRef, version, deep);
        return restoredNodeRef;
    }

    private Version getHeadVersion(NodeRef nodeRef) {
        Version version = null;
        StoreRef storeRef = nodeRef.getStoreRef();
        NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
        if (versionHistoryNodeRef != null) {
            List<ChildAssociationRef> versionsAssoc = this.dbNodeService.getChildAssocs(versionHistoryNodeRef, RegexQNamePattern.MATCH_ALL, VersionModel.CHILD_QNAME_VERSIONS);
            for (ChildAssociationRef versionAssoc : versionsAssoc) {
                String storeId;
                String storeProtocol;
                StoreRef versionStoreRef;
                NodeRef versionNodeRef = versionAssoc.getChildRef();
                List<AssociationRef> successors = this.dbNodeService.getTargetAssocs(versionNodeRef, VersionModel.ASSOC_SUCCESSOR);
                if (successors.size() != 0 || !storeRef.equals(versionStoreRef = new StoreRef(storeProtocol = (String)((Object)this.dbNodeService.getProperty(versionNodeRef, QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "frozenNodeStoreProtocol"))), storeId = (String)((Object)this.dbNodeService.getProperty(versionNodeRef, QName.createQName("http://www.alfresco.org/model/versionstore/1.0", "frozenNodeStoreId")))))) continue;
                version = this.getVersion(versionNodeRef);
            }
        }
        return version;
    }

    @Override
    public void deleteVersionHistory(NodeRef nodeRef) throws AspectMissingException {
        this.checkForVersionAspect(nodeRef);
        NodeRef versionHistoryNodeRef = this.getVersionHistoryNodeRef(nodeRef);
        this.dbNodeService.deleteNode(versionHistoryNodeRef);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_VERSION_LABEL, null);
    }
}

