/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.repo.version.BaseVersionStoreTest;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionServiceImplTest
extends BaseVersionStoreTest {
    private static final String UPDATED_VALUE_1 = "updatedValue1";
    private static final String UPDATED_VALUE_2 = "updatedValue2";
    private static final String UPDATED_VALUE_3 = "updatedValue3";
    private static final String UPDATED_CONTENT_1 = "updatedContent1";
    private static final String UPDATED_CONTENT_2 = "updatedContent2";

    public void testCreateIntialVersion() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
    }

    public void testCreateManyVersionsSameWorkspace() {
        NodeRef versionableNode = this.createNewVersionableNode();
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
        this.createVersion(versionableNode);
    }

    public void testVersioningChildren() {
        NodeRef versionableNode = this.createNewVersionableNode();
        int expectedVersionNumber = this.peekNextVersionNumber();
        String expectedVersionLabel = this.peekNextVersionLabel(versionableNode, expectedVersionNumber, this.versionProperties);
        long beforeVersionTime = System.currentTimeMillis();
        Collection<Version> versions = this.versionService.createVersion(versionableNode, this.versionProperties, true);
        this.CheckVersionCollection(expectedVersionNumber, expectedVersionLabel, beforeVersionTime, versions);
    }

    public void testVersioningManyNodes() {
        NodeRef versionableNode = this.createNewVersionableNode();
        int expectedVersionNumber = this.peekNextVersionNumber();
        String expectedVersionLabel = this.peekNextVersionLabel(versionableNode, expectedVersionNumber, this.versionProperties);
        long beforeVersionTime = System.currentTimeMillis();
        Collection<Version> versions = this.versionService.createVersion(this.versionableNodes.values(), (Map<String, Serializable>)this.versionProperties);
        this.CheckVersionCollection(expectedVersionNumber, expectedVersionLabel, beforeVersionTime, versions);
    }

    private void CheckVersionCollection(int expectedVersionNumber, String expectedVersionLabel, long beforeVersionTime, Collection<Version> versions) {
        for (Version version : versions) {
            String frozenNodeId = (String)((Object)version.getVersionProperty("frozenNodeId"));
            VersionServiceImplTest.assertNotNull((String)"Unable to retrieve the frozen node id from the created version.", (Object)frozenNodeId);
            NodeRef origionaNodeRef = (NodeRef)this.versionableNodes.get(frozenNodeId);
            VersionServiceImplTest.assertNotNull((String)"The versionable node ref that relates to the frozen node id can not be found.", (Object)origionaNodeRef);
            this.checkNewVersion(beforeVersionTime, expectedVersionNumber, expectedVersionLabel, version, origionaNodeRef);
        }
    }

    public void testNoVersionHistory() {
        NodeRef nodeRef = this.createNewVersionableNode();
        VersionHistory vh = this.versionService.getVersionHistory(nodeRef);
        VersionServiceImplTest.assertNull((Object)vh);
    }

    public void testGetVersionHistorySameWorkspace() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Version version1 = this.addToVersionHistory(versionableNode, null);
        Version version2 = this.addToVersionHistory(versionableNode, version1);
        Version version3 = this.addToVersionHistory(versionableNode, version2);
        Version version4 = this.addToVersionHistory(versionableNode, version3);
        this.addToVersionHistory(versionableNode, version4);
    }

    private Version addToVersionHistory(NodeRef versionableNode, Version parentVersion) {
        Version createdVersion = this.createVersion(versionableNode);
        VersionHistory vh = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((String)"The version history should not be null since we know we have versioned this node.", (Object)vh);
        if (parentVersion == null) {
            Version root = vh.getRootVersion();
            VersionServiceImplTest.assertNotNull((String)"The root version should never be null, since every version history ust have a root version.", (Object)root);
            VersionServiceImplTest.assertEquals((String)createdVersion.getVersionLabel(), (String)root.getVersionLabel());
        }
        Version version = vh.getVersion(createdVersion.getVersionLabel());
        VersionServiceImplTest.assertNotNull((Object)version);
        VersionServiceImplTest.assertEquals((String)createdVersion.getVersionLabel(), (String)version.getVersionLabel());
        Collection<Version> suc = vh.getSuccessors(version);
        VersionServiceImplTest.assertNotNull(suc);
        VersionServiceImplTest.assertEquals((int)0, (int)suc.size());
        Version pre = vh.getPredecessor(version);
        if (parentVersion == null) {
            VersionServiceImplTest.assertNull((Object)pre);
        } else {
            VersionServiceImplTest.assertNotNull((Object)pre);
            VersionServiceImplTest.assertEquals((String)parentVersion.getVersionLabel(), (String)pre.getVersionLabel());
        }
        if (parentVersion != null) {
            Collection<Version> parentSuc = vh.getSuccessors(parentVersion);
            VersionServiceImplTest.assertNotNull(parentSuc);
            VersionServiceImplTest.assertEquals((int)1, (int)parentSuc.size());
            Version tempVersion = (Version)parentSuc.toArray()[0];
            VersionServiceImplTest.assertEquals((String)version.getVersionLabel(), (String)tempVersion.getVersionLabel());
        }
        return createdVersion;
    }

    public void testRevert() {
        NodeRef versionableNode = this.createNewVersionableNode();
        Set<QName> origAspects = this.dbNodeService.getAspects(versionableNode);
        Version version1 = this.createVersion(versionableNode);
        this.dbNodeService.setProperty(versionableNode, PROP_1, (Serializable)((Object)UPDATED_VALUE_1));
        this.dbNodeService.setProperty(versionableNode, PROP_2, null);
        ContentWriter contentWriter = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter);
        contentWriter.putContent(UPDATED_CONTENT_1);
        this.dbNodeService.addAspect(versionableNode, ContentModel.ASPECT_SIMPLE_WORKFLOW, null);
        Set<QName> origAspects2 = this.dbNodeService.getAspects(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        this.dbNodeService.setProperty(versionableNode, PROP_1, (Serializable)((Object)UPDATED_VALUE_2));
        this.dbNodeService.setProperty(versionableNode, PROP_2, (Serializable)((Object)UPDATED_VALUE_3));
        this.dbNodeService.setProperty(versionableNode, PROP_3, null);
        ContentWriter contentWriter2 = this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
        VersionServiceImplTest.assertNotNull((Object)contentWriter2);
        contentWriter2.putContent(UPDATED_CONTENT_2);
        String versionLabel = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        this.versionService.revert(versionableNode);
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)UPDATED_VALUE_1, (Object)this.dbNodeService.getProperty(versionableNode, PROP_1));
        VersionServiceImplTest.assertNull((Object)this.dbNodeService.getProperty(versionableNode, PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(versionableNode, PROP_3));
        ContentReader contentReader1 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader1);
        VersionServiceImplTest.assertEquals((String)UPDATED_CONTENT_1, (String)contentReader1.getContentString());
        Set<QName> aspects1 = this.dbNodeService.getAspects(versionableNode);
        VersionServiceImplTest.assertEquals((int)aspects1.size(), (int)origAspects2.size());
        this.versionService.revert(versionableNode, version1);
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertEquals((Object)"value1", (Object)this.dbNodeService.getProperty(versionableNode, PROP_1));
        VersionServiceImplTest.assertEquals((Object)"value2", (Object)this.dbNodeService.getProperty(versionableNode, PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(versionableNode, PROP_3));
        ContentReader contentReader2 = this.contentService.getReader(versionableNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader2);
        VersionServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader2.getContentString());
        Set<QName> aspects2 = this.dbNodeService.getAspects(versionableNode);
        VersionServiceImplTest.assertEquals((int)aspects2.size(), (int)origAspects.size());
        VersionServiceImplTest.assertEquals((Object)versionLabel, (Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
    }

    public void testRestore() {
        try {
            this.versionService.restore(new NodeRef(this.testStoreRef, "123"), this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}MyVersionableNode"));
            VersionServiceImplTest.fail((String)"An exception should have been raised since this node has no version history.");
        }
        catch (VersionServiceException exception) {
            // empty catch block
        }
        NodeRef versionableNode = this.createNewVersionableNode();
        Set<QName> origAspects = this.dbNodeService.getAspects(versionableNode);
        try {
            this.versionService.restore(versionableNode, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}MyVersionableNode"));
            VersionServiceImplTest.fail((String)"An exception should have been raised since this node exists and you can't restore a node that exists.");
        }
        catch (VersionServiceException exception) {
            // empty catch block
        }
        this.versionService.createVersion(versionableNode, null);
        this.dbNodeService.deleteNode(versionableNode);
        VersionServiceImplTest.assertFalse((boolean)this.dbNodeService.exists(versionableNode));
        NodeRef restoredNode = this.versionService.restore(versionableNode, this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}MyVersionableNode"));
        VersionServiceImplTest.assertNotNull((Object)restoredNode);
        VersionServiceImplTest.assertTrue((boolean)this.dbNodeService.exists(restoredNode));
        VersionServiceImplTest.assertEquals((Object)"value1", (Object)this.dbNodeService.getProperty(restoredNode, PROP_1));
        VersionServiceImplTest.assertEquals((Object)"value2", (Object)this.dbNodeService.getProperty(restoredNode, PROP_2));
        VersionServiceImplTest.assertEquals((Object)"value3", (Object)this.dbNodeService.getProperty(restoredNode, PROP_3));
        ContentReader contentReader2 = this.contentService.getReader(restoredNode, ContentModel.PROP_CONTENT);
        VersionServiceImplTest.assertNotNull((Object)contentReader2);
        VersionServiceImplTest.assertEquals((String)"This is the versioned test content.", (String)contentReader2.getContentString());
        Set<QName> aspects2 = this.dbNodeService.getAspects(restoredNode);
        VersionServiceImplTest.assertEquals((int)aspects2.size(), (int)origAspects.size());
    }

    public void testDeleteVersionHistory() {
        NodeRef versionableNode = this.createNewVersionableNode();
        VersionHistory versionHistory1 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNull((Object)versionHistory1);
        this.createVersion(versionableNode);
        Version version1 = this.createVersion(versionableNode);
        String versionLabel1 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNotNull((Object)versionLabel1);
        VersionServiceImplTest.assertEquals((String)version1.getVersionLabel(), (String)versionLabel1);
        VersionHistory versionHistory2 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)versionHistory2);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory2.getAllVersions().size());
        this.versionService.deleteVersionHistory(versionableNode);
        VersionHistory versionHistory3 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNull((Object)versionHistory3);
        String versionLabel2 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNull((Object)versionLabel2);
        this.createVersion(versionableNode);
        Version version2 = this.createVersion(versionableNode);
        VersionHistory versionHistory4 = this.versionService.getVersionHistory(versionableNode);
        VersionServiceImplTest.assertNotNull((Object)versionHistory4);
        VersionServiceImplTest.assertEquals((int)2, (int)versionHistory4.getAllVersions().size());
        String versionLabel3 = (String)((Object)this.dbNodeService.getProperty(versionableNode, ContentModel.PROP_VERSION_LABEL));
        VersionServiceImplTest.assertNotNull((Object)versionLabel3);
        VersionServiceImplTest.assertEquals((String)version2.getVersionLabel(), (String)versionLabel3);
    }

    public void testAutoVersionOnInitialVersionOn() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.setComplete();
        this.endTransaction();
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                ContentWriter contentWriter = VersionServiceImplTest.this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
                Assert.assertNotNull((Object)contentWriter);
                contentWriter.putContent(VersionServiceImplTest.UPDATED_CONTENT_1);
                return null;
            }
        });
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)2, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    public void testAutoVersionOff() {
        final NodeRef versionableNode = this.createNewVersionableNode();
        this.dbNodeService.setProperty(versionableNode, ContentModel.PROP_AUTO_VERSION, Boolean.valueOf(false));
        this.setComplete();
        this.endTransaction();
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                ContentWriter contentWriter = VersionServiceImplTest.this.contentService.getWriter(versionableNode, ContentModel.PROP_CONTENT, true);
                Assert.assertNotNull((Object)contentWriter);
                contentWriter.putContent(VersionServiceImplTest.UPDATED_CONTENT_1);
                return null;
            }
        });
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(versionableNode);
                Assert.assertNotNull((Object)versionHistory);
                Assert.assertEquals((int)1, (int)versionHistory.getAllVersions().size());
                return null;
            }
        });
    }

    public void testInitialVersionOff() {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_INITIAL_VERSION, Boolean.valueOf(false));
        HashMap<QName, Serializable> props2 = new HashMap<QName, Serializable>();
        props2.put(ContentModel.PROP_NAME, (Serializable)((Object)"test.txt"));
        final NodeRef nodeRef = this.dbNodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{test}MyVersionableNode2"), TEST_TYPE_QNAME, props2).getChildRef();
        this.dbNodeService.addAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE, props);
        this.setComplete();
        this.endTransaction();
        TransactionUtil.executeInUserTransaction(this.transactionService, new TransactionUtil.TransactionWork<Object>(){

            @Override
            public Object doWork() throws Exception {
                VersionHistory versionHistory = VersionServiceImplTest.this.versionService.getVersionHistory(nodeRef);
                Assert.assertNull((Object)versionHistory);
                return null;
            }
        });
    }
}

