/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.rule.RuntimeRuleService;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.rule.Rule;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionableAspect
implements ContentServicePolicies.OnContentUpdatePolicy {
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private RuleService ruleService;
    private ActionService actionService;
    private Rule rule;
    private Behaviour autoVersionBehaviour;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onAddAspect"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.autoVersionBehaviour = new JavaBehaviour(this, "onContentUpdate");
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.ON_CONTENT_UPDATE, ContentModel.ASPECT_VERSIONABLE, this.autoVersionBehaviour);
        this.policyComponent.bindClassBehaviour(QName.createQName("http://www.alfresco.org", "onCopyNode"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onCopy"));
    }

    public void onCopy(QName sourceClassRef, NodeRef sourceNodeRef, StoreRef destinationStoreRef, boolean copyToNewNode, PolicyScope copyDetails) {
        copyDetails.addAspect(ContentModel.ASPECT_VERSIONABLE);
        copyDetails.addProperty(ContentModel.ASPECT_VERSIONABLE, ContentModel.PROP_AUTO_VERSION, this.nodeService.getProperty(sourceNodeRef, ContentModel.PROP_AUTO_VERSION));
    }

    public void onCreateVersion(QName classRef, NodeRef versionableNode, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
    }

    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (aspectTypeQName.equals(ContentModel.ASPECT_VERSIONABLE)) {
            boolean initialVersion = true;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_INITIAL_VERSION);
            if (value != null) {
                initialVersion = value;
            }
            if (initialVersion) {
                this.queueCreateVersionAction(nodeRef);
            }
        }
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        if (this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE)) {
            boolean autoVersion = false;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTO_VERSION);
            if (value != null) {
                autoVersion = value;
            }
            if (autoVersion) {
                this.queueCreateVersionAction(nodeRef);
            }
        }
    }

    public void enableAutoVersion() {
        this.autoVersionBehaviour.enable();
    }

    public void disableAutoVersion() {
        this.autoVersionBehaviour.disable();
    }

    private void queueCreateVersionAction(NodeRef nodeRef) {
        if (this.rule == null) {
            this.rule = this.ruleService.createRule("inbound");
            Action action = this.actionService.createAction("create-version");
            this.rule.addAction(action);
        }
        ((RuntimeRuleService)((Object)this.ruleService)).addRulePendingExecution(nodeRef, nodeRef, this.rule, true);
    }
}

