/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.policy.ClassPolicyDelegate;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.policy.PolicyScope;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVersionServiceImpl {
    protected NodeService nodeService;
    protected PolicyComponent policyComponent;
    protected DictionaryService dictionaryService;
    private ClassPolicyDelegate<VersionServicePolicies.BeforeCreateVersionPolicy> beforeCreateVersionDelegate;
    private ClassPolicyDelegate<VersionServicePolicies.OnCreateVersionPolicy> onCreateVersionDelegate;
    private ClassPolicyDelegate<VersionServicePolicies.CalculateVersionLabelPolicy> calculateVersionLabelDelegate;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void initialise() {
        this.beforeCreateVersionDelegate = this.policyComponent.registerClassPolicy(VersionServicePolicies.BeforeCreateVersionPolicy.class);
        this.onCreateVersionDelegate = this.policyComponent.registerClassPolicy(VersionServicePolicies.OnCreateVersionPolicy.class);
        this.calculateVersionLabelDelegate = this.policyComponent.registerClassPolicy(VersionServicePolicies.CalculateVersionLabelPolicy.class);
    }

    protected void invokeBeforeCreateVersion(NodeRef nodeRef) {
        QName nodeTypeQName = this.nodeService.getType(nodeRef);
        this.beforeCreateVersionDelegate.get(nodeTypeQName).beforeCreateVersion(nodeRef);
        Set<QName> nodeAspectQNames = this.nodeService.getAspects(nodeRef);
        this.beforeCreateVersionDelegate.get(nodeAspectQNames).beforeCreateVersion(nodeRef);
    }

    protected void invokeOnCreateVersion(NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        QName classRef = this.nodeService.getType(nodeRef);
        this.invokeOnCreateVersion(classRef, nodeRef, versionProperties, nodeDetails);
        Set<QName> aspects = this.nodeService.getAspects(nodeRef);
        for (QName aspect : aspects) {
            this.invokeOnCreateVersion(aspect, nodeRef, versionProperties, nodeDetails);
        }
    }

    private void invokeOnCreateVersion(QName classRef, NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        Collection<VersionServicePolicies.OnCreateVersionPolicy> policies = this.onCreateVersionDelegate.getList(classRef);
        if (policies.size() == 0) {
            this.defaultOnCreateVersion(classRef, nodeRef, versionProperties, nodeDetails);
        } else {
            for (VersionServicePolicies.OnCreateVersionPolicy policy : policies) {
                policy.onCreateVersion(classRef, nodeRef, versionProperties, nodeDetails);
            }
        }
    }

    protected void defaultOnCreateVersion(QName classRef, NodeRef nodeRef, Map<String, Serializable> versionProperties, PolicyScope nodeDetails) {
        ClassDefinition classDefinition = this.dictionaryService.getClass(classRef);
        if (classDefinition != null) {
            Map<QName, PropertyDefinition> propertyDefinitions = classDefinition.getProperties();
            for (QName propertyName : propertyDefinitions.keySet()) {
                Serializable propValue = this.nodeService.getProperty(nodeRef, propertyName);
                nodeDetails.addProperty(classRef, propertyName, propValue);
            }
            Map<QName, AssociationDefinition> assocDefs = classDefinition.getAssociations();
            if (classDefinition.isContainer()) {
                List<ChildAssociationRef> childAssocRefs = this.nodeService.getChildAssocs(nodeRef);
                for (ChildAssociationRef childAssocRef : childAssocRefs) {
                    if (!assocDefs.containsKey(childAssocRef.getTypeQName())) continue;
                    nodeDetails.addChildAssociation(classDefinition.getName(), childAssocRef);
                }
            }
            List<AssociationRef> nodeAssocRefs = this.nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef nodeAssocRef : nodeAssocRefs) {
                if (!assocDefs.containsKey(nodeAssocRef.getTypeQName())) continue;
                nodeDetails.addAssociation(classDefinition.getName(), nodeAssocRef);
            }
        }
    }

    protected String invokeCalculateVersionLabel(QName classRef, Version preceedingVersion, int versionNumber, Map<String, Serializable> versionProperties) {
        String versionLabel = null;
        Collection<VersionServicePolicies.CalculateVersionLabelPolicy> behaviours = this.calculateVersionLabelDelegate.getList(classRef);
        if (behaviours.size() == 0) {
            versionLabel = Integer.toString(versionNumber);
        } else if (behaviours.size() == 1) {
            VersionServicePolicies.CalculateVersionLabelPolicy[] arr = behaviours.toArray(new VersionServicePolicies.CalculateVersionLabelPolicy[0]);
            versionLabel = arr[0].calculateVersionLabel(classRef, preceedingVersion, versionNumber, versionProperties);
        } else {
            throw new VersionServiceException("More than one CalculateVersionLabelPolicy behaviour has been registered for the type " + classRef.toString());
        }
        return versionLabel;
    }
}

