/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionDoesNotExistException;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHistoryImpl
implements VersionHistory {
    private static final long serialVersionUID = 3257001051558326840L;
    private static final String ERR_MSG = "The root version must be specified when creating a version history object.";
    private String rootVersionLabel = null;
    private HashMap<String, String> versionHistory = null;
    private HashMap<String, Version> versions = null;
    private Version rootVersion;

    public VersionHistoryImpl(Version rootVersion) {
        if (rootVersion == null) {
            throw new VersionServiceException(ERR_MSG);
        }
        this.versionHistory = new HashMap();
        this.versions = new HashMap();
        this.rootVersion = rootVersion;
        this.rootVersionLabel = rootVersion.getVersionLabel();
        this.addVersion(rootVersion, null);
    }

    @Override
    public Version getRootVersion() {
        return this.rootVersion;
    }

    @Override
    public Collection<Version> getAllVersions() {
        return this.versions.values();
    }

    @Override
    public Version getPredecessor(Version version) {
        Version result = null;
        if (version != null) {
            result = this.getVersion(this.versionHistory.get(version.getVersionLabel()));
        }
        return result;
    }

    @Override
    public Collection<Version> getSuccessors(Version version) {
        String versionLabel;
        ArrayList<Version> result = new ArrayList<Version>();
        if (version != null && this.versionHistory.containsValue(versionLabel = version.getVersionLabel())) {
            for (String key : this.versionHistory.keySet()) {
                if (this.versionHistory.get(key) != versionLabel) continue;
                result.add(this.getVersion(key));
            }
        }
        return result;
    }

    @Override
    public Version getVersion(String versionLabel) {
        Version result = null;
        if (versionLabel != null && (result = this.versions.get(versionLabel)) == null) {
            throw new VersionDoesNotExistException(versionLabel);
        }
        return result;
    }

    public void addVersion(Version version, Version predecessor) {
        this.versions.put(version.getVersionLabel(), version);
        if (predecessor != null) {
            this.versionHistory.put(version.getVersionLabel(), predecessor.getVersionLabel());
        }
    }
}

