/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionServiceException;
import org.alfresco.service.cmr.version.VersionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionImpl
implements Version {
    private static final long serialVersionUID = 3257567304324888881L;
    private static final String ERR_NO_NODE_REF = "A valid node reference must be supplied when creating a verison.";
    private Map<String, Serializable> versionProperties = null;
    private NodeRef nodeRef = null;

    public VersionImpl(Map<String, Serializable> versionProperties, NodeRef nodeRef) {
        if (nodeRef == null) {
            throw new VersionServiceException(ERR_NO_NODE_REF);
        }
        this.versionProperties = versionProperties;
        this.nodeRef = nodeRef;
    }

    @Override
    public Date getCreatedDate() {
        return (Date)this.versionProperties.get(VersionModel.PROP_CREATED_DATE);
    }

    @Override
    public String getCreator() {
        return (String)((Object)this.versionProperties.get(VersionModel.PROP_CREATOR));
    }

    @Override
    public String getVersionLabel() {
        return (String)((Object)this.versionProperties.get("versionLabel"));
    }

    @Override
    public VersionType getVersionType() {
        return (VersionType)((Object)this.versionProperties.get("versionType"));
    }

    @Override
    public String getDescription() {
        return (String)((Object)this.versionProperties.get("description"));
    }

    @Override
    public Map<String, Serializable> getVersionProperties() {
        return this.versionProperties;
    }

    @Override
    public Serializable getVersionProperty(String name) {
        Serializable result = null;
        if (this.versionProperties != null) {
            result = this.versionProperties.get(name);
        }
        return result;
    }

    @Override
    public NodeRef getVersionedNodeRef() {
        String storeProtocol = (String)((Object)this.versionProperties.get("frozenNodeStoreProtocol"));
        String storeId = (String)((Object)this.versionProperties.get("frozenNodeStoreId"));
        String nodeId = (String)((Object)this.versionProperties.get("frozenNodeId"));
        return new NodeRef(new StoreRef(storeProtocol, storeId), nodeId);
    }

    @Override
    public NodeRef getFrozenStateNodeRef() {
        return this.nodeRef;
    }

    static {
        DefaultTypeConverter.INSTANCE.addConverter(String.class, VersionType.class, new TypeConverter.Converter<String, VersionType>(){

            @Override
            public VersionType convert(String source) {
                return VersionType.valueOf(source);
            }
        });
        DefaultTypeConverter.INSTANCE.addConverter(VersionType.class, String.class, new TypeConverter.Converter<VersionType, String>(){

            @Override
            public String convert(VersionType source) {
                return source.toString();
            }
        });
    }
}

