/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common.counter;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.repo.version.common.counter.VersionCounterService;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class VersionCounterServiceTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private StoreRef storeRef1;
    private StoreRef storeRef2;
    private TransactionService transactionService;
    private NodeService nodeService;
    private VersionCounterService counter;
    private int threadCount = 5;
    private CountDownLatch startSignal = new CountDownLatch(this.threadCount);
    private CountDownLatch endSignal = new CountDownLatch(this.threadCount);

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.counter = (VersionCounterService)ctx.getBean("versionCounterService");
        this.storeRef1 = this.nodeService.createStore("workspace", "test1_" + System.currentTimeMillis());
        this.storeRef2 = this.nodeService.createStore("workspace", "test2_" + System.currentTimeMillis());
    }

    public void testSetUp() throws Exception {
        VersionCounterServiceTest.assertNotNull((Object)this.transactionService);
        VersionCounterServiceTest.assertNotNull((Object)this.counter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNextVersionNumber() throws Exception {
        UserTransaction txn = this.transactionService.getUserTransaction();
        try {
            txn.begin();
            int store1Version0 = this.counter.nextVersionNumber(this.storeRef1);
            VersionCounterServiceTest.assertEquals((int)1, (int)store1Version0);
            int store1Version1 = this.counter.nextVersionNumber(this.storeRef1);
            VersionCounterServiceTest.assertEquals((int)2, (int)store1Version1);
            int store2Version0 = this.counter.nextVersionNumber(this.storeRef2);
            VersionCounterServiceTest.assertEquals((int)1, (int)store2Version0);
            int store1Version2 = this.counter.nextVersionNumber(this.storeRef1);
            VersionCounterServiceTest.assertEquals((int)3, (int)store1Version2);
            int store2Version1 = this.counter.nextVersionNumber(this.storeRef2);
            VersionCounterServiceTest.assertEquals((int)2, (int)store2Version1);
            int store1Current = this.counter.currentVersionNumber(this.storeRef1);
            VersionCounterServiceTest.assertEquals((int)3, (int)store1Current);
            int store2Current = this.counter.currentVersionNumber(this.storeRef2);
            VersionCounterServiceTest.assertEquals((int)2, (int)store2Current);
            this.counter.resetVersionNumber(this.storeRef1);
            this.counter.resetVersionNumber(this.storeRef2);
        }
        finally {
            try {
                txn.rollback();
            }
            catch (Throwable throwable) {}
        }
    }

    public void testConcurrentVersionNumber() throws Throwable {
        VersionCounterThread[] threads = new VersionCounterThread[this.threadCount];
        for (int i = 0; i < this.threadCount; ++i) {
            threads[i] = new VersionCounterThread("VersionCounterThread_" + i);
            threads[i].start();
        }
        this.endSignal.await(10L, TimeUnit.SECONDS);
        for (VersionCounterThread thread : threads) {
            if (thread.error == null) continue;
            throw thread.error;
        }
    }

    private class VersionCounterThread
    extends Thread {
        private Throwable error;

        public VersionCounterThread(String name) {
            super(name);
            this.error = new RuntimeException("Execution didn't complete");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TransactionUtil.TransactionWork<Object> versionWork = new TransactionUtil.TransactionWork<Object>(){

                @Override
                public Object doWork() throws Exception {
                    VersionCounterServiceTest.this.startSignal.countDown();
                    int startVersion = VersionCounterServiceTest.this.counter.currentVersionNumber(VersionCounterServiceTest.this.storeRef1);
                    int incrementedVersion = VersionCounterServiceTest.this.counter.nextVersionNumber(VersionCounterServiceTest.this.storeRef1);
                    Assert.assertTrue((String)"Version number was not incremented", (incrementedVersion > startVersion ? 1 : 0) != 0);
                    return null;
                }
            };
            try {
                TransactionUtil.executeInNonPropagatingUserTransaction(VersionCounterServiceTest.this.transactionService, versionWork, false);
                this.error = null;
            }
            catch (Throwable e) {
                this.error = e;
                e.printStackTrace();
            }
            finally {
                VersionCounterServiceTest.this.endSignal.countDown();
            }
        }
    }
}

