/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version.common.versionlabel;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialVersionLabelPolicy {
    public String calculateVersionLabel(QName classRef, Version preceedingVersion, int versionNumber, Map<String, Serializable> versionProperties) {
        SerialVersionLabel serialVersionNumber = null;
        if (preceedingVersion != null) {
            serialVersionNumber = new SerialVersionLabel(preceedingVersion.getVersionLabel());
            VersionType versionType = (VersionType)((Object)versionProperties.get("versionType"));
            if (VersionType.MAJOR.equals((Object)versionType)) {
                serialVersionNumber.majorIncrement();
            } else {
                serialVersionNumber.minorIncrement();
            }
        } else {
            serialVersionNumber = new SerialVersionLabel(null);
        }
        return serialVersionNumber.toString();
    }

    private class SerialVersionLabel {
        private static final String DELIMITER = ".";
        private int majorRevisionNumber = 1;
        private int minorRevisionNumber = 0;

        public SerialVersionLabel(String versionLabel) {
            if (versionLabel != null && versionLabel.length() != 0) {
                int iIndex = versionLabel.indexOf(DELIMITER);
                String majorString = versionLabel.substring(0, iIndex);
                String minorString = versionLabel.substring(iIndex + 1);
                this.majorRevisionNumber = Integer.parseInt(majorString);
                this.minorRevisionNumber = Integer.parseInt(minorString);
            }
        }

        public void majorIncrement() {
            ++this.majorRevisionNumber;
            this.minorRevisionNumber = 0;
        }

        public void minorIncrement() {
            ++this.minorRevisionNumber;
        }

        public String toString() {
            return this.majorRevisionNumber + DELIMITER + this.minorRevisionNumber;
        }
    }
}

