/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;

public class AssociationRef
implements EntityRef,
Serializable {
    private static final long serialVersionUID = 3977867284482439475L;
    private static final String FILLER = "|";
    private NodeRef sourceRef;
    private QName assocTypeQName;
    private NodeRef targetRef;

    public AssociationRef(NodeRef sourceRef, QName assocTypeQName, NodeRef targetRef) {
        this.sourceRef = sourceRef;
        this.assocTypeQName = assocTypeQName;
        this.targetRef = targetRef;
        if (sourceRef == null) {
            throw new IllegalArgumentException("Source reference may not be null");
        }
        if (assocTypeQName == null) {
            throw new IllegalArgumentException("QName may not be null");
        }
        if (targetRef == null) {
            throw new IllegalArgumentException("Target reference may not be null");
        }
    }

    public AssociationRef(String assocRefStr) {
        StringTokenizer tokenizer = new StringTokenizer(assocRefStr, FILLER);
        if (tokenizer.countTokens() != 3) {
            throw new AlfrescoRuntimeException("Unable to parse association string: " + assocRefStr);
        }
        String sourceNodeRefStr = tokenizer.nextToken();
        String targetNodeRefStr = tokenizer.nextToken();
        String assocTypeQNameStr = tokenizer.nextToken();
        this.sourceRef = new NodeRef(sourceNodeRefStr);
        this.targetRef = new NodeRef(targetNodeRefStr);
        this.assocTypeQName = QName.createQName(assocTypeQNameStr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(180);
        sb.append(this.sourceRef).append(FILLER).append(this.targetRef).append(FILLER).append(this.assocTypeQName);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssociationRef)) {
            return false;
        }
        AssociationRef other = (AssociationRef)o;
        return EqualsHelper.nullSafeEquals((Object)this.sourceRef, (Object)other.sourceRef) && EqualsHelper.nullSafeEquals((Object)this.assocTypeQName, (Object)other.assocTypeQName) && EqualsHelper.nullSafeEquals((Object)this.targetRef, (Object)other.targetRef);
    }

    public int hashCode() {
        int hashCode = this.getSourceRef() == null ? 0 : this.getSourceRef().hashCode();
        hashCode = 37 * hashCode + (this.getTypeQName() == null ? 0 : this.getTypeQName().hashCode());
        hashCode = 37 * hashCode + this.getTargetRef().hashCode();
        return hashCode;
    }

    public QName getTypeQName() {
        return this.assocTypeQName;
    }

    public NodeRef getTargetRef() {
        return this.targetRef;
    }

    public NodeRef getSourceRef() {
        return this.sourceRef;
    }
}

