/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.EqualsHelper;

public class ContentData
implements Serializable {
    private static final long serialVersionUID = 8979634213050121462L;
    private static char[] INVALID_CONTENT_URL_CHARS = new char[]{'|'};
    private final String contentUrl;
    private final String mimetype;
    private final long size;
    private final String encoding;

    public static ContentData createContentProperty(String contentPropertyStr) {
        String encoding;
        String sizeStr;
        String mimetype;
        int contentUrlIndex = contentPropertyStr.indexOf("contentUrl=");
        if (contentUrlIndex == -1) {
            throw new AlfrescoRuntimeException("ContentData string does not have a content URL: " + contentPropertyStr);
        }
        int mimetypeIndex = contentPropertyStr.indexOf("|mimetype=", contentUrlIndex + 11);
        if (mimetypeIndex == -1) {
            throw new AlfrescoRuntimeException("ContentData string does not have a mimetype: " + contentPropertyStr);
        }
        int sizeIndex = contentPropertyStr.indexOf("|size=", mimetypeIndex + 10);
        if (sizeIndex == -1) {
            throw new AlfrescoRuntimeException("ContentData string does not have a size: " + contentPropertyStr);
        }
        int encodingIndex = contentPropertyStr.indexOf("|encoding=", sizeIndex + 6);
        if (encodingIndex == -1) {
            throw new AlfrescoRuntimeException("ContentData string does not have an encoding: " + contentPropertyStr);
        }
        String contentUrl = contentPropertyStr.substring(contentUrlIndex + 11, mimetypeIndex);
        if (contentUrl.length() == 0) {
            contentUrl = null;
        }
        if ((mimetype = contentPropertyStr.substring(mimetypeIndex + 10, sizeIndex)).length() == 0) {
            mimetype = null;
        }
        if ((sizeStr = contentPropertyStr.substring(sizeIndex + 6, encodingIndex)).length() == 0) {
            sizeStr = "0";
        }
        if ((encoding = contentPropertyStr.substring(encodingIndex + 10)).length() == 0) {
            encoding = null;
        }
        long size = Long.valueOf(sizeStr);
        ContentData property = new ContentData(contentUrl, mimetype, size, encoding);
        return property;
    }

    public static ContentData setMimetype(ContentData existing, String mimetype) {
        ContentData ret = new ContentData(existing == null ? null : existing.contentUrl, mimetype, existing == null ? 0L : existing.size, existing == null ? "UTF-8" : existing.encoding);
        return ret;
    }

    public ContentData(String contentUrl, String mimetype, long size, String encoding) {
        this.checkContentUrl(contentUrl, mimetype);
        this.contentUrl = contentUrl;
        this.mimetype = mimetype;
        this.size = size;
        this.encoding = encoding;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentData)) {
            return false;
        }
        ContentData that = (ContentData)obj;
        return EqualsHelper.nullSafeEquals((Object)this.contentUrl, (Object)that.contentUrl) && EqualsHelper.nullSafeEquals((Object)this.mimetype, (Object)that.mimetype) && this.size == that.size && EqualsHelper.nullSafeEquals((Object)this.encoding, (Object)that.encoding);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("contentUrl=").append(this.contentUrl == null ? "" : this.contentUrl).append("|mimetype=").append(this.mimetype == null ? "" : this.mimetype).append("|size=").append(this.size).append("|encoding=").append(this.encoding == null ? "" : this.encoding);
        return sb.toString();
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    private void checkContentUrl(String contentUrl, String mimetype) {
        if (contentUrl != null && contentUrl.length() > 0) {
            for (int i = 0; i < INVALID_CONTENT_URL_CHARS.length; ++i) {
                for (int j = contentUrl.length() - 1; j > -1; --j) {
                    if (contentUrl.charAt(j) != INVALID_CONTENT_URL_CHARS[i]) continue;
                    throw new IllegalArgumentException("The content URL contains an invalid char: \n   content URL: " + contentUrl + "\n" + "   char: " + INVALID_CONTENT_URL_CHARS[i] + "\n" + "   position: " + j);
                }
            }
            if (mimetype == null) {
                throw new IllegalArgumentException("The content mimetype must be set whenever the URL is set: \n   content URL: " + contentUrl + "\n" + "   mimetype: " + mimetype);
            }
        }
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public long getSize() {
        return this.size;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

