/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.EntityRef;
import org.alfresco.service.cmr.repository.StoreRef;

public final class NodeRef
implements EntityRef,
Serializable {
    private static final long serialVersionUID = 3760844584074227768L;
    private static final String URI_FILLER = "/";
    private static final Pattern nodeRefPattern = Pattern.compile(".+://.+/.+");
    private final StoreRef storeRef;
    private final String id;

    public NodeRef(StoreRef storeRef, String id) {
        if (storeRef == null) {
            throw new IllegalArgumentException("Store reference may not be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Node id may not be null");
        }
        this.storeRef = storeRef;
        this.id = id;
    }

    public NodeRef(String nodeRef) {
        int lastForwardSlash = nodeRef.lastIndexOf(47);
        if (lastForwardSlash == -1) {
            throw new AlfrescoRuntimeException("Invalid node ref - does not contain forward slash: " + nodeRef);
        }
        this.storeRef = new StoreRef(nodeRef.substring(0, lastForwardSlash));
        this.id = nodeRef.substring(lastForwardSlash + 1);
    }

    public String toString() {
        return this.storeRef.toString() + URI_FILLER + this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof NodeRef) {
            NodeRef that = (NodeRef)obj;
            return this.id.equals(that.id) && this.storeRef.equals(that.storeRef);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public final StoreRef getStoreRef() {
        return this.storeRef;
    }

    public final String getId() {
        return this.id;
    }

    public static boolean isNodeRef(String nodeRef) {
        Matcher matcher = nodeRefPattern.matcher(nodeRef);
        return matcher.matches();
    }

    public static class Status {
        private final String changeTxnId;
        private final boolean deleted;

        public Status(String changeTxnId, boolean deleted) {
            this.changeTxnId = changeTxnId;
            this.deleted = deleted;
        }

        public String getChangeTxnId() {
            return this.changeTxnId;
        }

        public boolean isDeleted() {
            return this.deleted;
        }
    }
}

