/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreExistsException;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface NodeService {
    public List<StoreRef> getStores();

    public StoreRef createStore(String var1, String var2) throws StoreExistsException;

    public boolean exists(StoreRef var1);

    public boolean exists(NodeRef var1);

    public NodeRef.Status getNodeStatus(NodeRef var1);

    public NodeRef getRootNode(StoreRef var1) throws InvalidStoreRefException;

    public ChildAssociationRef createNode(NodeRef var1, QName var2, QName var3, QName var4) throws InvalidNodeRefException, InvalidTypeException;

    public ChildAssociationRef createNode(NodeRef var1, QName var2, QName var3, QName var4, Map<QName, Serializable> var5) throws InvalidNodeRefException, InvalidTypeException;

    public ChildAssociationRef moveNode(NodeRef var1, NodeRef var2, QName var3, QName var4) throws InvalidNodeRefException;

    public void setChildAssociationIndex(ChildAssociationRef var1, int var2) throws InvalidChildAssociationRefException;

    public QName getType(NodeRef var1) throws InvalidNodeRefException;

    public void setType(NodeRef var1, QName var2) throws InvalidNodeRefException;

    public void addAspect(NodeRef var1, QName var2, Map<QName, Serializable> var3) throws InvalidNodeRefException, InvalidAspectException;

    public void removeAspect(NodeRef var1, QName var2) throws InvalidNodeRefException, InvalidAspectException;

    public boolean hasAspect(NodeRef var1, QName var2) throws InvalidNodeRefException, InvalidAspectException;

    public Set<QName> getAspects(NodeRef var1) throws InvalidNodeRefException;

    public void deleteNode(NodeRef var1) throws InvalidNodeRefException;

    public ChildAssociationRef addChild(NodeRef var1, NodeRef var2, QName var3, QName var4) throws InvalidNodeRefException;

    public void removeChild(NodeRef var1, NodeRef var2) throws InvalidNodeRefException;

    public Map<QName, Serializable> getProperties(NodeRef var1) throws InvalidNodeRefException;

    public Serializable getProperty(NodeRef var1, QName var2) throws InvalidNodeRefException;

    public void setProperties(NodeRef var1, Map<QName, Serializable> var2) throws InvalidNodeRefException;

    public void setProperty(NodeRef var1, QName var2, Serializable var3) throws InvalidNodeRefException;

    public List<ChildAssociationRef> getParentAssocs(NodeRef var1) throws InvalidNodeRefException;

    public List<ChildAssociationRef> getParentAssocs(NodeRef var1, QNamePattern var2, QNamePattern var3) throws InvalidNodeRefException;

    public List<ChildAssociationRef> getChildAssocs(NodeRef var1) throws InvalidNodeRefException;

    public List<ChildAssociationRef> getChildAssocs(NodeRef var1, QNamePattern var2, QNamePattern var3) throws InvalidNodeRefException;

    public ChildAssociationRef getPrimaryParent(NodeRef var1) throws InvalidNodeRefException;

    public AssociationRef createAssociation(NodeRef var1, NodeRef var2, QName var3) throws InvalidNodeRefException, AssociationExistsException;

    public void removeAssociation(NodeRef var1, NodeRef var2, QName var3) throws InvalidNodeRefException;

    public List<AssociationRef> getTargetAssocs(NodeRef var1, QNamePattern var2) throws InvalidNodeRefException;

    public List<AssociationRef> getSourceAssocs(NodeRef var1, QNamePattern var2) throws InvalidNodeRefException;

    public Path getPath(NodeRef var1) throws InvalidNodeRefException;

    public List<Path> getPaths(NodeRef var1, boolean var2) throws InvalidNodeRefException;

    public NodeRef getStoreArchiveNode(StoreRef var1);

    public NodeRef restoreNode(NodeRef var1, NodeRef var2, QName var3, QName var4);
}

