/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path
implements Iterable<Element>,
Serializable {
    private static final long serialVersionUID = 3905520514524328247L;
    private LinkedList<Element> elements = new LinkedList();

    @Override
    public Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    public Path prepend(Element pathElement) {
        this.elements.addFirst(pathElement);
        return this;
    }

    public Path prepend(Path path) {
        this.elements.addAll(0, path.elements);
        return this;
    }

    public Path append(Element pathElement) {
        this.elements.addLast(pathElement);
        return this;
    }

    public Path append(Path path) {
        this.elements.addAll(path.elements);
        return this;
    }

    public Element first() {
        return this.elements.getFirst();
    }

    public Element last() {
        return this.elements.getLast();
    }

    public int size() {
        return this.elements.size();
    }

    public Element get(int n) {
        return this.elements.get(n);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (Element element : this.elements) {
            if (sb.length() > 1 || sb.length() == 1 && sb.charAt(0) != '/') {
                sb.append("/");
            }
            sb.append(element.getElementString());
        }
        return sb.toString();
    }

    public String toPrefixString(NamespacePrefixResolver resolver) {
        StringBuilder sb = new StringBuilder(128);
        for (Element element : this.elements) {
            if (sb.length() > 1 || sb.length() == 1 && sb.charAt(0) != '/') {
                sb.append("/");
            }
            sb.append(element.getPrefixedString(resolver));
        }
        return sb.toString();
    }

    public String toDisplayPath(NodeService nodeService) {
        StringBuilder buf = new StringBuilder(64);
        for (int i = 0; i < this.elements.size() - 1; ++i) {
            String elementString = null;
            Element element = this.elements.get(i);
            if (element instanceof ChildAssocElement) {
                ChildAssociationRef elementRef = ((ChildAssocElement)element).getRef();
                if (elementRef.getParentRef() != null) {
                    Serializable nameProp = null;
                    try {
                        nameProp = nodeService.getProperty(elementRef.getChildRef(), ContentModel.PROP_NAME);
                    }
                    catch (AccessDeniedException err) {
                        // empty catch block
                    }
                    elementString = nameProp != null ? nameProp.toString() : elementRef.getQName().getLocalName();
                }
            } else {
                elementString = element.getElementString();
            }
            if (elementString == null) continue;
            buf.append("/");
            buf.append(elementString);
        }
        return buf.toString();
    }

    public Path subPath(int depth) {
        return this.subPath(0, depth);
    }

    public Path subPath(int start, int end) {
        if (start < 0 || start > this.elements.size() - 1) {
            throw new IndexOutOfBoundsException("Start index " + start + " must be between 0 and " + (this.elements.size() - 1));
        }
        if (end < 0 || end > this.elements.size() - 1) {
            throw new IndexOutOfBoundsException("End index " + end + " must be between 0 and " + (this.elements.size() - 1));
        }
        if (end < start) {
            throw new IndexOutOfBoundsException("End index " + end + " cannot be before start index " + start);
        }
        Path subPath = new Path();
        for (int i = start; i <= end; ++i) {
            subPath.append(this.get(i));
        }
        return subPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        return this.elements.equals(other.elements);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    public static class ParentElement
    extends Element {
        private static final long serialVersionUID = 3689915080477456179L;

        public String getElementString() {
            return "..";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof ParentElement;
        }

        public int hashCode() {
            return "..".hashCode();
        }
    }

    public static class SelfElement
    extends Element {
        private static final long serialVersionUID = 3834311739151300406L;

        public String getElementString() {
            return ".";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof SelfElement;
        }

        public int hashCode() {
            return ".".hashCode();
        }
    }

    public static class DescendentOrSelfElement
    extends Element {
        private static final long serialVersionUID = 3258410616875005237L;

        public String getElementString() {
            return "descendant-or-self::node()";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof DescendentOrSelfElement;
        }

        public int hashCode() {
            return "descendant-or-self::node()".hashCode();
        }
    }

    public static class AttributeElement
    extends Element {
        private static final long serialVersionUID = 3256727281668863544L;
        private QName attribute;
        private int position = -1;

        public AttributeElement(QName attribute) {
            this.attribute = attribute;
        }

        public AttributeElement(QName attribute, int position) {
            this(attribute);
            this.position = position;
        }

        public String getElementString() {
            return this.createElementString(null);
        }

        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return this.createElementString(resolver);
        }

        private String createElementString(NamespacePrefixResolver resolver) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("@").append(resolver == null ? ISO9075.getXPathName(this.attribute) : ISO9075.getXPathName(this.attribute, resolver));
            if (this.position > -1) {
                sb.append("[").append(this.position).append("]");
            }
            return sb.toString();
        }

        public QName getQName() {
            return this.attribute;
        }

        public int position() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AttributeElement)) {
                return false;
            }
            AttributeElement other = (AttributeElement)o;
            return this.getQName().equals(other.getQName()) && this.position() == other.position();
        }

        public int hashCode() {
            return this.getQName().hashCode() * 32 + this.position();
        }
    }

    public static class ChildAssocElement
    extends Element {
        private static final long serialVersionUID = 3689352104636790840L;
        private ChildAssociationRef ref;

        public ChildAssocElement(ChildAssociationRef ref) {
            this.ref = ref;
        }

        public String getElementString() {
            return this.createElementString(null);
        }

        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return this.createElementString(resolver);
        }

        public ChildAssociationRef getRef() {
            return this.ref;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChildAssocElement)) {
                return false;
            }
            ChildAssocElement other = (ChildAssocElement)o;
            return this.ref.equals(other.ref);
        }

        public int hashCode() {
            return this.ref.hashCode();
        }

        private String createElementString(NamespacePrefixResolver resolver) {
            StringBuilder sb = new StringBuilder(32);
            if (this.ref.getParentRef() == null) {
                sb.append("/");
            } else {
                sb.append(resolver == null ? ISO9075.getXPathName(this.ref.getQName()) : ISO9075.getXPathName(this.ref.getQName(), resolver));
            }
            if (this.ref.getNthSibling() > -1) {
                sb.append("[").append(this.ref.getNthSibling()).append("]");
            }
            return sb.toString();
        }
    }

    public static abstract class Element
    implements Serializable {
        public abstract String getElementString();

        public String getPrefixedString(NamespacePrefixResolver resolver) {
            return this.getElementString();
        }

        public String toString() {
            return this.getElementString();
        }
    }
}

