/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.io.Serializable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.EntityRef;

public final class StoreRef
implements EntityRef,
Serializable {
    private static final long serialVersionUID = 3905808565129394486L;
    public static final String PROTOCOL_WORKSPACE = "workspace";
    public static final String URI_FILLER = "://";
    private final String protocol;
    private final String identifier;

    public StoreRef(String protocol, String identifier) {
        if (protocol == null) {
            throw new IllegalArgumentException("Store protocol may not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Store identifier may not be null");
        }
        this.protocol = protocol;
        this.identifier = identifier;
    }

    public StoreRef(String string) {
        int dividerPatternPosition = string.indexOf(URI_FILLER);
        if (dividerPatternPosition == -1) {
            throw new AlfrescoRuntimeException("Invalid store ref: Does not contain ://   " + string);
        }
        this.protocol = string.substring(0, dividerPatternPosition);
        this.identifier = string.substring(dividerPatternPosition + 3);
    }

    public String toString() {
        return this.protocol + URI_FILLER + this.identifier;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StoreRef) {
            StoreRef that = (StoreRef)obj;
            return this.protocol.equals(that.protocol) && this.identifier.equals(that.identifier);
        }
        return false;
    }

    public int hashCode() {
        return this.protocol.hashCode() + this.identifier.hashCode();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

