/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import freemarker.ext.dom.NodeModel;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.template.LuceneSearchResultsMap;
import org.alfresco.repo.template.NamePathResultsMap;
import org.alfresco.repo.template.SavedSearchResultsMap;
import org.alfresco.repo.template.XPathResultsMap;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateException;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNameMap;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TemplateNode
implements Serializable {
    private static final long serialVersionUID = 1234390333739034171L;
    private static Log logger = LogFactory.getLog(TemplateNode.class);
    private static final String NAMESPACE_BEGIN = "{";
    private static final String CONTENT_DEFAULT_URL = "/download/direct/{0}/{1}/{2}/{3}";
    private static final String CONTENT_PROP_URL = "/download/direct/{0}/{1}/{2}/{3}?property={4}";
    private static final String FOLDER_BROWSE_URL = "/navigate/browse/{0}/{1}/{2}";
    private List<TemplateNode> children = null;
    private Map<String, List<TemplateNode>> assocs = null;
    private NodeRef nodeRef;
    private String name;
    private QName type;
    private String path;
    private String id;
    private Set<QName> aspects = null;
    private QNameMap<String, Object> properties;
    private List<String> permissions = null;
    private boolean propsRetrieved = false;
    private ServiceRegistry services = null;
    private Boolean isDocument = null;
    private Boolean isContainer = null;
    private String displayPath = null;
    private String mimetype = null;
    private Long size = null;
    private TemplateImageResolver imageResolver = null;
    private TemplateNode parent = null;
    private ChildAssociationRef primaryParentAssoc = null;

    public TemplateNode(NodeRef nodeRef, ServiceRegistry services, TemplateImageResolver resolver) {
        if (nodeRef == null) {
            throw new IllegalArgumentException("NodeRef must be supplied.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.nodeRef = nodeRef;
        this.id = nodeRef.getId();
        this.services = services;
        this.imageResolver = resolver;
        this.properties = new QNameMap(this.services.getNamespaceService());
    }

    public String getId() {
        return this.id;
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public QName getType() {
        if (this.type == null) {
            this.type = this.services.getNodeService().getType(this.nodeRef);
        }
        return this.type;
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)this.getProperties().get("cm:name");
            if (this.name == null) {
                ChildAssociationRef parentRef = this.services.getNodeService().getPrimaryParent(this.nodeRef);
                this.name = parentRef != null && parentRef.getQName() != null ? parentRef.getQName().getLocalName() : "";
            }
        }
        return this.name;
    }

    public List<TemplateNode> getChildren() {
        if (this.children == null) {
            List<ChildAssociationRef> childRefs = this.services.getNodeService().getChildAssocs(this.nodeRef);
            this.children = new ArrayList<TemplateNode>(childRefs.size());
            for (ChildAssociationRef ref : childRefs) {
                TemplateNode child = new TemplateNode(ref.getChildRef(), this.services, this.imageResolver);
                this.children.add(child);
            }
        }
        return this.children;
    }

    public Map getChildByNamePath() {
        return new NamePathResultsMap(this, this.services);
    }

    public Map getChildrenByXPath() {
        return new XPathResultsMap(this, this.services);
    }

    public Map getChildrenBySavedSearch() {
        return new SavedSearchResultsMap(this, this.services);
    }

    public Map getChildrenByLuceneSearch() {
        return new LuceneSearchResultsMap(this, this.services);
    }

    public Map<String, List<TemplateNode>> getAssocs() {
        if (this.assocs == null) {
            List<AssociationRef> refs = this.services.getNodeService().getTargetAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL);
            this.assocs = new QNameMap(this.services.getNamespaceService());
            for (AssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                List<TemplateNode> nodes = this.assocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<TemplateNode>(4);
                    this.assocs.put(ref.getTypeQName().toString(), nodes);
                }
                nodes.add(new TemplateNode(ref.getTargetRef(), this.services, this.imageResolver));
            }
        }
        return this.assocs;
    }

    public Map<String, Object> getProperties() {
        if (!this.propsRetrieved) {
            Map<QName, Serializable> props = this.services.getNodeService().getProperties(this.nodeRef);
            for (QName qname : props.keySet()) {
                Serializable propValue = props.get(qname);
                if (propValue instanceof NodeRef) {
                    propValue = new TemplateNode((NodeRef)propValue, this.services, this.imageResolver);
                } else if (propValue instanceof ContentData) {
                    propValue = new TemplateContentData((ContentData)propValue, qname);
                }
                this.properties.put((Object)qname.toString(), (Object)propValue);
            }
            this.propsRetrieved = true;
        }
        return this.properties;
    }

    public boolean getIsContainer() {
        if (this.isContainer == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isContainer = dd.isSubClass(this.getType(), ContentModel.TYPE_FOLDER) && !dd.isSubClass(this.getType(), ContentModel.TYPE_SYSTEM_FOLDER);
        }
        return this.isContainer;
    }

    public boolean getIsDocument() {
        if (this.isDocument == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isDocument = dd.isSubClass(this.getType(), ContentModel.TYPE_CONTENT);
        }
        return this.isDocument;
    }

    public Set<QName> getAspects() {
        if (this.aspects == null) {
            this.aspects = this.services.getNodeService().getAspects(this.nodeRef);
        }
        return this.aspects;
    }

    public boolean hasAspect(String aspect) {
        if (this.aspects == null) {
            this.aspects = this.services.getNodeService().getAspects(this.nodeRef);
        }
        if (aspect.startsWith(NAMESPACE_BEGIN)) {
            return this.aspects.contains(QName.createQName(aspect));
        }
        boolean found = false;
        for (QName qname : this.aspects) {
            if (!qname.toPrefixString(this.services.getNamespaceService()).equals(aspect)) continue;
            found = true;
            break;
        }
        return found;
    }

    public NodeModel getXmlNodeModel() {
        try {
            return NodeModel.parse((InputSource)new InputSource(new StringReader(this.getContent())));
        }
        catch (Throwable err) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)err.getMessage(), err);
            }
            return null;
        }
    }

    public String getDisplayPath() {
        if (this.displayPath == null) {
            try {
                this.displayPath = this.services.getNodeService().getPath(this.nodeRef).toDisplayPath(this.services.getNodeService());
            }
            catch (AccessDeniedException err) {
                this.displayPath = "";
            }
        }
        return this.displayPath;
    }

    public String getIcon16() {
        if (this.imageResolver != null) {
            if (this.getIsDocument()) {
                return this.imageResolver.resolveImagePathForName(this.getName(), true);
            }
            return "/images/icons/space_small.gif";
        }
        return "/images/filetypes/_default.gif";
    }

    public String getIcon32() {
        if (this.imageResolver != null) {
            if (this.getIsDocument()) {
                return this.imageResolver.resolveImagePathForName(this.getName(), false);
            }
            String icon = (String)this.getProperties().get("app:icon");
            if (icon != null) {
                return "/images/icons/" + icon + ".gif";
            }
            return "/images/icons/space-icon-default.gif";
        }
        return "/images/filetypes32/_default.gif";
    }

    public boolean getIsLocked() {
        LockStatus lockStatus;
        boolean locked = false;
        if (this.getAspects().contains(ContentModel.ASPECT_LOCKABLE) && ((lockStatus = this.services.getLockService().getLockStatus(this.nodeRef)) == LockStatus.LOCKED || lockStatus == LockStatus.LOCK_OWNER)) {
            locked = true;
        }
        return locked;
    }

    public List<String> getPermissions() {
        if (this.permissions == null) {
            String userName = this.services.getAuthenticationService().getCurrentUserName();
            this.permissions = new ArrayList<String>(4);
            Set<AccessPermission> acls = this.services.getPermissionService().getAllSetPermissions(this.nodeRef);
            for (AccessPermission permission : acls) {
                StringBuilder buf = new StringBuilder(64);
                buf.append((Object)permission.getAccessStatus()).append(';').append(permission.getAuthority()).append(';').append(permission.getPermission());
                this.permissions.add(buf.toString());
            }
        }
        return this.permissions;
    }

    public boolean getInheritsPermissions() {
        return this.services.getPermissionService().getInheritParentPermissions(this.nodeRef);
    }

    public TemplateNode getParent() {
        NodeRef parentRef;
        if (this.parent == null && (parentRef = this.services.getNodeService().getPrimaryParent(this.nodeRef).getParentRef()) != null) {
            this.parent = new TemplateNode(parentRef, this.services, this.imageResolver);
        }
        return this.parent;
    }

    public ChildAssociationRef getPrimaryParentAssoc() {
        if (this.primaryParentAssoc == null) {
            this.primaryParentAssoc = this.services.getNodeService().getPrimaryParent(this.nodeRef);
        }
        return this.primaryParentAssoc;
    }

    public String getContent() {
        ContentService contentService = this.services.getContentService();
        ContentReader reader = contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        return reader != null && reader.exists() ? reader.getContentString() : "";
    }

    public String getUrl() {
        if (this.getIsDocument()) {
            try {
                return MessageFormat.format(CONTENT_DEFAULT_URL, this.nodeRef.getStoreRef().getProtocol(), this.nodeRef.getStoreRef().getIdentifier(), this.nodeRef.getId(), StringUtils.replace((String)URLEncoder.encode(this.getName(), "UTF-8"), (String)"+", (String)"%20"));
            }
            catch (UnsupportedEncodingException err) {
                throw new TemplateException("Failed to encode content URL for node: " + this.nodeRef, err);
            }
        }
        return MessageFormat.format(FOLDER_BROWSE_URL, this.nodeRef.getStoreRef().getProtocol(), this.nodeRef.getStoreRef().getIdentifier(), this.nodeRef.getId());
    }

    public String getMimetype() {
        TemplateContentData content;
        if (this.mimetype == null && (content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT)) != null) {
            this.mimetype = content.getMimetype();
        }
        return this.mimetype;
    }

    public long getSize() {
        TemplateContentData content;
        if (this.size == null && (content = (TemplateContentData)this.getProperties().get(ContentModel.PROP_CONTENT)) != null) {
            this.size = content.getSize();
        }
        return this.size != null ? this.size : 0L;
    }

    public TemplateImageResolver getImageResolver() {
        return this.imageResolver;
    }

    public String toString() {
        if (this.services.getNodeService().exists(this.nodeRef)) {
            return "Node Type: " + this.getType() + "\nNode Properties: " + this.getProperties().toString() + "\nNode Aspects: " + this.getAspects().toString();
        }
        return "Node no longer exists: " + this.nodeRef;
    }

    public class TemplateContentData
    implements Serializable {
        private ContentData contentData;
        private QName property;

        public TemplateContentData(ContentData contentData, QName property) {
            this.contentData = contentData;
            this.property = property;
        }

        public String getContent() {
            ContentService contentService = TemplateNode.this.services.getContentService();
            ContentReader reader = contentService.getReader(TemplateNode.this.nodeRef, this.property);
            return reader != null && reader.exists() ? reader.getContentString() : "";
        }

        public String getUrl() {
            try {
                return MessageFormat.format(TemplateNode.CONTENT_PROP_URL, TemplateNode.this.nodeRef.getStoreRef().getProtocol(), TemplateNode.this.nodeRef.getStoreRef().getIdentifier(), TemplateNode.this.nodeRef.getId(), StringUtils.replace((String)URLEncoder.encode(TemplateNode.this.getName(), "UTF-8"), (String)"+", (String)"%20"), StringUtils.replace((String)URLEncoder.encode(this.property.toString(), "UTF-8"), (String)"+", (String)"%20"));
            }
            catch (UnsupportedEncodingException err) {
                throw new TemplateException("Failed to encode content URL for node: " + TemplateNode.this.nodeRef, err);
            }
        }

        public long getSize() {
            return this.contentData.getSize();
        }

        public String getMimetype() {
            return this.contentData.getMimetype();
        }
    }
}

