/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.ArrayList;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchParameters
extends SearchStatement {
    private static int DEFAULT_LIMIT = 500;
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, true);
    public static final SortDefinition SORT_IN_DOCUMENT_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.DOCUMENT, null, false);
    public static final SortDefinition SORT_IN_SCORE_ORDER_ASCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, false);
    public static final SortDefinition SORT_IN_SCORE_ORDER_DESCENDING = new SortDefinition(SortDefinition.SortType.SCORE, null, true);
    public static final Operator OR = Operator.OR;
    public static final Operator AND = Operator.AND;
    private ArrayList<StoreRef> stores = new ArrayList(1);
    private ArrayList<Path> attributePaths = new ArrayList(1);
    private ArrayList<QueryParameterDefinition> queryParameterDefinitions = new ArrayList(1);
    private boolean excludeDataInTheCurrentTransaction = false;
    private ArrayList<SortDefinition> sortDefinitions = new ArrayList(1);
    private Operator defaultOperator = Operator.OR;
    private LimitBy limitBy = LimitBy.UNLIMITED;
    private PermissionEvaluationMode permissionEvaluation = PermissionEvaluationMode.EAGER;
    private int limit = DEFAULT_LIMIT;

    public void addStore(StoreRef store) {
        if (this.stores.size() != 0) {
            throw new IllegalStateException("At the moment, there can only be one store set for the search");
        }
        this.stores.add(store);
    }

    public void addAttrbutePath(Path attributePath) {
        this.attributePaths.add(attributePath);
    }

    public void addQueryParameterDefinition(QueryParameterDefinition queryParameterDefinition) {
        this.queryParameterDefinitions.add(queryParameterDefinition);
    }

    public void excludeDataInTheCurrentTransaction(boolean excludeDataInTheCurrentTransaction) {
        this.excludeDataInTheCurrentTransaction = excludeDataInTheCurrentTransaction;
    }

    public void addSort(String field, boolean ascending) {
        this.addSort(new SortDefinition(SortDefinition.SortType.FIELD, field, ascending));
    }

    public void addSort(SortDefinition sortDefinition) {
        this.sortDefinitions.add(sortDefinition);
    }

    public ArrayList<Path> getAttributePaths() {
        return this.attributePaths;
    }

    public boolean excludeDataInTheCurrentTransaction() {
        return this.excludeDataInTheCurrentTransaction;
    }

    public ArrayList<QueryParameterDefinition> getQueryParameterDefinitions() {
        return this.queryParameterDefinitions;
    }

    public ArrayList<SortDefinition> getSortDefinitions() {
        return this.sortDefinitions;
    }

    public ArrayList<StoreRef> getStores() {
        return this.stores;
    }

    public void setDefaultOperator(Operator defaultOperator) {
        this.defaultOperator = defaultOperator;
    }

    public Operator getDefaultOperator() {
        return this.defaultOperator;
    }

    public LimitBy getLimitBy() {
        return this.limitBy;
    }

    public void setLimitBy(LimitBy limitBy) {
        this.limitBy = limitBy;
    }

    public PermissionEvaluationMode getPermissionEvaluation() {
        return this.permissionEvaluation;
    }

    public void setPermissionEvaluation(PermissionEvaluationMode permissionEvaluation) {
        this.permissionEvaluation = permissionEvaluation;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public static class SortDefinition {
        SortType sortType;
        String field;
        boolean ascending;

        SortDefinition(SortType sortType, String field, boolean ascending) {
            this.sortType = sortType;
            this.field = field;
            this.ascending = ascending;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public String getField() {
            return this.field;
        }

        public SortType getSortType() {
            return this.sortType;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum SortType {
            FIELD,
            DOCUMENT,
            SCORE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        OR,
        AND;

    }
}

