/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.security;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AuthorityType {
    ADMIN{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "ROLE_ADMINISTRATOR";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }
    }
    ,
    EVERYONE{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "GROUP_EVERYONE";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }
    }
    ,
    OWNER{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "ROLE_OWNER";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }
    }
    ,
    GUEST{

        public boolean isFixedString() {
            return true;
        }

        public String getFixedString() {
            return "guest";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }
    }
    ,
    GROUP{

        public boolean isFixedString() {
            return false;
        }

        public String getFixedString() {
            return "";
        }

        public boolean isPrefixed() {
            return true;
        }

        public String getPrefixString() {
            return "GROUP_";
        }
    }
    ,
    ROLE{

        public boolean isFixedString() {
            return false;
        }

        public String getFixedString() {
            return "";
        }

        public boolean isPrefixed() {
            return true;
        }

        public String getPrefixString() {
            return "ROLE_";
        }
    }
    ,
    USER{

        public boolean isFixedString() {
            return false;
        }

        public String getFixedString() {
            return "";
        }

        public boolean isPrefixed() {
            return false;
        }

        public String getPrefixString() {
            return "";
        }
    };


    public abstract boolean isFixedString();

    public abstract String getFixedString();

    public abstract boolean isPrefixed();

    public abstract String getPrefixString();

    public boolean equals(String authority) {
        return this.equals((Object)AuthorityType.getAuthorityType(authority));
    }

    public static AuthorityType getAuthorityType(String authority) {
        if (authority.equals("ROLE_ADMINISTRATOR")) {
            AuthorityType authorityType = ADMIN;
        }
        AuthorityType authorityType = authority.equals("GROUP_EVERYONE") ? EVERYONE : (authority.equals("ROLE_OWNER") ? OWNER : (authority.equalsIgnoreCase("guest") ? GUEST : (authority.startsWith("GROUP_") ? GROUP : (authority.startsWith("ROLE_") ? ROLE : USER))));
        return authorityType;
    }
}

