/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.namespace;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QNameMap<K, V>
implements Map,
Cloneable {
    protected static Log logger = LogFactory.getLog(QNameMap.class);
    protected Map<String, Object> contents = new HashMap<String, Object>(11, 1.0f);
    protected NamespacePrefixResolver resolver = null;

    public QNameMap(NamespacePrefixResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("NamespacePrefixResolver is mandatory.");
        }
        this.resolver = resolver;
    }

    @Override
    public final int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.contents.containsKey(QName.resolveToQNameString(this.resolver, key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    public Object get(Object key) {
        String qnameKey = QName.resolveToQNameString(this.resolver, key.toString());
        Object obj = this.contents.get(qnameKey);
        return obj;
    }

    public Object put(Object key, Object value) {
        return this.contents.put(QName.resolveToQNameString(this.resolver, key.toString()), value);
    }

    public Object remove(Object key) {
        return this.contents.remove(QName.resolveToQNameString(this.resolver, key.toString()));
    }

    public void putAll(Map t) {
        for (Object key : t.keySet()) {
            this.put(key, t.get(key));
        }
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    public Set<String> keySet() {
        return this.contents.keySet();
    }

    public Collection values() {
        return this.contents.values();
    }

    public Set entrySet() {
        return this.contents.entrySet();
    }

    public String toString() {
        return this.contents.toString();
    }

    public Object clone() {
        QNameMap<K, V> map = new QNameMap<K, V>(this.resolver);
        map.putAll((Map)this);
        return map;
    }
}

