/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tools;

import java.io.File;
import java.io.InputStream;
import org.alfresco.repo.exporter.ACPExportPackageHandler;
import org.alfresco.repo.exporter.FileExportPackageHandler;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.ExportPackageHandler;
import org.alfresco.service.cmr.view.Exporter;
import org.alfresco.service.cmr.view.ExporterContext;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterException;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.tools.Tool;
import org.alfresco.tools.ToolArgumentException;
import org.alfresco.tools.ToolContext;
import org.alfresco.tools.ToolException;

public final class Export
extends Tool {
    private ExportContext context;

    public static void main(String[] args) {
        Export tool = new Export();
        tool.start(args);
    }

    protected String getToolName() {
        return "Alfresco Repository Exporter";
    }

    protected ToolContext processArgs(String[] args) {
        this.context = new ExportContext();
        this.context.setLogin(true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("-help")) {
                this.context.setHelp(true);
                break;
            }
            if (args[i].equals("-s") || args[i].equals("-store")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <store> for the parameter -store must be specified");
                }
                this.context.storeRef = new StoreRef(args[i]);
                continue;
            }
            if (args[i].equals("-p") || args[i].equals("-path")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <path> for the parameter -path must be specified");
                }
                this.context.path = args[i];
                continue;
            }
            if (args[i].equals("-d") || args[i].equals("-dir")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <dir> for the parameter -dir must be specified");
                }
                this.context.destDir = args[i];
                continue;
            }
            if (args[i].equals("-packagedir")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <packagedir> for the parameter -packagedir must be specified");
                }
                this.context.packageDir = args[i];
                continue;
            }
            if (args[i].equals("-user")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <user> for the option -user must be specified");
                }
                this.context.setUsername(args[i]);
                continue;
            }
            if (args[i].equals("-pwd")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <password> for the option -pwd must be specified");
                }
                this.context.setPassword(args[i]);
                continue;
            }
            if (args[i].equals("-root")) {
                this.context.self = true;
                continue;
            }
            if (args[i].equals("-nochildren")) {
                this.context.children = false;
                continue;
            }
            if (args[i].equals("-zip")) {
                this.context.zipped = true;
                continue;
            }
            if (args[i].equals("-overwrite")) {
                this.context.overwrite = true;
                continue;
            }
            if (args[i].equals("-quiet")) {
                this.context.setQuiet(true);
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.context.setVerbose(true);
                continue;
            }
            if (i == args.length - 1) {
                this.context.packageName = args[i];
                continue;
            }
            throw new ToolArgumentException("Unknown option " + args[i]);
        }
        return this.context;
    }

    protected void displayHelp() {
        this.logError("Usage: export -user username -s[tore] store [options] packagename");
        this.logError("");
        this.logError("username: username for login");
        this.logError("store: the store to extract from in the form of scheme://store_name");
        this.logError("packagename: the filename to export to (with or without extension)");
        this.logError("");
        this.logError("Options:");
        this.logError(" -h[elp] display this help");
        this.logError(" -p[ath] the path within the store to extract from (default: /)");
        this.logError(" -d[ir] the destination directory to export to (default: current directory)");
        this.logError(" -pwd password for login");
        this.logError(" -packagedir the directory to place extracted content (default: dir/<packagename>)");
        this.logError(" -root extract the item located at export path");
        this.logError(" -nochildren do not extract children of the item at export path");
        this.logError(" -overwrite force overwrite of existing export package if it already exists");
        this.logError(" -quiet do not display any messages during export");
        this.logError(" -verbose report export progress");
        this.logError(" -zip export in zip format");
    }

    protected int execute() throws ToolException {
        ExporterService exporter = this.getServiceRegistry().getExporterService();
        MimetypeService mimetypeService = this.getServiceRegistry().getMimetypeService();
        ExportPackageHandler exportHandler = null;
        exportHandler = this.context.zipped ? new ZipHandler(this.context.getDestDir(), this.context.getZipFile(), this.context.getPackageFile(), this.context.getPackageDir(), this.context.overwrite, mimetypeService) : new FileHandler(this.context.getDestDir(), this.context.getPackageFile(), this.context.getPackageDir(), this.context.overwrite, mimetypeService);
        ExporterCrawlerParameters parameters = new ExporterCrawlerParameters();
        parameters.setExportFrom(this.context.getLocation());
        parameters.setCrawlSelf(this.context.self);
        parameters.setCrawlChildNodes(this.context.children);
        try {
            exporter.exportView(exportHandler, parameters, (Exporter)new ExportProgress());
        }
        catch (ExporterException e) {
            throw new ToolException("Failed to export", e);
        }
        return 0;
    }

    private class ExportProgress
    implements Exporter {
        private ExportProgress() {
        }

        public void start(ExporterContext exportNodeRef) {
        }

        public void startNamespace(String prefix, String uri) {
            Export.this.logVerbose("Exporting namespace " + uri + " (prefix: " + prefix + ")");
        }

        public void endNamespace(String prefix) {
        }

        public void startNode(NodeRef nodeRef) {
            Export.this.logVerbose("Exporting node " + nodeRef.toString());
        }

        public void endNode(NodeRef nodeRef) {
        }

        public void startAspects(NodeRef nodeRef) {
        }

        public void endAspects(NodeRef nodeRef) {
        }

        public void startAspect(NodeRef nodeRef, QName aspect) {
        }

        public void endAspect(NodeRef nodeRef, QName aspect) {
        }

        public void startACL(NodeRef nodeRef) {
        }

        public void permission(NodeRef nodeRef, AccessPermission permission) {
        }

        public void endACL(NodeRef nodeRef) {
        }

        public void startProperties(NodeRef nodeRef) {
        }

        public void endProperties(NodeRef nodeRef) {
        }

        public void startProperty(NodeRef nodeRef, QName property) {
        }

        public void endProperty(NodeRef nodeRef, QName property) {
        }

        public void startValueCollection(NodeRef nodeRef, QName property) {
        }

        public void endValueCollection(NodeRef nodeRef, QName property) {
        }

        public void value(NodeRef nodeRef, QName property, Object value, int index) {
        }

        public void content(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
        }

        public void startAssoc(NodeRef nodeRef, QName assoc) {
        }

        public void endAssoc(NodeRef nodeRef, QName assoc) {
        }

        public void startAssocs(NodeRef nodeRef) {
        }

        public void endAssocs(NodeRef nodeRef) {
        }

        public void warning(String warning) {
            Export.this.logInfo("Warning: " + warning);
        }

        public void end() {
        }

        public void startReference(NodeRef nodeRef, QName childName) {
        }

        public void endReference(NodeRef nodeRef) {
        }
    }

    private class ExportContext
    extends ToolContext {
        private StoreRef storeRef;
        private String path;
        private String destDir;
        private String packageDir;
        private String packageName;
        private boolean children = true;
        private boolean self = false;
        private boolean overwrite = false;
        private boolean zipped = false;

        private ExportContext() {
        }

        void validate() {
            File fileDestDir;
            super.validate();
            if (this.storeRef == null) {
                throw new ToolArgumentException("Store to export from has not been specified.");
            }
            if (this.packageName == null) {
                throw new ToolArgumentException("Package name has not been specified.");
            }
            if (this.destDir != null && !(fileDestDir = new File(this.destDir)).exists()) {
                throw new ToolArgumentException("Destination directory " + fileDestDir.getAbsolutePath() + " does not exist.");
            }
        }

        private Location getLocation() {
            Location location = new Location(this.storeRef);
            location.setPath(this.path);
            return location;
        }

        private File getDestDir() {
            File dir = this.destDir == null ? null : new File(this.destDir);
            return dir;
        }

        private File getPackageDir() {
            File dir = null;
            dir = this.packageDir != null ? new File(this.packageDir) : (this.packageName.indexOf(46) != -1 ? new File(this.packageName.substring(0, this.packageName.indexOf(46))) : new File(this.packageName));
            return dir;
        }

        private File getPackageFile() {
            String packageFile = this.packageName.indexOf(46) != -1 ? this.packageName : this.packageName + ".xml";
            File file = new File(packageFile);
            return file;
        }

        private File getZipFile() {
            int iExt = this.packageName.indexOf(46);
            String zipFile = (iExt != -1 ? this.packageName.substring(0, iExt) : this.packageName) + ".acp";
            return new File(zipFile);
        }
    }

    private class ZipHandler
    extends ACPExportPackageHandler {
        public ZipHandler(File destDir, File zipFile, File dataFile, File contentDir, boolean overwrite, MimetypeService mimetypeService) {
            super(destDir, zipFile, dataFile, contentDir, overwrite, mimetypeService);
        }

        protected void log(String message) {
            Export.this.logInfo(message);
        }
    }

    private class FileHandler
    extends FileExportPackageHandler {
        public FileHandler(File destDir, File dataFile, File contentDir, boolean overwrite, MimetypeService mimetypeService) {
            super(destDir, dataFile, contentDir, overwrite, mimetypeService);
        }

        protected void log(String message) {
            Export.this.logInfo(message);
        }
    }
}

