/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.tools;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.alfresco.repo.importer.ACPImportPackageHandler;
import org.alfresco.repo.importer.FileImportPackageHandler;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterBinding;
import org.alfresco.service.cmr.view.ImporterException;
import org.alfresco.service.cmr.view.ImporterProgress;
import org.alfresco.service.cmr.view.ImporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.tools.Tool;
import org.alfresco.tools.ToolArgumentException;
import org.alfresco.tools.ToolContext;
import org.alfresco.tools.ToolException;

public class Import
extends Tool {
    private ImportContext context;

    public static void main(String[] args) {
        Import tool = new Import();
        tool.start(args);
    }

    protected ToolContext processArgs(String[] args) throws ToolArgumentException {
        this.context = new ImportContext();
        this.context.setLogin(true);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-h") || args[i].equals("-help")) {
                this.context.setHelp(true);
                break;
            }
            if (args[i].equals("-s") || args[i].equals("-store")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <store> for the option -store must be specified");
                }
                this.context.storeRef = new StoreRef(args[i]);
                continue;
            }
            if (args[i].equals("-p") || args[i].equals("-path")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <path> for the option -path must be specified");
                }
                this.context.path = args[i];
                continue;
            }
            if (args[i].equals("-d") || args[i].equals("-dir")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <dir> for the option -dir must be specified");
                }
                this.context.sourceDir = args[i];
                continue;
            }
            if (args[i].equals("-user")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <user> for the option -user must be specified");
                }
                this.context.setUsername(args[i]);
                continue;
            }
            if (args[i].equals("-pwd")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <password> for the option -pwd must be specified");
                }
                this.context.setPassword(args[i]);
                continue;
            }
            if (args[i].equals("-encoding")) {
                if (++i == args.length || args[i].length() == 0) {
                    throw new ToolArgumentException("The value <encoding> for the option -encoding must be specified");
                }
                this.context.encoding = args[i];
                continue;
            }
            if (args[i].equals("-uuidBinding")) {
                ++i;
                try {
                    this.context.uuidBinding = ImporterBinding.UUID_BINDING.valueOf(ImporterBinding.UUID_BINDING.class, args[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new ToolArgumentException("The value " + args[i] + " is an invalid uuidBinding");
                }
            }
            if (args[i].equals("-quiet")) {
                this.context.setQuiet(true);
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.context.setVerbose(true);
                continue;
            }
            if (i == args.length - 1) {
                this.context.packageName = args[i];
                continue;
            }
            throw new ToolArgumentException("Unknown option " + args[i]);
        }
        return this.context;
    }

    protected void displayHelp() {
        this.logError("Usage: import -user username -s[tore] store [options] packagename");
        this.logError("");
        this.logError("username: username for login");
        this.logError("store: the store to import into the form of scheme://store_name");
        this.logError("packagename: the filename to import from (with or without extension)");
        this.logError("");
        this.logError("Options:");
        this.logError(" -h[elp] display this help");
        this.logError(" -p[ath] the path within the store to extract into (default: /)");
        this.logError(" -d[ir] the source directory to import from (default: current directory)");
        this.logError(" -pwd password for login");
        this.logError(" -encoding package file encoding (default: " + Charset.defaultCharset() + ")");
        this.logError(" -uuidBinding CREATE_NEW, REMOVE_EXISTING, REPLACE_EXISTING, UPDATE_EXISTING, THROW_ON_COLLISION (default: CREATE_NEW)");
        this.logError(" -quiet do not display any messages during import");
        this.logError(" -verbose report import progress");
    }

    protected String getToolName() {
        return "Alfresco Repository Importer";
    }

    protected int execute() throws ToolException {
        ImporterService importer = this.getServiceRegistry().getImporterService();
        ImportPackageHandler importHandler = this.context.zipFile ? new ZipHandler(this.context.getSourceDir(), this.context.getPackageFile(), this.context.encoding) : new FileHandler(this.context.getSourceDir(), this.context.getPackageFile(), this.context.encoding);
        try {
            ImportBinding binding = new ImportBinding(this.context.uuidBinding);
            importer.importView(importHandler, this.context.getLocation(), (ImporterBinding)binding, (ImporterProgress)new ImportProgress());
        }
        catch (ImporterException e) {
            throw new ToolException("Failed to import package due to " + e.getMessage(), e);
        }
        return 0;
    }

    private class ImportBinding
    implements ImporterBinding {
        private ImporterBinding.UUID_BINDING uuidBinding = null;

        public ImportBinding(ImporterBinding.UUID_BINDING uuidBinding) {
            this.uuidBinding = uuidBinding;
        }

        public ImporterBinding.UUID_BINDING getUUIDBinding() {
            return this.uuidBinding;
        }

        public boolean allowReferenceWithinTransaction() {
            return false;
        }

        public String getValue(String key) {
            return null;
        }

        public QName[] getExcludedClasses() {
            return new QName[0];
        }
    }

    private class ImportContext
    extends ToolContext {
        private StoreRef storeRef;
        private String path;
        private String sourceDir;
        private String packageName;
        private String encoding = null;
        private ImporterBinding.UUID_BINDING uuidBinding = ImporterBinding.UUID_BINDING.CREATE_NEW;
        private boolean zipFile = false;

        private ImportContext() {
        }

        void validate() {
            File packageFile;
            File fileSourceDir;
            super.validate();
            if (this.storeRef == null) {
                throw new ToolArgumentException("Store to import into has not been specified.");
            }
            if (this.packageName == null) {
                throw new ToolArgumentException("Package name has not been specified.");
            }
            if (this.sourceDir != null && !(fileSourceDir = this.getSourceDir()).exists()) {
                throw new ToolArgumentException("Source directory " + fileSourceDir.getAbsolutePath() + " does not exist.");
            }
            if (this.packageName.endsWith(".acp")) {
                packageFile = new File(this.getSourceDir(), this.packageName);
                if (!packageFile.exists()) {
                    throw new ToolArgumentException("Package zip file " + packageFile.getAbsolutePath() + " does not exist.");
                }
                this.zipFile = true;
            } else {
                packageFile = new File(this.getSourceDir(), this.getDataFile().getPath());
                if (!packageFile.exists()) {
                    throw new ToolArgumentException("Package file " + packageFile.getAbsolutePath() + " does not exist.");
                }
            }
        }

        private Location getLocation() {
            Location location = new Location(this.storeRef);
            location.setPath(this.path);
            return location;
        }

        private File getSourceDir() {
            File dir = this.sourceDir == null ? null : new File(this.sourceDir);
            return dir;
        }

        private File getDataFile() {
            String dataFile = this.packageName.indexOf(46) != -1 ? this.packageName : this.packageName + ".xml";
            File file = new File(dataFile);
            return file;
        }

        private File getPackageFile() {
            return this.zipFile ? new File(this.packageName) : this.getDataFile();
        }
    }

    private class ImportProgress
    implements ImporterProgress {
        private ImportProgress() {
        }

        public void nodeCreated(NodeRef nodeRef, NodeRef parentRef, QName assocName, QName childName) {
            Import.this.logVerbose("Imported node " + nodeRef + " (parent=" + parentRef + ", childname=" + childName + ", association=" + assocName + ")");
        }

        public void nodeLinked(NodeRef nodeRef, NodeRef parentRef, QName assocName, QName childName) {
        }

        public void contentCreated(NodeRef nodeRef, String sourceUrl) {
        }

        public void propertySet(NodeRef nodeRef, QName property, Serializable value) {
        }

        public void permissionSet(NodeRef nodeRef, AccessPermission permission) {
        }

        public void aspectAdded(NodeRef nodeRef, QName aspect) {
        }

        public void started() {
        }

        public void completed() {
        }

        public void error(Throwable e) {
        }
    }

    private class FileHandler
    extends FileImportPackageHandler {
        public FileHandler(File sourceDir, File dataFile, String dataFileEncoding) {
            super(sourceDir, dataFile, dataFileEncoding);
        }

        protected void log(String message) {
            Import.this.logInfo(message);
        }
    }

    private class ZipHandler
    extends ACPImportPackageHandler {
        public ZipHandler(File sourceDir, File dataFile, String dataFileEncoding) {
            super(new File(sourceDir, dataFile.getPath()), dataFileEncoding);
        }

        protected void log(String message) {
            Import.this.logInfo(message);
        }
    }
}

