/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public abstract class BaseAlfrescoTestCase
extends TestCase {
    public static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    protected ServiceRegistry serviceRegistry;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected AuthenticationService authenticationService;
    protected StoreRef storeRef;
    protected NodeRef rootNodeRef;
    protected ActionService actionService;
    protected TransactionService transactionService;

    protected void setUp() throws Exception {
        super.setUp();
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.authenticationService = (AuthenticationService)ctx.getBean("authenticationService");
        this.actionService = (ActionService)ctx.getBean("actionService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    protected void tearDown() throws Exception {
        this.authenticationService.clearCurrentSecurityContext();
        super.tearDown();
    }
}

