/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import junit.framework.TestCase;
import org.alfresco.util.SearchLanguageConversion;

public class SearchLanguageConversionTest
extends TestCase {
    private static final String BAD_STRING = "\\ | ! \" \u00c2\u00a3 $ % ^ & * ( ) _ { } [ ] @ # ~ ' : ; , . < > + ? / \\\\ \\* \\? \\_";

    public void testEscapeXPathLike() {
        String good = SearchLanguageConversion.escapeForXPathLike(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for xpath failed", (String)"\\\\ | ! \" \u00c2\u00a3 $ \\% ^ & * ( ) \\_ { } [ ] @ # ~ ' : ; , . < > + ? / \\\\\\\\ \\\\* \\\\? \\\\\\_", (String)good);
    }

    public void testEscapeRegex() {
        String good = SearchLanguageConversion.escapeForRegex(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for regex failed", (String)"\\\\ \\| ! \" \u00c2\u00a3 \\$ % \\^ & \\* \\( \\) _ \\{ \\} [ ] @ # ~ ' : ; , \\. < > \\+ \\? / \\\\\\\\ \\\\\\* \\\\\\? \\\\_", (String)good);
    }

    public void testEscapeLucene() {
        String good = SearchLanguageConversion.escapeForLucene(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"Escaping for regex failed", (String)"\\\\ | \\! \\\" \u00c2\u00a3 $ % \\^ & \\* \\( \\) _ \\{ \\} \\[ \\] @ # \\~ ' \\: ; , . < > \\+ \\? / \\\\\\\\ \\\\\\* \\\\\\? \\\\_", (String)good);
    }

    public void testConvertXPathLikeToRegex() {
        String good = SearchLanguageConversion.convertXPathLikeToRegex(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"XPath like to regex failed", (String)"(?s)\\ \\| ! \" \u00c2\u00a3 \\$ .* \\^ & \\* \\( \\) . \\{ \\} [ ] @ # ~ ' : ; , \\. < > \\+ \\? / \\\\ \\* \\? \\_", (String)good);
    }

    public void testConvertXPathLikeToLucene() {
        String good = SearchLanguageConversion.convertXPathLikeToLucene(BAD_STRING);
        SearchLanguageConversionTest.assertEquals((String)"XPath like to regex failed", (String)"\\ | \\! \\\" \u00c2\u00a3 $ * \\^ & \\* \\( \\) ? \\{ \\} \\[ \\] @ # \\~ ' \\: ; , . < > \\+ \\? / \\\\ \\* \\? \\_", (String)good);
    }
}

