/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;

public abstract class TestWithUserUtils
extends BaseSpringTest {
    public static void createUser(String userName, String password, NodeRef rootNodeRef, NodeService nodeService, AuthenticationService authenticationService) {
        if (authenticationService.authenticationExists(userName)) {
            return;
        }
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName("http://www.alfresco.org/model/system/1.0", "system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName("http://www.alfresco.org/model/system/1.0", "people");
        NodeRef systemNodeRef = nodeService.createNode(rootNodeRef, children, system, container).getChildRef();
        NodeRef typesNodeRef = nodeService.createNode(systemNodeRef, children, types, container).getChildRef();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, properties);
        authenticationService.createAuthentication(userName, password.toCharArray());
    }

    public static void authenticateUser(String userName, String password, NodeRef rootNodeRef, AuthenticationService authenticationService) {
        authenticationService.authenticate(userName, password.toCharArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void authenticateUser(String userName, String password, AuthenticationService authenticationService, AuthenticationComponent authenticationComponent) {
        try {
            authenticationComponent.setSystemUserAsCurrentUser();
            if (!authenticationService.authenticationExists(userName)) {
                authenticationService.createAuthentication(userName, password.toCharArray());
            }
        }
        finally {
            authenticationComponent.clearCurrentSecurityContext();
        }
        authenticationService.authenticate(userName, password.toCharArray());
    }

    public static String getCurrentUser(AuthenticationService authenticationService) {
        String un = authenticationService.getCurrentUserName();
        if (un != null) {
            return un;
        }
        throw new RuntimeException("The current user could not be retrieved.");
    }

    public static void deleteUser(String user_name, String pwd, NodeRef ref, NodeService service, AuthenticationService service2) {
        service2.deleteAuthentication(user_name);
    }
}

