/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.alfresco.error.AlfrescoRuntimeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutorFactoryBean
implements FactoryBean,
InitializingBean {
    private int corePoolSize = 5;
    private int maximumPoolSize = 20;
    private int keepAliveTime = 30;
    private BlockingQueue<Runnable> workQueue;
    private ThreadPoolExecutor instance;

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setKeepAliveTime(int keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setWorkQueue(BlockingQueue<Runnable> workQueue) {
        this.workQueue = workQueue;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.workQueue == null) {
            this.workQueue = new ArrayBlockingQueue<Runnable>(this.corePoolSize);
        }
        this.instance = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.workQueue);
    }

    public boolean isSingleton() {
        return true;
    }

    public Object getObject() throws Exception {
        if (this.instance == null) {
            throw new AlfrescoRuntimeException("The ThreadPoolExecutor instance has not been created");
        }
        return this.instance;
    }

    public Class getObjectType() {
        return ThreadPoolExecutor.class;
    }
}

