/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.debug;

import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodCallLogAdvice
implements MethodInterceptor {
    private static final Log logger = LogFactory.getLog(MethodCallLogAdvice.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (logger.isDebugEnabled()) {
            return this.invokeWithLogging(invocation);
        }
        return invocation.proceed();
    }

    private Object invokeWithLogging(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        String className = invocation.getMethod().getDeclaringClass().getName();
        try {
            Object ret = invocation.proceed();
            Log methodLogger = LogFactory.getLog((String)(className + "." + methodName));
            if (methodLogger.isDebugEnabled()) {
                StringBuffer sb = this.getInvocationInfo(className, methodName, invocation.getArguments());
                sb.append("   Result: ").append(ret);
                methodLogger.debug((Object)sb);
            }
            return ret;
        }
        catch (Throwable e) {
            Log exceptionLogger = LogFactory.getLog((String)(className + "." + methodName + ".exception"));
            if (exceptionLogger.isDebugEnabled()) {
                StringBuffer sb = this.getInvocationInfo(className, methodName, invocation.getArguments());
                sb.append("   Failure: ").append(e.getClass().getName()).append(" - ").append(e.getMessage());
                exceptionLogger.debug((Object)sb);
            }
            throw e;
        }
    }

    private StringBuffer getInvocationInfo(String className, String methodName, Object[] args) {
        StringBuffer sb = new StringBuffer(250);
        sb.append("\nMethod: ").append(className).append("#").append(methodName).append("\n");
        sb.append("   Transaction: ").append(AlfrescoTransactionSupport.getTransactionId()).append("\n");
        for (Object arg : args) {
            sb.append("   Argument: ").append(arg).append("\n");
        }
        return sb;
    }
}

