/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.debug;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;

public class NodeStoreInspector {
    public static String dumpNodeStore(NodeService nodeService, StoreRef storeRef) {
        StringBuilder builder = new StringBuilder();
        if (nodeService.exists(storeRef)) {
            NodeRef rootNode = nodeService.getRootNode(storeRef);
            builder.append(NodeStoreInspector.outputNode(0, nodeService, rootNode));
        } else {
            builder.append("The store ").append(storeRef.toString()).append(" does not exist.");
        }
        return builder.toString();
    }

    public static String dumpNode(NodeService nodeService, NodeRef nodeRef) {
        StringBuilder builder = new StringBuilder();
        if (nodeService.exists(nodeRef)) {
            builder.append(NodeStoreInspector.outputNode(0, nodeService, nodeRef));
        } else {
            builder.append("The node ").append(nodeRef.toString()).append(" does not exist.");
        }
        return builder.toString();
    }

    private static String outputNode(int iIndent, NodeService nodeService, NodeRef nodeRef) {
        StringBuilder builder = new StringBuilder();
        try {
            QName nodeType = nodeService.getType(nodeRef);
            builder.append(NodeStoreInspector.getIndent(iIndent)).append("node: ").append(nodeRef.getId()).append(" (").append(nodeType.getLocalName());
            Set<QName> aspects = nodeService.getAspects(nodeRef);
            for (QName aspect : aspects) {
                builder.append(", ").append(aspect.getLocalName());
            }
            builder.append(")\n");
            Map<QName, Serializable> props = nodeService.getProperties(nodeRef);
            for (QName name : props.keySet()) {
                String valueAsString = "null";
                Serializable value = props.get(name);
                if (value != null) {
                    valueAsString = value.toString();
                }
                builder.append(NodeStoreInspector.getIndent(iIndent + 1)).append("@").append(name.getLocalName()).append(" = ").append(valueAsString).append("\n");
            }
            List<ChildAssociationRef> childAssocRefs = nodeService.getChildAssocs(nodeRef);
            for (ChildAssociationRef childAssocRef : childAssocRefs) {
                builder.append(NodeStoreInspector.getIndent(iIndent + 1)).append("-> ").append(childAssocRef.getQName().toString()).append(" (").append(childAssocRef.getQName().toString()).append(")\n");
                builder.append(NodeStoreInspector.outputNode(iIndent + 2, nodeService, childAssocRef.getChildRef()));
            }
            List<AssociationRef> assocRefs = nodeService.getTargetAssocs(nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef assocRef : assocRefs) {
                builder.append(NodeStoreInspector.getIndent(iIndent + 1)).append("-> associated to ").append(assocRef.getTargetRef().getId()).append("\n");
            }
        }
        catch (InvalidNodeRefException invalidNode) {
            invalidNode.printStackTrace();
        }
        return builder.toString();
    }

    private static String getIndent(int iIndent) {
        StringBuilder builder = new StringBuilder(iIndent * 3);
        for (int i = 0; i < iIndent; ++i) {
            builder.append("   ");
        }
        return builder.toString();
    }
}

