/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.persistence.MapsId;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.DuplicateMappingException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.CopyIdentifierComponentSecondPass;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.cfg.EJB3NamingStrategy;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.ExtendsQueueEntry;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.MetadataSourceType;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.cfg.PkDrivenByDefaultMapsIdSecondPass;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.QuerySecondPass;
import org.hibernate.cfg.RecoverableException;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.SetSimpleValueTypeSecondPass;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.annotations.reflection.JPAMetadataProvider;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorAggregator;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.internal.DefaultIdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.SerializationHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.internal.util.xml.ErrorLogger;
import org.hibernate.internal.util.xml.MappingReader;
import org.hibernate.internal.util.xml.Origin;
import org.hibernate.internal.util.xml.OriginImpl;
import org.hibernate.internal.util.xml.XMLHelper;
import org.hibernate.internal.util.xml.XmlDocument;
import org.hibernate.internal.util.xml.XmlDocumentImpl;
import org.hibernate.mapping.AuxiliaryDatabaseObject;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.DenormalizedTable;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.IdentifierCollection;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.metamodel.spi.TypeContributions;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.internal.JACCConfiguration;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.internal.StandardServiceRegistryImpl;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.SchemaUpdateScript;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.tool.hbm2ddl.UniqueConstraintSchemaUpdateStrategy;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Configuration
implements Serializable {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Configuration.class.getName());
    public static final String DEFAULT_CACHE_CONCURRENCY_STRATEGY = "hibernate.cache.default_cache_concurrency_strategy";
    public static final String USE_NEW_ID_GENERATOR_MAPPINGS = "hibernate.id.new_generator_mappings";
    public static final String ARTEFACT_PROCESSING_ORDER = "hibernate.mapping.precedence";
    private static final String SEARCH_STARTUP_CLASS = "org.hibernate.search.event.EventListenerRegister";
    private static final String SEARCH_STARTUP_METHOD = "enableHibernateSearch";
    protected MetadataSourceQueue metadataSourceQueue;
    private transient ReflectionManager reflectionManager;
    protected Map<String, PersistentClass> classes;
    protected Map<String, String> imports;
    protected Map<String, Collection> collections;
    protected Map<String, Table> tables;
    protected List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjects;
    protected Map<String, NamedQueryDefinition> namedQueries;
    protected Map<String, NamedSQLQueryDefinition> namedSqlQueries;
    protected Map<String, ResultSetMappingDefinition> sqlResultSetMappings;
    protected Map<String, TypeDef> typeDefs;
    protected Map<String, FilterDefinition> filterDefinitions;
    protected Map<String, FetchProfile> fetchProfiles;
    protected Map tableNameBinding;
    protected Map columnNameBindingPerTable;
    protected List<SecondPass> secondPasses;
    protected List<Mappings.PropertyReference> propertyReferences;
    protected Map<ExtendsQueueEntry, ?> extendsQueue;
    protected Map<String, SQLFunction> sqlFunctions;
    private TypeResolver typeResolver = new TypeResolver();
    private List<TypeContributor> typeContributorRegistrations = new ArrayList<TypeContributor>();
    private EntityTuplizerFactory entityTuplizerFactory;
    private Interceptor interceptor;
    private Properties properties;
    private EntityResolver entityResolver;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    protected transient XMLHelper xmlHelper;
    protected NamingStrategy namingStrategy;
    private SessionFactoryObserver sessionFactoryObserver;
    protected final SettingsFactory settingsFactory;
    private transient Mapping mapping = this.buildMapping();
    private MutableIdentifierGeneratorFactory identifierGeneratorFactory;
    private Map<Class<?>, org.hibernate.mapping.MappedSuperclass> mappedSuperClasses;
    private Map<String, IdGenerator> namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<String, AnnotatedClassType> classTypes;
    private Set<String> defaultNamedQueryNames;
    private Set<String> defaultNamedNativeQueryNames;
    private Set<String> defaultSqlResultSetMappingNames;
    private Set<String> defaultNamedGenerators;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<UniqueConstraintHolder>> uniqueConstraintHoldersByTable;
    private Map<String, String> mappedByResolver;
    private Map<String, String> propertyRefResolver;
    private Map<String, AnyMetaDef> anyMetaDefs;
    private List<CacheHolder> caches;
    private boolean inSecondPass = false;
    private boolean isDefaultProcessed = false;
    private boolean isValidatorNotPresentLogged;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithMapsId;
    private Map<XClass, Map<String, PropertyData>> propertiesAnnotatedWithIdAndToOne;
    private CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
    private boolean specjProprietarySyntaxEnabled;
    final ObjectNameNormalizer normalizer = new ObjectNameNormalizerImpl();
    public static final MetadataSourceType[] DEFAULT_ARTEFACT_PROCESSING_ORDER = new MetadataSourceType[]{MetadataSourceType.HBM, MetadataSourceType.CLASS};
    private List<MetadataSourceType> metadataSourcePrecedence;

    protected Configuration(SettingsFactory settingsFactory) {
        this.settingsFactory = settingsFactory;
        this.reset();
    }

    public Configuration() {
        this(new SettingsFactory());
    }

    protected void reset() {
        this.metadataSourceQueue = new MetadataSourceQueue();
        this.createReflectionManager();
        this.classes = new HashMap<String, PersistentClass>();
        this.imports = new HashMap<String, String>();
        this.collections = new HashMap<String, Collection>();
        this.tables = new TreeMap<String, Table>();
        this.namedQueries = new HashMap<String, NamedQueryDefinition>();
        this.namedSqlQueries = new HashMap<String, NamedSQLQueryDefinition>();
        this.sqlResultSetMappings = new HashMap<String, ResultSetMappingDefinition>();
        this.typeDefs = new HashMap<String, TypeDef>();
        this.filterDefinitions = new HashMap<String, FilterDefinition>();
        this.fetchProfiles = new HashMap<String, FetchProfile>();
        this.auxiliaryDatabaseObjects = new ArrayList<AuxiliaryDatabaseObject>();
        this.tableNameBinding = new HashMap();
        this.columnNameBindingPerTable = new HashMap();
        this.secondPasses = new ArrayList<SecondPass>();
        this.propertyReferences = new ArrayList<Mappings.PropertyReference>();
        this.extendsQueue = new HashMap();
        this.xmlHelper = new XMLHelper();
        this.interceptor = EmptyInterceptor.INSTANCE;
        this.properties = Environment.getProperties();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.sqlFunctions = new HashMap<String, SQLFunction>();
        this.entityTuplizerFactory = new EntityTuplizerFactory();
        this.identifierGeneratorFactory = new DefaultIdentifierGeneratorFactory();
        this.mappedSuperClasses = new HashMap();
        this.metadataSourcePrecedence = Collections.emptyList();
        this.namedGenerators = new HashMap<String, IdGenerator>();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<String, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.defaultNamedQueryNames = new HashSet<String>();
        this.defaultNamedNativeQueryNames = new HashSet<String>();
        this.defaultSqlResultSetMappingNames = new HashSet<String>();
        this.defaultNamedGenerators = new HashSet<String>();
        this.uniqueConstraintHoldersByTable = new HashMap<Table, List<UniqueConstraintHolder>>();
        this.mappedByResolver = new HashMap<String, String>();
        this.propertyRefResolver = new HashMap<String, String>();
        this.caches = new ArrayList<CacheHolder>();
        this.namingStrategy = EJB3NamingStrategy.INSTANCE;
        this.setEntityResolver(new EJB3DTDEntityResolver());
        this.anyMetaDefs = new HashMap<String, AnyMetaDef>();
        this.propertiesAnnotatedWithMapsId = new HashMap<XClass, Map<String, PropertyData>>();
        this.propertiesAnnotatedWithIdAndToOne = new HashMap<XClass, Map<String, PropertyData>>();
        this.specjProprietarySyntaxEnabled = System.getProperty("hibernate.enable_specj_proprietary_syntax") != null;
    }

    public EntityTuplizerFactory getEntityTuplizerFactory() {
        return this.entityTuplizerFactory;
    }

    public ReflectionManager getReflectionManager() {
        return this.reflectionManager;
    }

    public Iterator<PersistentClass> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Iterator getCollectionMappings() {
        return this.collections.values().iterator();
    }

    public Iterator<Table> getTableMappings() {
        return this.tables.values().iterator();
    }

    public Iterator<org.hibernate.mapping.MappedSuperclass> getMappedSuperclassMappings() {
        return this.mappedSuperClasses.values().iterator();
    }

    public PersistentClass getClassMapping(String entityName) {
        return this.classes.get(entityName);
    }

    public Collection getCollectionMapping(String role) {
        return this.collections.get(role);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public void setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        return this.addFile(new File(xmlFile));
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        InputSource inputSource;
        LOG.readingMappingsFromFile(xmlFile.getPath());
        String name = xmlFile.getAbsolutePath();
        try {
            inputSource = new InputSource(new FileInputStream(xmlFile));
        }
        catch (FileNotFoundException e) {
            throw new MappingNotFoundException("file", xmlFile.toString());
        }
        this.add(inputSource, "file", name);
        return this;
    }

    private XmlDocument add(InputSource inputSource, String originType, String originName) {
        return this.add(inputSource, new OriginImpl(originType, originName));
    }

    private XmlDocument add(InputSource inputSource, Origin origin) {
        XmlDocument metadataXml = MappingReader.INSTANCE.readMappingDocument(this.entityResolver, inputSource, origin);
        this.add(metadataXml);
        return metadataXml;
    }

    public void add(XmlDocument metadataXml) {
        if (this.inSecondPass || !Configuration.isOrmXml(metadataXml)) {
            this.metadataSourceQueue.add(metadataXml);
        } else {
            MetadataProvider metadataProvider = ((MetadataProviderInjector)this.reflectionManager).getMetadataProvider();
            JPAMetadataProvider jpaMetadataProvider = (JPAMetadataProvider)metadataProvider;
            List<String> classNames = jpaMetadataProvider.getXMLContext().addDocument(metadataXml.getDocumentTree());
            for (String className : classNames) {
                try {
                    this.metadataSourceQueue.add(this.reflectionManager.classForName(className, this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to load class defined in XML: " + className, e);
                }
            }
        }
    }

    private static boolean isOrmXml(XmlDocument xmlDocument) {
        return "entity-mappings".equals(xmlDocument.getDocumentTree().getRootElement().getName());
    }

    public Configuration addCacheableFile(File xmlFile) throws MappingException {
        InputSource inputSource;
        File cachedFile = this.determineCachedDomFile(xmlFile);
        try {
            return this.addCacheableFileStrictly(xmlFile);
        }
        catch (SerializationException e) {
            LOG.unableToDeserializeCache(cachedFile.getPath(), e);
        }
        catch (FileNotFoundException e) {
            LOG.cachedFileNotFound(cachedFile.getPath(), e);
        }
        String name = xmlFile.getAbsolutePath();
        try {
            inputSource = new InputSource(new FileInputStream(xmlFile));
        }
        catch (FileNotFoundException e) {
            throw new MappingNotFoundException("file", xmlFile.toString());
        }
        LOG.readingMappingsFromFile(xmlFile.getPath());
        XmlDocument metadataXml = this.add(inputSource, "file", name);
        try {
            LOG.debugf("Writing cache file for: %s to: %s", xmlFile, cachedFile);
            SerializationHelper.serialize((Serializable)metadataXml.getDocumentTree(), new FileOutputStream(cachedFile));
        }
        catch (Exception e) {
            LOG.unableToWriteCachedFile(cachedFile.getPath(), e.getMessage());
        }
        return this;
    }

    private File determineCachedDomFile(File xmlFile) {
        return new File(xmlFile.getAbsolutePath() + ".bin");
    }

    public Configuration addCacheableFileStrictly(File xmlFile) throws SerializationException, FileNotFoundException {
        boolean useCachedFile;
        File cachedFile = this.determineCachedDomFile(xmlFile);
        boolean bl = useCachedFile = xmlFile.exists() && cachedFile.exists() && xmlFile.lastModified() < cachedFile.lastModified();
        if (!useCachedFile) {
            throw new FileNotFoundException("Cached file could not be found or could not be used");
        }
        LOG.readingCachedMappings(cachedFile);
        Document document = (Document)SerializationHelper.deserialize(new FileInputStream(cachedFile));
        this.add(new XmlDocumentImpl(document, "file", xmlFile.getAbsolutePath()));
        return this;
    }

    public Configuration addCacheableFile(String xmlFile) throws MappingException {
        return this.addCacheableFile(new File(xmlFile));
    }

    public Configuration addXML(String xml) throws MappingException {
        LOG.debugf("Mapping XML:\n%s", xml);
        InputSource inputSource = new InputSource(new StringReader(xml));
        this.add(inputSource, "string", "XML String");
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        String urlExternalForm = url.toExternalForm();
        LOG.debugf("Reading mapping document from URL : %s", urlExternalForm);
        try {
            this.add(url.openStream(), "URL", urlExternalForm);
        }
        catch (IOException e) {
            throw new InvalidMappingException("Unable to open url stream [" + urlExternalForm + "]", "URL", urlExternalForm, e);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlDocument add(InputStream inputStream, String type, String name) {
        InputSource inputSource = new InputSource(inputStream);
        try {
            XmlDocument xmlDocument = this.add(inputSource, type, name);
            return xmlDocument;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignore) {
                LOG.trace("Was unable to close input stream");
            }
        }
    }

    public Configuration addDocument(org.w3c.dom.Document doc) throws MappingException {
        LOG.debugf("Mapping Document:\n%s", doc);
        Document document = this.xmlHelper.createDOMReader().read(doc);
        this.add(new XmlDocumentImpl(document, "unknown", null));
        return this;
    }

    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        this.add(xmlInputStream, "input stream", null);
        return this;
    }

    public Configuration addResource(String resourceName, ClassLoader classLoader) throws MappingException {
        LOG.readingMappingsFromResource(resourceName);
        InputStream resourceInputStream = classLoader.getResourceAsStream(resourceName);
        if (resourceInputStream == null) {
            throw new MappingNotFoundException("resource", resourceName);
        }
        this.add(resourceInputStream, "resource", resourceName);
        return this;
    }

    public Configuration addResource(String resourceName) throws MappingException {
        LOG.readingMappingsFromResource(resourceName);
        ClassLoader contextClassLoader = ClassLoaderHelper.getContextClassLoader();
        InputStream resourceInputStream = null;
        if (contextClassLoader != null) {
            resourceInputStream = contextClassLoader.getResourceAsStream(resourceName);
        }
        if (resourceInputStream == null) {
            resourceInputStream = Environment.class.getClassLoader().getResourceAsStream(resourceName);
        }
        if (resourceInputStream == null) {
            throw new MappingNotFoundException("resource", resourceName);
        }
        this.add(resourceInputStream, "resource", resourceName);
        return this;
    }

    public Configuration addClass(Class persistentClass) throws MappingException {
        String mappingResourceName = persistentClass.getName().replace('.', '/') + ".hbm.xml";
        LOG.readingMappingsFromResource(mappingResourceName);
        return this.addResource(mappingResourceName, persistentClass.getClassLoader());
    }

    public Configuration addAnnotatedClass(Class annotatedClass) {
        XClass xClass = this.reflectionManager.toXClass(annotatedClass);
        this.metadataSourceQueue.add(xClass);
        return this;
    }

    public Configuration addPackage(String packageName) throws MappingException {
        LOG.debugf("Mapping Package %s", packageName);
        try {
            AnnotationBinder.bindPackage(packageName, this.createMappings());
            return this;
        }
        catch (MappingException me) {
            LOG.unableToParseMetadata(packageName);
            throw me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Configuration addJar(File jar) throws MappingException {
        LOG.searchingForMappingDocuments(jar.getName());
        JarFile jarFile = null;
        try {
            try {
                jarFile = new JarFile(jar);
            }
            catch (IOException ioe) {
                throw new InvalidMappingException("Could not read mapping documents from jar: " + jar.getName(), "jar", jar.getName(), ioe);
            }
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                ZipEntry ze = jarEntries.nextElement();
                if (!ze.getName().endsWith(".hbm.xml")) continue;
                LOG.foundMappingDocument(ze.getName());
                try {
                    this.addInputStream(jarFile.getInputStream(ze));
                }
                catch (Exception e) {
                    throw new InvalidMappingException("Could not read mapping documents from jar: " + jar.getName(), "jar", jar.getName(), e);
                    return this;
                }
            }
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException ioe) {
                LOG.unableToCloseJar(ioe.getMessage());
            }
        }
    }

    public Configuration addDirectory(File dir) throws MappingException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.addDirectory(file);
                continue;
            }
            if (!file.getName().endsWith(".hbm.xml")) continue;
            this.addFile(file);
        }
        return this;
    }

    public Mappings createMappings() {
        return new MappingsImpl();
    }

    private Iterator<IdentifierGenerator> iterateGenerators(Dialect dialect) throws MappingException {
        IdentifierGenerator ig;
        TreeMap<Object, IdentifierGenerator> generators = new TreeMap<Object, IdentifierGenerator>();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        for (PersistentClass pc : this.classes.values()) {
            if (pc.isInherited()) continue;
            ig = pc.getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, (RootClass)pc);
            if (ig instanceof PersistentIdentifierGenerator) {
                generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
                continue;
            }
            if (!(ig instanceof IdentifierGeneratorAggregator)) continue;
            ((IdentifierGeneratorAggregator)((Object)ig)).registerPersistentGenerators(generators);
        }
        for (Collection collection : this.collections.values()) {
            if (!collection.isIdentified() || !((ig = ((IdentifierCollection)collection).getIdentifier().createIdentifierGenerator(this.getIdentifierGeneratorFactory(), dialect, defaultCatalog, defaultSchema, null)) instanceof PersistentIdentifierGenerator)) continue;
            generators.put(((PersistentIdentifierGenerator)ig).generatorKey(), ig);
        }
        return generators.values().iterator();
    }

    public String[] generateDropSchemaScript(Dialect dialect) throws HibernateException {
        Table table;
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        ArrayList<String> script = new ArrayList<String>(50);
        Iterator<Object> itr = this.auxiliaryDatabaseObjects.listIterator(this.auxiliaryDatabaseObjects.size());
        while (itr.hasPrevious()) {
            AuxiliaryDatabaseObject object = itr.previous();
            if (!object.appliesToDialect(dialect)) continue;
            script.add(object.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        if (dialect.dropConstraints()) {
            itr = this.getTableMappings();
            while (itr.hasNext()) {
                table = (Table)itr.next();
                if (!table.isPhysicalTable()) continue;
                Iterator subItr = table.getForeignKeyIterator();
                while (subItr.hasNext()) {
                    ForeignKey fk = (ForeignKey)subItr.next();
                    if (!fk.isPhysicalConstraint()) continue;
                    script.add(fk.sqlDropString(dialect, defaultCatalog, defaultSchema));
                }
            }
        }
        itr = this.getTableMappings();
        while (itr.hasNext()) {
            table = (Table)itr.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlDropString(dialect, defaultCatalog, defaultSchema));
        }
        itr = this.iterateGenerators(dialect);
        while (itr.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)itr.next()).sqlDropStrings(dialect);
            script.addAll(Arrays.asList(lines));
        }
        return ArrayHelper.toStringArray(script);
    }

    public String[] generateSchemaCreationScript(Dialect dialect) throws HibernateException {
        Iterator subIter;
        Table table;
        this.secondPassCompile();
        ArrayList<String> script = new ArrayList<String>(50);
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = iter.next();
            if (!table.isPhysicalTable()) continue;
            script.add(table.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            Iterator comments = table.sqlCommentStrings(dialect, defaultCatalog, defaultSchema);
            while (comments.hasNext()) {
                script.add((String)comments.next());
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = iter.next();
            if (!table.isPhysicalTable()) continue;
            subIter = table.getUniqueKeyIterator();
            while (subIter.hasNext()) {
                UniqueKey uk = (UniqueKey)subIter.next();
                String constraintString = uk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema);
                if (constraintString == null) continue;
                script.add(constraintString);
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                script.add(index.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = iter.next();
            if (!table.isPhysicalTable() || !dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint()) continue;
                script.add(fk.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            String[] lines = ((PersistentIdentifierGenerator)iter.next()).sqlCreateStrings(dialect);
            script.addAll(Arrays.asList(lines));
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjects) {
            if (!auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            script.add(auxiliaryDatabaseObject.sqlCreateString(dialect, this.mapping, defaultCatalog, defaultSchema));
        }
        return ArrayHelper.toStringArray(script);
    }

    @Deprecated
    public String[] generateSchemaUpdateScript(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        List<SchemaUpdateScript> scripts = this.generateSchemaUpdateScriptList(dialect, databaseMetadata);
        return SchemaUpdateScript.toStringArray(scripts);
    }

    public List<SchemaUpdateScript> generateSchemaUpdateScriptList(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        Iterator subIter;
        TableMetadata tableInfo;
        String tableCatalog;
        String tableSchema;
        Table table;
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        UniqueConstraintSchemaUpdateStrategy constraintMethod = UniqueConstraintSchemaUpdateStrategy.interpret(this.properties.get("hibernate.schema_update.unique_constraint_strategy"));
        ArrayList<SchemaUpdateScript> scripts = new ArrayList<SchemaUpdateScript>();
        Iterator<Object> iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = iter.next();
            tableSchema = table.getSchema() == null ? defaultSchema : table.getSchema();
            String string = tableCatalog = table.getCatalog() == null ? defaultCatalog : table.getCatalog();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), tableSchema, tableCatalog, table.isQuoted());
            if (tableInfo == null) {
                scripts.add(new SchemaUpdateScript(table.sqlCreateString(dialect, this.mapping, tableCatalog, tableSchema), false));
            } else {
                Iterator subiter = table.sqlAlterStrings(dialect, this.mapping, tableInfo, tableCatalog, tableSchema);
                while (subiter.hasNext()) {
                    scripts.add(new SchemaUpdateScript((String)subiter.next(), false));
                }
            }
            Iterator comments = table.sqlCommentStrings(dialect, defaultCatalog, defaultSchema);
            while (comments.hasNext()) {
                scripts.add(new SchemaUpdateScript((String)comments.next(), false));
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            IndexMetadata meta;
            table = iter.next();
            tableSchema = table.getSchema() == null ? defaultSchema : table.getSchema();
            String string = tableCatalog = table.getCatalog() == null ? defaultCatalog : table.getCatalog();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), tableSchema, tableCatalog, table.isQuoted());
            if (!constraintMethod.equals((Object)UniqueConstraintSchemaUpdateStrategy.SKIP)) {
                Iterator uniqueIter = table.getUniqueKeyIterator();
                while (uniqueIter.hasNext()) {
                    UniqueKey uniqueKey = (UniqueKey)uniqueIter.next();
                    if (tableInfo != null && StringHelper.isNotEmpty(uniqueKey.getName()) && (meta = tableInfo.getIndexMetadata(uniqueKey.getName())) != null) continue;
                    String constraintString = uniqueKey.sqlCreateString(dialect, this.mapping, tableCatalog, tableSchema);
                    if (constraintString != null && !constraintString.isEmpty() && constraintMethod.equals((Object)UniqueConstraintSchemaUpdateStrategy.DROP_RECREATE_QUIETLY)) {
                        String constraintDropString = uniqueKey.sqlDropString(dialect, tableCatalog, tableSchema);
                        scripts.add(new SchemaUpdateScript(constraintDropString, true));
                    }
                    scripts.add(new SchemaUpdateScript(constraintString, true));
                }
            }
            subIter = table.getIndexIterator();
            while (subIter.hasNext()) {
                Index index = (Index)subIter.next();
                if (tableInfo != null && StringHelper.isNotEmpty(index.getName()) && (meta = tableInfo.getIndexMetadata(index.getName())) != null) continue;
                scripts.add(new SchemaUpdateScript(index.sqlCreateString(dialect, this.mapping, tableCatalog, tableSchema), false));
            }
        }
        iter = this.getTableMappings();
        while (iter.hasNext()) {
            table = iter.next();
            tableSchema = table.getSchema() == null ? defaultSchema : table.getSchema();
            String string = tableCatalog = table.getCatalog() == null ? defaultCatalog : table.getCatalog();
            if (!table.isPhysicalTable()) continue;
            tableInfo = databaseMetadata.getTableMetadata(table.getName(), tableSchema, tableCatalog, table.isQuoted());
            if (!dialect.hasAlterTable()) continue;
            subIter = table.getForeignKeyIterator();
            while (subIter.hasNext()) {
                boolean create;
                ForeignKey fk = (ForeignKey)subIter.next();
                if (!fk.isPhysicalConstraint() || !(create = tableInfo == null || tableInfo.getForeignKeyMetadata(fk) == null && (!(dialect instanceof MySQLDialect) || tableInfo.getIndexMetadata(fk.getName()) == null))) continue;
                scripts.add(new SchemaUpdateScript(fk.sqlCreateString(dialect, this.mapping, tableCatalog, tableSchema), false));
            }
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            String[] lines = generator.sqlCreateStrings(dialect);
            scripts.addAll(SchemaUpdateScript.fromStringArray(lines, false));
        }
        return scripts;
    }

    public void validateSchema(Dialect dialect, DatabaseMetadata databaseMetadata) throws HibernateException {
        this.secondPassCompile();
        String defaultCatalog = this.properties.getProperty("hibernate.default_catalog");
        String defaultSchema = this.properties.getProperty("hibernate.default_schema");
        Iterator<Object> iter = this.getTableMappings();
        while (iter.hasNext()) {
            Table table = iter.next();
            if (!table.isPhysicalTable()) continue;
            TableMetadata tableInfo = databaseMetadata.getTableMetadata(table.getName(), table.getSchema() == null ? defaultSchema : table.getSchema(), table.getCatalog() == null ? defaultCatalog : table.getCatalog(), table.isQuoted());
            if (tableInfo == null) {
                throw new HibernateException("Missing table: " + table.getName());
            }
            table.validateColumns(dialect, this.mapping, tableInfo);
        }
        iter = this.iterateGenerators(dialect);
        while (iter.hasNext()) {
            PersistentIdentifierGenerator generator = (PersistentIdentifierGenerator)iter.next();
            Object key = generator.generatorKey();
            if (databaseMetadata.isSequence(key) || databaseMetadata.isTable(key)) continue;
            throw new HibernateException("Missing sequence or table: " + key);
        }
    }

    private void validate() throws MappingException {
        Iterator<Filterable> iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            iter.next().validate(this.mapping);
        }
        iter = this.collections.values().iterator();
        while (iter.hasNext()) {
            ((Collection)iter.next()).validate(this.mapping);
        }
    }

    public void buildMappings() {
        this.secondPassCompile();
    }

    protected void secondPassCompile() throws MappingException {
        LOG.trace("Starting secondPassCompile() processing");
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoaderHelper.getContextClassLoader());
        if (!this.isDefaultProcessed) {
            String catalog;
            String schema;
            Map defaults = this.reflectionManager.getDefaults();
            Object v = defaults.get("delimited-identifier");
            if (v != null && v == Boolean.TRUE) {
                this.getProperties().put("hibernate.globally_quoted_identifiers", "true");
            }
            if (StringHelper.isNotEmpty(schema = (String)defaults.get("schema"))) {
                this.getProperties().put("hibernate.default_schema", schema);
            }
            if (StringHelper.isNotEmpty(catalog = (String)defaults.get("catalog"))) {
                this.getProperties().put("hibernate.default_catalog", catalog);
            }
            AnnotationBinder.bindDefaults(this.createMappings());
            this.isDefaultProcessed = true;
        }
        this.metadataSourceQueue.syncAnnotatedClasses();
        this.metadataSourceQueue.processMetadata(this.determineMetadataSourcePrecedence());
        try {
            this.inSecondPass = true;
            this.processSecondPassesOfType(PkDrivenByDefaultMapsIdSecondPass.class);
            this.processSecondPassesOfType(SetSimpleValueTypeSecondPass.class);
            this.processSecondPassesOfType(CopyIdentifierComponentSecondPass.class);
            this.processFkSecondPassInOrder();
            this.processSecondPassesOfType(CreateKeySecondPass.class);
            this.processSecondPassesOfType(SecondaryTableSecondPass.class);
            this.originalSecondPassCompile();
            this.inSecondPass = false;
        }
        catch (RecoverableException e) {
            throw (RuntimeException)e.getCause();
        }
        for (CacheHolder cacheHolder : this.caches) {
            if (cacheHolder.isClass) {
                this.applyCacheConcurrencyStrategy(cacheHolder);
                continue;
            }
            this.applyCollectionCacheConcurrencyStrategy(cacheHolder);
        }
        this.caches.clear();
        for (Map.Entry entry : this.uniqueConstraintHoldersByTable.entrySet()) {
            Table table = (Table)entry.getKey();
            List uniqueConstraints = (List)entry.getValue();
            for (UniqueConstraintHolder holder : uniqueConstraints) {
                this.buildUniqueKeyFromColumnNames(table, holder.getName(), holder.getColumns());
            }
        }
        Thread.currentThread().setContextClassLoader(tccl);
    }

    private void processSecondPassesOfType(Class<? extends SecondPass> type) {
        Iterator<SecondPass> iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            SecondPass sp = iter.next();
            if (!type.isInstance(sp)) continue;
            sp.doSecondPass(this.classes);
            iter.remove();
        }
    }

    private void processFkSecondPassInOrder() {
        LOG.debug("Processing fk mappings (*ToOne and JoinedSubclass)");
        List<FkSecondPass> fkSecondPasses = this.getFKSecondPassesOnly();
        if (fkSecondPasses.size() == 0) {
            return;
        }
        HashMap<String, Set<FkSecondPass>> isADependencyOf = new HashMap<String, Set<FkSecondPass>>();
        ArrayList<FkSecondPass> endOfQueueFkSecondPasses = new ArrayList<FkSecondPass>(fkSecondPasses.size());
        for (FkSecondPass sp : fkSecondPasses) {
            if (sp.isInPrimaryKey()) {
                String referenceEntityName = sp.getReferencedEntityName();
                PersistentClass classMapping = this.getClassMapping(referenceEntityName);
                String dependentTable = this.quotedTableName(classMapping.getTable());
                if (!isADependencyOf.containsKey(dependentTable)) {
                    isADependencyOf.put(dependentTable, new HashSet());
                }
                ((Set)isADependencyOf.get(dependentTable)).add(sp);
                continue;
            }
            endOfQueueFkSecondPasses.add(sp);
        }
        ArrayList<FkSecondPass> orderedFkSecondPasses = new ArrayList<FkSecondPass>(fkSecondPasses.size());
        for (String tableName : isADependencyOf.keySet()) {
            this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, tableName, tableName);
        }
        for (FkSecondPass sp : orderedFkSecondPasses) {
            sp.doSecondPass(this.classes);
        }
        this.processEndOfQueue(endOfQueueFkSecondPasses);
    }

    private List<FkSecondPass> getFKSecondPassesOnly() {
        Iterator<SecondPass> iter = this.secondPasses.iterator();
        ArrayList<FkSecondPass> fkSecondPasses = new ArrayList<FkSecondPass>(this.secondPasses.size());
        while (iter.hasNext()) {
            SecondPass sp = iter.next();
            if (!(sp instanceof FkSecondPass)) continue;
            fkSecondPasses.add((FkSecondPass)sp);
            iter.remove();
        }
        return fkSecondPasses;
    }

    private void buildRecursiveOrderedFkSecondPasses(List<FkSecondPass> orderedFkSecondPasses, Map<String, Set<FkSecondPass>> isADependencyOf, String startTable, String currentTable) {
        Set<FkSecondPass> dependencies = isADependencyOf.get(currentTable);
        if (dependencies == null || dependencies.size() == 0) {
            return;
        }
        for (FkSecondPass sp : dependencies) {
            String dependentTable = this.quotedTableName(sp.getValue().getTable());
            if (dependentTable.compareTo(startTable) == 0) {
                StringBuilder sb = new StringBuilder("Foreign key circularity dependency involving the following tables: ");
                throw new AnnotationException(sb.toString());
            }
            this.buildRecursiveOrderedFkSecondPasses(orderedFkSecondPasses, isADependencyOf, startTable, dependentTable);
            if (orderedFkSecondPasses.contains(sp)) continue;
            orderedFkSecondPasses.add(0, sp);
        }
    }

    private String quotedTableName(Table table) {
        return Table.qualify(table.getCatalog(), table.getQuotedSchema(), table.getQuotedName());
    }

    private void processEndOfQueue(List<FkSecondPass> endOfQueueFkSecondPasses) {
        boolean stopProcess = false;
        RuntimeException originalException = null;
        while (!stopProcess) {
            ArrayList<FkSecondPass> failingSecondPasses = new ArrayList<FkSecondPass>();
            for (FkSecondPass pass : endOfQueueFkSecondPasses) {
                try {
                    pass.doSecondPass(this.classes);
                }
                catch (RecoverableException e) {
                    failingSecondPasses.add(pass);
                    if (originalException != null) continue;
                    originalException = (RuntimeException)e.getCause();
                }
            }
            stopProcess = failingSecondPasses.size() == 0 || failingSecondPasses.size() == endOfQueueFkSecondPasses.size();
            endOfQueueFkSecondPasses = failingSecondPasses;
        }
        if (endOfQueueFkSecondPasses.size() > 0) {
            throw originalException;
        }
    }

    private void buildUniqueKeyFromColumnNames(Table table, String keyName, String[] columnNames) {
        int size = columnNames.length;
        Column[] columns = new Column[size];
        HashSet<Column> unbound = new HashSet<Column>();
        HashSet<Column> unboundNoLogical = new HashSet<Column>();
        for (int index = 0; index < size; ++index) {
            String column = columnNames[index];
            try {
                String columnName = this.createMappings().getPhysicalColumnName(column, table);
                columns[index] = new Column(columnName);
                unbound.add(columns[index]);
                continue;
            }
            catch (MappingException e) {
                unboundNoLogical.add(new Column(column));
            }
        }
        if (StringHelper.isEmpty(keyName)) {
            keyName = Constraint.generateName("UK_", table, columns);
        }
        keyName = this.normalizer.normalizeIdentifierQuoting(keyName);
        UniqueKey uk = table.getOrCreateUniqueKey(keyName);
        for (Column column : columns) {
            if (!table.containsColumn(column)) continue;
            uk.addColumn(column);
            unbound.remove(column);
        }
        if (unbound.size() > 0 || unboundNoLogical.size() > 0) {
            StringBuilder sb = new StringBuilder("Unable to create unique key constraint (");
            for (String columnName : columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") on table ").append(table.getName()).append(": database column ");
            for (Column column : unbound) {
                sb.append("'").append(column.getName()).append("', ");
            }
            for (Column column : unboundNoLogical) {
                sb.append("'").append(column.getName()).append("', ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" not found. Make sure that you use the correct column name which depends on the naming strategy in use (it may not be the same as the property name in the entity, especially for relational types)");
            throw new AnnotationException(sb.toString());
        }
    }

    private void originalSecondPassCompile() throws MappingException {
        SecondPass sp;
        LOG.debug("Processing extends queue");
        this.processExtendsQueue();
        LOG.debug("Processing collection mappings");
        Iterator<Serializable> itr = this.secondPasses.iterator();
        while (itr.hasNext()) {
            sp = itr.next();
            if (sp instanceof QuerySecondPass) continue;
            sp.doSecondPass(this.classes);
            itr.remove();
        }
        LOG.debug("Processing native query and ResultSetMapping mappings");
        itr = this.secondPasses.iterator();
        while (itr.hasNext()) {
            sp = itr.next();
            sp.doSecondPass(this.classes);
            itr.remove();
        }
        LOG.debug("Processing association property references");
        for (Mappings.PropertyReference upr : this.propertyReferences) {
            PersistentClass clazz = this.getClassMapping(upr.referencedClass);
            if (clazz == null) {
                throw new MappingException("property-ref to unmapped class: " + upr.referencedClass);
            }
            Property prop = clazz.getReferencedProperty(upr.propertyName);
            if (!upr.unique) continue;
            ((SimpleValue)prop.getValue()).setAlternateUniqueKey(true);
        }
        LOG.debug("Creating tables' unique integer identifiers");
        LOG.debug("Processing foreign key constraints");
        itr = this.getTableMappings();
        int uniqueInteger = 0;
        HashSet<ForeignKey> done = new HashSet<ForeignKey>();
        while (itr.hasNext()) {
            Table table = (Table)itr.next();
            table.setUniqueInteger(uniqueInteger++);
            this.secondPassCompileForeignKeys(table, done);
        }
    }

    private int processExtendsQueue() {
        LOG.debug("Processing extends queue");
        int added = 0;
        ExtendsQueueEntry extendsQueueEntry = this.findPossibleExtends();
        while (extendsQueueEntry != null) {
            this.metadataSourceQueue.processHbmXml(extendsQueueEntry.getMetadataXml(), extendsQueueEntry.getEntityNames());
            extendsQueueEntry = this.findPossibleExtends();
        }
        if (this.extendsQueue.size() > 0) {
            Iterator<ExtendsQueueEntry> iterator = this.extendsQueue.keySet().iterator();
            StringBuilder buf = new StringBuilder("Following super classes referenced in extends not found: ");
            while (iterator.hasNext()) {
                ExtendsQueueEntry entry = iterator.next();
                buf.append(entry.getExplicitName());
                if (entry.getMappingPackage() != null) {
                    buf.append("[").append(entry.getMappingPackage()).append("]");
                }
                if (!iterator.hasNext()) continue;
                buf.append(",");
            }
            throw new MappingException(buf.toString());
        }
        return added;
    }

    protected ExtendsQueueEntry findPossibleExtends() {
        Iterator<ExtendsQueueEntry> itr = this.extendsQueue.keySet().iterator();
        while (itr.hasNext()) {
            ExtendsQueueEntry entry = itr.next();
            boolean found = this.getClassMapping(entry.getExplicitName()) != null || this.getClassMapping(HbmBinder.getClassName(entry.getExplicitName(), entry.getMappingPackage())) != null;
            if (!found) continue;
            itr.remove();
            return entry;
        }
        return null;
    }

    protected void secondPassCompileForeignKeys(Table table, Set<ForeignKey> done) throws MappingException {
        table.createForeignKeys();
        Iterator iter = table.getForeignKeyIterator();
        while (iter.hasNext()) {
            ForeignKey fk = (ForeignKey)iter.next();
            if (done.contains(fk)) continue;
            done.add(fk);
            String referencedEntityName = fk.getReferencedEntityName();
            if (referencedEntityName == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " does not specify the referenced entity");
            }
            LOG.debugf("Resolving reference to class: %s", referencedEntityName);
            PersistentClass referencedClass = this.classes.get(referencedEntityName);
            if (referencedClass == null) {
                throw new MappingException("An association from the table " + fk.getTable().getName() + " refers to an unmapped class: " + referencedEntityName);
            }
            if (referencedClass.isJoinedSubclass()) {
                this.secondPassCompileForeignKeys(referencedClass.getSuperclass().getTable(), done);
            }
            fk.setReferencedTable(referencedClass.getTable());
            fk.alignColumns();
        }
    }

    public Map<String, NamedQueryDefinition> getNamedQueries() {
        return this.namedQueries;
    }

    public SessionFactory buildSessionFactory(ServiceRegistry serviceRegistry) throws HibernateException {
        LOG.debugf("Preparing to build session factory with filters : %s", this.filterDefinitions);
        this.buildTypeRegistrations(serviceRegistry);
        this.secondPassCompile();
        if (!this.metadataSourceQueue.isEmpty()) {
            LOG.incompleteMappingMetadataCacheProcessing();
        }
        this.validate();
        Environment.verifyProperties(this.properties);
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)this.properties);
        ConfigurationHelper.resolvePlaceHolders(copy);
        Settings settings = this.buildSettings(copy, serviceRegistry);
        return new SessionFactoryImpl(this, this.mapping, serviceRegistry, settings, this.sessionFactoryObserver);
    }

    private void buildTypeRegistrations(ServiceRegistry serviceRegistry) {
        TypeContributions typeContributions = new TypeContributions(){

            @Override
            public void contributeType(BasicType type) {
                Configuration.this.typeResolver.registerTypeOverride(type);
            }

            @Override
            public void contributeType(UserType type, String[] keys) {
                Configuration.this.typeResolver.registerTypeOverride(type, keys);
            }

            @Override
            public void contributeType(CompositeUserType type, String[] keys) {
                Configuration.this.typeResolver.registerTypeOverride(type, keys);
            }
        };
        Dialect dialect = serviceRegistry.getService(JdbcServices.class).getDialect();
        dialect.contributeTypes(typeContributions, serviceRegistry);
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        for (TypeContributor contributor : classLoaderService.loadJavaServices(TypeContributor.class)) {
            contributor.contribute(typeContributions, serviceRegistry);
        }
        for (TypeContributor contributor : this.typeContributorRegistrations) {
            contributor.contribute(typeContributions, serviceRegistry);
        }
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        Environment.verifyProperties(this.properties);
        ConfigurationHelper.resolvePlaceHolders(this.properties);
        final ServiceRegistry serviceRegistry = new ServiceRegistryBuilder().applySettings(this.properties).buildServiceRegistry();
        this.setSessionFactoryObserver(new SessionFactoryObserver(){

            @Override
            public void sessionFactoryCreated(SessionFactory factory) {
            }

            @Override
            public void sessionFactoryClosed(SessionFactory factory) {
                ((StandardServiceRegistryImpl)serviceRegistry).destroy();
            }
        });
        return this.buildSessionFactory(serviceRegistry);
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public Configuration addProperties(Properties extraProperties) {
        this.properties.putAll((Map<?, ?>)extraProperties);
        return this;
    }

    public Configuration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    private void addProperties(Element parent) {
        Iterator itr = parent.elementIterator("property");
        while (itr.hasNext()) {
            Element node = (Element)itr.next();
            String name = node.attributeValue("name");
            String value = node.getText().trim();
            LOG.debugf("%s=%s", name, value);
            this.properties.setProperty(name, value);
            if (name.startsWith("hibernate")) continue;
            this.properties.setProperty("hibernate." + name, value);
        }
        Environment.verifyProperties(this.properties);
    }

    public Configuration configure() throws HibernateException {
        this.configure("/hibernate.cfg.xml");
        return this;
    }

    public Configuration configure(String resource) throws HibernateException {
        LOG.configuringFromResource(resource);
        InputStream stream = this.getConfigurationInputStream(resource);
        return this.doConfigure(stream, resource);
    }

    protected InputStream getConfigurationInputStream(String resource) throws HibernateException {
        LOG.configurationResource(resource);
        return ConfigHelper.getResourceAsStream(resource);
    }

    public Configuration configure(URL url) throws HibernateException {
        LOG.configuringFromUrl(url);
        try {
            return this.doConfigure(url.openStream(), url.toString());
        }
        catch (IOException ioe) {
            throw new HibernateException("could not configure from URL: " + url, ioe);
        }
    }

    public Configuration configure(File configFile) throws HibernateException {
        LOG.configuringFromFile(configFile.getName());
        try {
            return this.doConfigure(new FileInputStream(configFile), configFile.toString());
        }
        catch (FileNotFoundException fnfe) {
            throw new HibernateException("could not find file: " + configFile, fnfe);
        }
    }

    protected Configuration doConfigure(InputStream stream, String resourceName) throws HibernateException {
        try {
            ErrorLogger errorLogger = new ErrorLogger(resourceName);
            Document document = this.xmlHelper.createSAXReader(errorLogger, this.entityResolver).read(new InputSource(stream));
            if (errorLogger.hasErrors()) {
                throw new MappingException("invalid configuration", errorLogger.getErrors().get(0));
            }
            this.doConfigure(document);
        }
        catch (DocumentException e) {
            throw new HibernateException("Could not parse configuration: " + resourceName, e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                LOG.unableToCloseInputStreamForResource(resourceName, ioe);
            }
        }
        return this;
    }

    public Configuration configure(org.w3c.dom.Document document) throws HibernateException {
        LOG.configuringFromXmlDocument();
        return this.doConfigure(this.xmlHelper.createDOMReader().read(document));
    }

    protected Configuration doConfigure(Document doc) throws HibernateException {
        Element sfNode = doc.getRootElement().element("session-factory");
        String name = sfNode.attributeValue("name");
        if (name != null) {
            this.properties.setProperty("hibernate.session_factory_name", name);
        }
        this.addProperties(sfNode);
        this.parseSessionFactory(sfNode, name);
        Element secNode = doc.getRootElement().element("security");
        if (secNode != null) {
            this.parseSecurity(secNode);
        }
        LOG.configuredSessionFactory(name);
        LOG.debugf("Properties: %s", this.properties);
        return this;
    }

    private void parseSessionFactory(Element sfNode, String name) {
        Iterator elements = sfNode.elementIterator();
        while (elements.hasNext()) {
            String region;
            Attribute regionNode;
            Element subelement = (Element)elements.next();
            String subelementName = subelement.getName();
            if ("mapping".equals(subelementName)) {
                this.parseMappingElement(subelement, name);
                continue;
            }
            if ("class-cache".equals(subelementName)) {
                String className = subelement.attributeValue("class");
                regionNode = subelement.attribute("region");
                region = regionNode == null ? className : regionNode.getValue();
                boolean includeLazy = !"non-lazy".equals(subelement.attributeValue("include"));
                this.setCacheConcurrencyStrategy(className, subelement.attributeValue("usage"), region, includeLazy);
                continue;
            }
            if (!"collection-cache".equals(subelementName)) continue;
            String role = subelement.attributeValue("collection");
            regionNode = subelement.attribute("region");
            region = regionNode == null ? role : regionNode.getValue();
            this.setCollectionCacheConcurrencyStrategy(role, subelement.attributeValue("usage"), region);
        }
    }

    private void parseMappingElement(Element mappingElement, String name) {
        Attribute resourceAttribute = mappingElement.attribute("resource");
        Attribute fileAttribute = mappingElement.attribute("file");
        Attribute jarAttribute = mappingElement.attribute("jar");
        Attribute packageAttribute = mappingElement.attribute("package");
        Attribute classAttribute = mappingElement.attribute("class");
        if (resourceAttribute != null) {
            String resourceName = resourceAttribute.getValue();
            LOG.debugf("Session-factory config [%s] named resource [%s] for mapping", name, resourceName);
            this.addResource(resourceName);
        } else if (fileAttribute != null) {
            String fileName = fileAttribute.getValue();
            LOG.debugf("Session-factory config [%s] named file [%s] for mapping", name, fileName);
            this.addFile(fileName);
        } else if (jarAttribute != null) {
            String jarFileName = jarAttribute.getValue();
            LOG.debugf("Session-factory config [%s] named jar file [%s] for mapping", name, jarFileName);
            this.addJar(new File(jarFileName));
        } else if (packageAttribute != null) {
            String packageName = packageAttribute.getValue();
            LOG.debugf("Session-factory config [%s] named package [%s] for mapping", name, packageName);
            this.addPackage(packageName);
        } else if (classAttribute != null) {
            String className = classAttribute.getValue();
            LOG.debugf("Session-factory config [%s] named class [%s] for mapping", name, className);
            try {
                this.addAnnotatedClass(ReflectHelper.classForName(className));
            }
            catch (Exception e) {
                throw new MappingException("Unable to load class [ " + className + "] declared in Hibernate configuration <mapping/> entry", e);
            }
        } else {
            throw new MappingException("<mapping> element in configuration specifies no known attributes");
        }
    }

    private void parseSecurity(Element secNode) {
        String contextId = secNode.attributeValue("context");
        this.setProperty("hibernate.jacc_context_id", contextId);
        LOG.jaccContextId(contextId);
        JACCConfiguration jcfg = new JACCConfiguration(contextId);
        Iterator grantElements = secNode.elementIterator();
        while (grantElements.hasNext()) {
            Element grantElement = (Element)grantElements.next();
            String elementName = grantElement.getName();
            if (!"grant".equals(elementName)) continue;
            jcfg.addPermission(grantElement.attributeValue("role"), grantElement.attributeValue("entity-name"), grantElement.attributeValue("actions"));
        }
    }

    RootClass getRootClassMapping(String clazz) throws MappingException {
        try {
            return (RootClass)this.getClassMapping(clazz);
        }
        catch (ClassCastException cce) {
            throw new MappingException("You may only specify a cache for root <class> mappings");
        }
    }

    public Configuration setCacheConcurrencyStrategy(String entityName, String concurrencyStrategy) {
        this.setCacheConcurrencyStrategy(entityName, concurrencyStrategy, entityName);
        return this;
    }

    public Configuration setCacheConcurrencyStrategy(String entityName, String concurrencyStrategy, String region) {
        this.setCacheConcurrencyStrategy(entityName, concurrencyStrategy, region, true);
        return this;
    }

    public void setCacheConcurrencyStrategy(String entityName, String concurrencyStrategy, String region, boolean cacheLazyProperty) throws MappingException {
        this.caches.add(new CacheHolder(entityName, concurrencyStrategy, region, true, cacheLazyProperty));
    }

    private void applyCacheConcurrencyStrategy(CacheHolder holder) {
        RootClass rootClass = this.getRootClassMapping(holder.role);
        if (rootClass == null) {
            throw new MappingException("Cannot cache an unknown entity: " + holder.role);
        }
        rootClass.setCacheConcurrencyStrategy(holder.usage);
        rootClass.setCacheRegionName(holder.region);
        rootClass.setLazyPropertiesCacheable(holder.cacheLazy);
    }

    public Configuration setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy) {
        this.setCollectionCacheConcurrencyStrategy(collectionRole, concurrencyStrategy, collectionRole);
        return this;
    }

    public void setCollectionCacheConcurrencyStrategy(String collectionRole, String concurrencyStrategy, String region) {
        this.caches.add(new CacheHolder(collectionRole, concurrencyStrategy, region, false, false));
    }

    private void applyCollectionCacheConcurrencyStrategy(CacheHolder holder) {
        Collection collection = this.getCollectionMapping(holder.role);
        if (collection == null) {
            throw new MappingException("Cannot cache an unknown collection: " + holder.role);
        }
        collection.setCacheConcurrencyStrategy(holder.usage);
        collection.setCacheRegionName(holder.region);
    }

    public Map<String, String> getImports() {
        return this.imports;
    }

    public Settings buildSettings(ServiceRegistry serviceRegistry) {
        Properties clone = (Properties)this.properties.clone();
        ConfigurationHelper.resolvePlaceHolders(clone);
        return this.buildSettingsInternal(clone, serviceRegistry);
    }

    public Settings buildSettings(Properties props, ServiceRegistry serviceRegistry) throws HibernateException {
        return this.buildSettingsInternal(props, serviceRegistry);
    }

    private Settings buildSettingsInternal(Properties props, ServiceRegistry serviceRegistry) {
        Settings settings = this.settingsFactory.buildSettings(props, serviceRegistry);
        settings.setEntityTuplizerFactory(this.getEntityTuplizerFactory());
        return settings;
    }

    public Map getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public Configuration setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        return this;
    }

    public MutableIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return this.identifierGeneratorFactory;
    }

    public Mapping buildMapping() {
        return new Mapping(){

            @Override
            public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
                return Configuration.this.identifierGeneratorFactory;
            }

            @Override
            public Type getIdentifierType(String entityName) throws MappingException {
                PersistentClass pc = Configuration.this.classes.get(entityName);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + entityName);
                }
                return pc.getIdentifier().getType();
            }

            @Override
            public String getIdentifierPropertyName(String entityName) throws MappingException {
                PersistentClass pc = Configuration.this.classes.get(entityName);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + entityName);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            @Override
            public Type getReferencedPropertyType(String entityName, String propertyName) throws MappingException {
                PersistentClass pc = Configuration.this.classes.get(entityName);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + entityName);
                }
                Property prop = pc.getReferencedProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + entityName + '.' + propertyName);
                }
                return prop.getType();
            }
        };
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        MetadataProvider metadataProvider = (MetadataProvider)ois.readObject();
        this.mapping = this.buildMapping();
        this.xmlHelper = new XMLHelper();
        this.createReflectionManager(metadataProvider);
        ois.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        MetadataProvider metadataProvider = ((MetadataProviderInjector)this.reflectionManager).getMetadataProvider();
        out.writeObject(metadataProvider);
        out.defaultWriteObject();
    }

    private void createReflectionManager() {
        this.createReflectionManager(new JPAMetadataProvider());
    }

    private void createReflectionManager(MetadataProvider metadataProvider) {
        this.reflectionManager = new JavaReflectionManager();
        ((MetadataProviderInjector)this.reflectionManager).setMetadataProvider(metadataProvider);
    }

    public Map getFilterDefinitions() {
        return this.filterDefinitions;
    }

    public void addFilterDefinition(FilterDefinition definition) {
        this.filterDefinitions.put(definition.getFilterName(), definition);
    }

    public Iterator iterateFetchProfiles() {
        return this.fetchProfiles.values().iterator();
    }

    public void addFetchProfile(FetchProfile fetchProfile) {
        this.fetchProfiles.put(fetchProfile.getName(), fetchProfile);
    }

    public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        this.auxiliaryDatabaseObjects.add(object);
    }

    public Map getSqlFunctions() {
        return this.sqlFunctions;
    }

    public void addSqlFunction(String functionName, SQLFunction function) {
        this.sqlFunctions.put(functionName.toLowerCase(), function);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void registerTypeOverride(BasicType type) {
        this.getTypeResolver().registerTypeOverride(type);
    }

    public void registerTypeOverride(UserType type, String[] keys) {
        this.getTypeResolver().registerTypeOverride(type, keys);
    }

    public void registerTypeOverride(CompositeUserType type, String[] keys) {
        this.getTypeResolver().registerTypeOverride(type, keys);
    }

    public void registerTypeContributor(TypeContributor typeContributor) {
        this.typeContributorRegistrations.add(typeContributor);
    }

    public SessionFactoryObserver getSessionFactoryObserver() {
        return this.sessionFactoryObserver;
    }

    public void setSessionFactoryObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.sessionFactoryObserver = sessionFactoryObserver;
    }

    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    public void setCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver currentTenantIdentifierResolver) {
        this.currentTenantIdentifierResolver = currentTenantIdentifierResolver;
    }

    private List<MetadataSourceType> determineMetadataSourcePrecedence() {
        if (this.metadataSourcePrecedence.isEmpty() && StringHelper.isNotEmpty(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER))) {
            this.metadataSourcePrecedence = this.parsePrecedence(this.getProperties().getProperty(ARTEFACT_PROCESSING_ORDER));
        }
        if (this.metadataSourcePrecedence.isEmpty()) {
            this.metadataSourcePrecedence = Arrays.asList(DEFAULT_ARTEFACT_PROCESSING_ORDER);
        }
        this.metadataSourcePrecedence = Collections.unmodifiableList(this.metadataSourcePrecedence);
        return this.metadataSourcePrecedence;
    }

    public void setPrecedence(String precedence) {
        this.metadataSourcePrecedence = this.parsePrecedence(precedence);
    }

    private List<MetadataSourceType> parsePrecedence(String s) {
        if (StringHelper.isEmpty(s)) {
            return Collections.emptyList();
        }
        StringTokenizer precedences = new StringTokenizer(s, ",; ", false);
        ArrayList<MetadataSourceType> tmpPrecedences = new ArrayList<MetadataSourceType>();
        while (precedences.hasMoreElements()) {
            tmpPrecedences.add(MetadataSourceType.parsePrecedence((String)precedences.nextElement()));
        }
        return tmpPrecedences;
    }

    private static class CacheHolder {
        public String role;
        public String usage;
        public String region;
        public boolean isClass;
        public boolean cacheLazy;

        public CacheHolder(String role, String usage, String region, boolean isClass, boolean cacheLazy) {
            this.role = role;
            this.usage = usage;
            this.region = region;
            this.isClass = isClass;
            this.cacheLazy = cacheLazy;
        }
    }

    protected class MetadataSourceQueue
    implements Serializable {
        private LinkedHashMap<XmlDocument, Set<String>> hbmMetadataToEntityNamesMap = new LinkedHashMap();
        private Map<String, XmlDocument> hbmMetadataByEntityNameXRef = new HashMap<String, XmlDocument>();
        private transient List<XClass> annotatedClasses = new ArrayList<XClass>();
        private transient Map<String, XClass> annotatedClassesByEntityNameMap = new HashMap<String, XClass>();

        protected MetadataSourceQueue() {
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            this.annotatedClassesByEntityNameMap = new HashMap<String, XClass>();
            List serializableAnnotatedClasses = (List)ois.readObject();
            this.annotatedClasses = new ArrayList<XClass>(serializableAnnotatedClasses.size());
            for (Class clazz : serializableAnnotatedClasses) {
                this.annotatedClasses.add(Configuration.this.reflectionManager.toXClass(clazz));
            }
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            ArrayList<Class> serializableAnnotatedClasses = new ArrayList<Class>(this.annotatedClasses.size());
            for (XClass xClass : this.annotatedClasses) {
                serializableAnnotatedClasses.add(Configuration.this.reflectionManager.toClass(xClass));
            }
            out.writeObject(serializableAnnotatedClasses);
        }

        public void add(XmlDocument metadataXml) {
            Document document = metadataXml.getDocumentTree();
            Element hmNode = document.getRootElement();
            Attribute packNode = hmNode.attribute("package");
            String defaultPackage = packNode != null ? packNode.getValue() : "";
            HashSet<String> entityNames = new HashSet<String>();
            this.findClassNames(defaultPackage, hmNode, entityNames);
            for (String entity : entityNames) {
                this.hbmMetadataByEntityNameXRef.put(entity, metadataXml);
            }
            this.hbmMetadataToEntityNamesMap.put(metadataXml, entityNames);
        }

        private void findClassNames(String defaultPackage, Element startNode, Set<String> names) {
            Iterator[] classes = new Iterator[]{startNode.elementIterator("class"), startNode.elementIterator("subclass"), startNode.elementIterator("joined-subclass"), startNode.elementIterator("union-subclass")};
            JoinedIterator classIterator = new JoinedIterator(classes);
            while (classIterator.hasNext()) {
                Element element = (Element)classIterator.next();
                String entityName = element.attributeValue("entity-name");
                if (entityName == null) {
                    entityName = this.getClassName(element.attribute("name"), defaultPackage);
                }
                names.add(entityName);
                this.findClassNames(defaultPackage, element, names);
            }
        }

        private String getClassName(Attribute name, String defaultPackage) {
            if (name == null) {
                return null;
            }
            String unqualifiedName = name.getValue();
            if (unqualifiedName == null) {
                return null;
            }
            if (unqualifiedName.indexOf(46) < 0 && defaultPackage != null) {
                return defaultPackage + '.' + unqualifiedName;
            }
            return unqualifiedName;
        }

        public void add(XClass annotatedClass) {
            this.annotatedClasses.add(annotatedClass);
        }

        protected void syncAnnotatedClasses() {
            Iterator<XClass> itr = this.annotatedClasses.iterator();
            while (itr.hasNext()) {
                XClass annotatedClass = itr.next();
                if (annotatedClass.isAnnotationPresent(Entity.class)) {
                    this.annotatedClassesByEntityNameMap.put(annotatedClass.getName(), annotatedClass);
                    continue;
                }
                if (annotatedClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                itr.remove();
            }
        }

        protected void processMetadata(List<MetadataSourceType> order) {
            this.syncAnnotatedClasses();
            for (MetadataSourceType type : order) {
                if (MetadataSourceType.HBM.equals((Object)type)) {
                    this.processHbmXmlQueue();
                    continue;
                }
                if (!MetadataSourceType.CLASS.equals((Object)type)) continue;
                this.processAnnotatedClassesQueue();
            }
        }

        private void processHbmXmlQueue() {
            LOG.debug("Processing hbm.xml files");
            for (Map.Entry<XmlDocument, Set<String>> entry : this.hbmMetadataToEntityNamesMap.entrySet()) {
                this.processHbmXml(entry.getKey(), entry.getValue());
            }
            this.hbmMetadataToEntityNamesMap.clear();
            this.hbmMetadataByEntityNameXRef.clear();
        }

        private void processHbmXml(XmlDocument metadataXml, Set<String> entityNames) {
            try {
                HbmBinder.bindRoot(metadataXml, Configuration.this.createMappings(), Collections.EMPTY_MAP, entityNames);
            }
            catch (MappingException me) {
                throw new InvalidMappingException(metadataXml.getOrigin().getType(), metadataXml.getOrigin().getName(), (Throwable)me);
            }
            for (String entityName : entityNames) {
                if (!this.annotatedClassesByEntityNameMap.containsKey(entityName)) continue;
                this.annotatedClasses.remove(this.annotatedClassesByEntityNameMap.get(entityName));
                this.annotatedClassesByEntityNameMap.remove(entityName);
            }
        }

        private void processAnnotatedClassesQueue() {
            LOG.debug("Process annotated classes");
            List<XClass> orderedClasses = this.orderAndFillHierarchy(this.annotatedClasses);
            Mappings mappings = Configuration.this.createMappings();
            Map<XClass, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses, mappings);
            for (XClass clazz : orderedClasses) {
                AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, mappings);
                String entityName = clazz.getName();
                if (!this.hbmMetadataByEntityNameXRef.containsKey(entityName)) continue;
                this.hbmMetadataToEntityNamesMap.remove(this.hbmMetadataByEntityNameXRef.get(entityName));
                this.hbmMetadataByEntityNameXRef.remove(entityName);
            }
            this.annotatedClasses.clear();
            this.annotatedClassesByEntityNameMap.clear();
        }

        private List<XClass> orderAndFillHierarchy(List<XClass> original) {
            ArrayList<XClass> copy = new ArrayList<XClass>(original);
            this.insertMappedSuperclasses(original, copy);
            ArrayList<XClass> workingCopy = new ArrayList<XClass>(copy);
            ArrayList<XClass> newList = new ArrayList<XClass>(copy.size());
            while (workingCopy.size() > 0) {
                XClass clazz = (XClass)workingCopy.get(0);
                this.orderHierarchy(workingCopy, newList, copy, clazz);
            }
            return newList;
        }

        private void insertMappedSuperclasses(List<XClass> original, List<XClass> copy) {
            for (XClass clazz : original) {
                for (XClass superClass = clazz.getSuperclass(); superClass != null && !Configuration.this.reflectionManager.equals(superClass, Object.class) && !copy.contains(superClass); superClass = superClass.getSuperclass()) {
                    if (!superClass.isAnnotationPresent(Entity.class) && !superClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                    copy.add(superClass);
                }
            }
        }

        private void orderHierarchy(List<XClass> copy, List<XClass> newList, List<XClass> original, XClass clazz) {
            if (clazz == null || Configuration.this.reflectionManager.equals(clazz, Object.class)) {
                return;
            }
            this.orderHierarchy(copy, newList, original, clazz.getSuperclass());
            if (original.contains(clazz)) {
                if (!newList.contains(clazz)) {
                    newList.add(clazz);
                }
                copy.remove(clazz);
            }
        }

        public boolean isEmpty() {
            return this.hbmMetadataToEntityNamesMap.isEmpty() && this.annotatedClasses.isEmpty();
        }
    }

    final class ObjectNameNormalizerImpl
    extends ObjectNameNormalizer
    implements Serializable {
        ObjectNameNormalizerImpl() {
        }

        @Override
        public boolean isUseQuotedIdentifiersGlobally() {
            String setting = (String)Configuration.this.properties.get("hibernate.globally_quoted_identifiers");
            return setting != null && Boolean.valueOf(setting) != false;
        }

        @Override
        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }
    }

    protected class MappingsImpl
    implements ExtendedMappings,
    Serializable {
        private String schemaName;
        private String catalogName;
        private String defaultPackage;
        private boolean autoImport;
        private boolean defaultLazy;
        private String defaultCascade;
        private String defaultAccess;
        private Boolean useNewGeneratorMappings;
        private Boolean useNationalizedCharacterData;
        private Boolean forceDiscriminatorInSelectsByDefault;

        protected MappingsImpl() {
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public String getCatalogName() {
            return this.catalogName;
        }

        @Override
        public void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public String getDefaultPackage() {
            return this.defaultPackage;
        }

        @Override
        public void setDefaultPackage(String defaultPackage) {
            this.defaultPackage = defaultPackage;
        }

        @Override
        public boolean isAutoImport() {
            return this.autoImport;
        }

        @Override
        public void setAutoImport(boolean autoImport) {
            this.autoImport = autoImport;
        }

        @Override
        public boolean isDefaultLazy() {
            return this.defaultLazy;
        }

        @Override
        public void setDefaultLazy(boolean defaultLazy) {
            this.defaultLazy = defaultLazy;
        }

        @Override
        public String getDefaultCascade() {
            return this.defaultCascade;
        }

        @Override
        public void setDefaultCascade(String defaultCascade) {
            this.defaultCascade = defaultCascade;
        }

        @Override
        public String getDefaultAccess() {
            return this.defaultAccess;
        }

        @Override
        public void setDefaultAccess(String defaultAccess) {
            this.defaultAccess = defaultAccess;
        }

        @Override
        public NamingStrategy getNamingStrategy() {
            return Configuration.this.namingStrategy;
        }

        @Override
        public void setNamingStrategy(NamingStrategy namingStrategy) {
            Configuration.this.namingStrategy = namingStrategy;
        }

        @Override
        public TypeResolver getTypeResolver() {
            return Configuration.this.typeResolver;
        }

        @Override
        public Iterator<PersistentClass> iterateClasses() {
            return Configuration.this.classes.values().iterator();
        }

        @Override
        public PersistentClass getClass(String entityName) {
            return Configuration.this.classes.get(entityName);
        }

        @Override
        public PersistentClass locatePersistentClassByEntityName(String entityName) {
            String actualEntityName;
            PersistentClass persistentClass = Configuration.this.classes.get(entityName);
            if (persistentClass == null && StringHelper.isNotEmpty(actualEntityName = Configuration.this.imports.get(entityName))) {
                persistentClass = Configuration.this.classes.get(actualEntityName);
            }
            return persistentClass;
        }

        @Override
        public void addClass(PersistentClass persistentClass) throws DuplicateMappingException {
            PersistentClass old = Configuration.this.classes.put(persistentClass.getEntityName(), persistentClass);
            if (old != null) {
                throw new DuplicateMappingException("class/entity", persistentClass.getEntityName());
            }
        }

        @Override
        public void addImport(String entityName, String rename) throws DuplicateMappingException {
            String existing = Configuration.this.imports.put(rename, entityName);
            if (existing != null) {
                if (existing.equals(entityName)) {
                    LOG.duplicateImport(entityName, rename);
                } else {
                    throw new DuplicateMappingException("duplicate import: " + rename + " refers to both " + entityName + " and " + existing + " (try using auto-import=\"false\")", "import", rename);
                }
            }
        }

        @Override
        public Collection getCollection(String role) {
            return Configuration.this.collections.get(role);
        }

        @Override
        public Iterator<Collection> iterateCollections() {
            return Configuration.this.collections.values().iterator();
        }

        @Override
        public void addCollection(Collection collection) throws DuplicateMappingException {
            Collection old = Configuration.this.collections.put(collection.getRole(), collection);
            if (old != null) {
                throw new DuplicateMappingException("collection role", collection.getRole());
            }
        }

        @Override
        public Table getTable(String schema, String catalog, String name) {
            String key = Table.qualify(catalog, schema, name);
            return Configuration.this.tables.get(key);
        }

        @Override
        public Iterator<Table> iterateTables() {
            return Configuration.this.tables.values().iterator();
        }

        @Override
        public Table addTable(String schema, String catalog, String name, String subselect, boolean isAbstract) {
            name = this.getObjectNameNormalizer().normalizeIdentifierQuoting(name);
            schema = this.getObjectNameNormalizer().normalizeIdentifierQuoting(schema);
            catalog = this.getObjectNameNormalizer().normalizeIdentifierQuoting(catalog);
            String key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
            Table table = Configuration.this.tables.get(key);
            if (table == null) {
                table = new Table();
                table.setAbstract(isAbstract);
                table.setName(name);
                table.setSchema(schema);
                table.setCatalog(catalog);
                table.setSubselect(subselect);
                Configuration.this.tables.put(key, table);
            } else if (!isAbstract) {
                table.setAbstract(false);
            }
            return table;
        }

        @Override
        public Table addDenormalizedTable(String schema, String catalog, String name, boolean isAbstract, String subselect, Table includedTable) throws DuplicateMappingException {
            String key;
            name = this.getObjectNameNormalizer().normalizeIdentifierQuoting(name);
            schema = this.getObjectNameNormalizer().normalizeIdentifierQuoting(schema);
            catalog = this.getObjectNameNormalizer().normalizeIdentifierQuoting(catalog);
            String string = key = subselect == null ? Table.qualify(catalog, schema, name) : subselect;
            if (Configuration.this.tables.containsKey(key)) {
                throw new DuplicateMappingException("table", name);
            }
            DenormalizedTable table = new DenormalizedTable(includedTable);
            table.setAbstract(isAbstract);
            table.setName(name);
            table.setSchema(schema);
            table.setCatalog(catalog);
            table.setSubselect(subselect);
            Configuration.this.tables.put(key, table);
            return table;
        }

        @Override
        public NamedQueryDefinition getQuery(String name) {
            return Configuration.this.namedQueries.get(name);
        }

        @Override
        public void addQuery(String name, NamedQueryDefinition query) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedQueryNames.contains(name)) {
                this.applyQuery(name, query);
            }
        }

        private void applyQuery(String name, NamedQueryDefinition query) {
            this.checkQueryName(name);
            Configuration.this.namedQueries.put(name.intern(), query);
        }

        private void checkQueryName(String name) throws DuplicateMappingException {
            if (Configuration.this.namedQueries.containsKey(name) || Configuration.this.namedSqlQueries.containsKey(name)) {
                throw new DuplicateMappingException("query", name);
            }
        }

        @Override
        public void addDefaultQuery(String name, NamedQueryDefinition query) {
            this.applyQuery(name, query);
            Configuration.this.defaultNamedQueryNames.add(name);
        }

        @Override
        public NamedSQLQueryDefinition getSQLQuery(String name) {
            return Configuration.this.namedSqlQueries.get(name);
        }

        @Override
        public void addSQLQuery(String name, NamedSQLQueryDefinition query) throws DuplicateMappingException {
            if (!Configuration.this.defaultNamedNativeQueryNames.contains(name)) {
                this.applySQLQuery(name, query);
            }
        }

        private void applySQLQuery(String name, NamedSQLQueryDefinition query) throws DuplicateMappingException {
            this.checkQueryName(name);
            Configuration.this.namedSqlQueries.put(name.intern(), query);
        }

        @Override
        public void addDefaultSQLQuery(String name, NamedSQLQueryDefinition query) {
            this.applySQLQuery(name, query);
            Configuration.this.defaultNamedNativeQueryNames.add(name);
        }

        @Override
        public ResultSetMappingDefinition getResultSetMapping(String name) {
            return Configuration.this.sqlResultSetMappings.get(name);
        }

        @Override
        public void addResultSetMapping(ResultSetMappingDefinition sqlResultSetMapping) throws DuplicateMappingException {
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(sqlResultSetMapping.getName())) {
                this.applyResultSetMapping(sqlResultSetMapping);
            }
        }

        public void applyResultSetMapping(ResultSetMappingDefinition sqlResultSetMapping) throws DuplicateMappingException {
            ResultSetMappingDefinition old = Configuration.this.sqlResultSetMappings.put(sqlResultSetMapping.getName(), sqlResultSetMapping);
            if (old != null) {
                throw new DuplicateMappingException("resultSet", sqlResultSetMapping.getName());
            }
        }

        @Override
        public void addDefaultResultSetMapping(ResultSetMappingDefinition definition) {
            String name = definition.getName();
            if (!Configuration.this.defaultSqlResultSetMappingNames.contains(name) && this.getResultSetMapping(name) != null) {
                this.removeResultSetMapping(name);
            }
            this.applyResultSetMapping(definition);
            Configuration.this.defaultSqlResultSetMappingNames.add(name);
        }

        protected void removeResultSetMapping(String name) {
            Configuration.this.sqlResultSetMappings.remove(name);
        }

        @Override
        public TypeDef getTypeDef(String typeName) {
            return Configuration.this.typeDefs.get(typeName);
        }

        @Override
        public void addTypeDef(String typeName, String typeClass, Properties paramMap) {
            TypeDef def = new TypeDef(typeClass, paramMap);
            Configuration.this.typeDefs.put(typeName, def);
            LOG.debugf("Added %s with class %s", typeName, typeClass);
        }

        @Override
        public Map getFilterDefinitions() {
            return Configuration.this.filterDefinitions;
        }

        @Override
        public FilterDefinition getFilterDefinition(String name) {
            return Configuration.this.filterDefinitions.get(name);
        }

        @Override
        public void addFilterDefinition(FilterDefinition definition) {
            Configuration.this.filterDefinitions.put(definition.getFilterName(), definition);
        }

        @Override
        public FetchProfile findOrCreateFetchProfile(String name, MetadataSource source) {
            FetchProfile profile = Configuration.this.fetchProfiles.get(name);
            if (profile == null) {
                profile = new FetchProfile(name, source);
                Configuration.this.fetchProfiles.put(name, profile);
            }
            return profile;
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjects() {
            return this.iterateAuxiliaryDatabaseObjects();
        }

        @Override
        public Iterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjects() {
            return Configuration.this.auxiliaryDatabaseObjects.iterator();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxliaryDatabaseObjectsInReverse() {
            return this.iterateAuxiliaryDatabaseObjectsInReverse();
        }

        @Override
        public ListIterator<AuxiliaryDatabaseObject> iterateAuxiliaryDatabaseObjectsInReverse() {
            return Configuration.this.auxiliaryDatabaseObjects.listIterator(Configuration.this.auxiliaryDatabaseObjects.size());
        }

        @Override
        public void addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject auxiliaryDatabaseObject) {
            Configuration.this.auxiliaryDatabaseObjects.add(auxiliaryDatabaseObject);
        }

        @Override
        public String getLogicalTableName(Table table) throws MappingException {
            return this.getLogicalTableName(table.getQuotedSchema(), table.getQuotedCatalog(), table.getQuotedName());
        }

        private String getLogicalTableName(String schema, String catalog, String physicalName) throws MappingException {
            String key = this.buildTableNameKey(schema, catalog, physicalName);
            TableDescription descriptor = (TableDescription)Configuration.this.tableNameBinding.get(key);
            if (descriptor == null) {
                throw new MappingException("Unable to find physical table: " + physicalName);
            }
            return descriptor.logicalName;
        }

        @Override
        public void addTableBinding(String schema, String catalog, String logicalName, String physicalName, Table denormalizedSuperTable) throws DuplicateMappingException {
            TableDescription tableDescription;
            String key = this.buildTableNameKey(schema, catalog, physicalName);
            TableDescription oldDescriptor = Configuration.this.tableNameBinding.put(key, tableDescription = new TableDescription(logicalName, denormalizedSuperTable));
            if (oldDescriptor != null && !oldDescriptor.logicalName.equals(logicalName)) {
                throw new DuplicateMappingException("Same physical table name [" + physicalName + "] references several logical table names: [" + oldDescriptor.logicalName + "], [" + logicalName + ']', "table", physicalName);
            }
        }

        private String buildTableNameKey(String schema, String catalog, String finalName) {
            StringBuilder keyBuilder = new StringBuilder();
            if (schema != null) {
                keyBuilder.append(schema);
            }
            keyBuilder.append(".");
            if (catalog != null) {
                keyBuilder.append(catalog);
            }
            keyBuilder.append(".");
            keyBuilder.append(finalName);
            return keyBuilder.toString();
        }

        @Override
        public void addColumnBinding(String logicalName, Column physicalColumn, Table table) throws DuplicateMappingException {
            TableColumnNameBinding binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(table);
            if (binding == null) {
                binding = new TableColumnNameBinding(table.getName());
                Configuration.this.columnNameBindingPerTable.put(table, binding);
            }
            binding.addBinding(logicalName, physicalColumn);
        }

        @Override
        public String getPhysicalColumnName(String logicalName, Table table) throws MappingException {
            logicalName = logicalName.toLowerCase();
            String finalName = null;
            Table currentTable = table;
            do {
                String key;
                TableDescription description;
                TableColumnNameBinding binding;
                if ((binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(currentTable)) != null) {
                    finalName = (String)binding.logicalToPhysical.get(logicalName);
                }
                currentTable = (description = (TableDescription)Configuration.this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getQuotedSchema(), currentTable.getQuotedCatalog(), currentTable.getQuotedName()))) != null ? description.denormalizedSupertable : null;
            } while (finalName == null && currentTable != null);
            if (finalName == null) {
                throw new MappingException("Unable to find column with logical name " + logicalName + " in table " + table.getName());
            }
            return finalName;
        }

        @Override
        public String getLogicalColumnName(String physicalName, Table table) throws MappingException {
            String logical = null;
            Table currentTable = table;
            TableDescription description = null;
            do {
                String key;
                TableColumnNameBinding binding;
                if ((binding = (TableColumnNameBinding)Configuration.this.columnNameBindingPerTable.get(currentTable)) != null) {
                    logical = (String)binding.physicalToLogical.get(physicalName);
                }
                currentTable = (description = (TableDescription)Configuration.this.tableNameBinding.get(key = this.buildTableNameKey(currentTable.getQuotedSchema(), currentTable.getQuotedCatalog(), currentTable.getQuotedName()))) != null ? description.denormalizedSupertable : null;
            } while (logical == null && currentTable != null && description != null);
            if (logical == null) {
                throw new MappingException("Unable to find logical column name from physical name " + physicalName + " in table " + table.getName());
            }
            return logical;
        }

        @Override
        public void addSecondPass(SecondPass sp) {
            this.addSecondPass(sp, false);
        }

        @Override
        public void addSecondPass(SecondPass sp, boolean onTopOfTheQueue) {
            if (onTopOfTheQueue) {
                Configuration.this.secondPasses.add(0, sp);
            } else {
                Configuration.this.secondPasses.add(sp);
            }
        }

        @Override
        public void addPropertyReference(String referencedClass, String propertyName) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(referencedClass, propertyName, false));
        }

        @Override
        public void addUniquePropertyReference(String referencedClass, String propertyName) {
            Configuration.this.propertyReferences.add(new Mappings.PropertyReference(referencedClass, propertyName, true));
        }

        @Override
        public void addToExtendsQueue(ExtendsQueueEntry entry) {
            Configuration.this.extendsQueue.put(entry, null);
        }

        @Override
        public MutableIdentifierGeneratorFactory getIdentifierGeneratorFactory() {
            return Configuration.this.identifierGeneratorFactory;
        }

        @Override
        public void addMappedSuperclass(Class type, org.hibernate.mapping.MappedSuperclass mappedSuperclass) {
            Configuration.this.mappedSuperClasses.put(type, mappedSuperclass);
        }

        @Override
        public org.hibernate.mapping.MappedSuperclass getMappedSuperclass(Class type) {
            return (org.hibernate.mapping.MappedSuperclass)Configuration.this.mappedSuperClasses.get(type);
        }

        @Override
        public ObjectNameNormalizer getObjectNameNormalizer() {
            return Configuration.this.normalizer;
        }

        @Override
        public Properties getConfigurationProperties() {
            return Configuration.this.properties;
        }

        @Override
        public void addDefaultGenerator(IdGenerator generator) {
            this.addGenerator(generator);
            Configuration.this.defaultNamedGenerators.add(generator.getName());
        }

        @Override
        public boolean isInSecondPass() {
            return Configuration.this.inSecondPass;
        }

        @Override
        public PropertyData getPropertyAnnotatedWithMapsId(XClass entityType, String propertyName) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithMapsId.get(entityType);
            return map == null ? null : (PropertyData)map.get(propertyName);
        }

        @Override
        public void addPropertyAnnotatedWithMapsId(XClass entityType, PropertyData property) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(entityType, map);
            }
            map.put(((MapsId)property.getProperty().getAnnotation(MapsId.class)).value(), property);
        }

        @Override
        public boolean isSpecjProprietarySyntaxEnabled() {
            return Configuration.this.specjProprietarySyntaxEnabled;
        }

        @Override
        public void addPropertyAnnotatedWithMapsIdSpecj(XClass entityType, PropertyData property, String mapsIdValue) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithMapsId.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithMapsId.put(entityType, map);
            }
            map.put(mapsIdValue, property);
        }

        @Override
        public PropertyData getPropertyAnnotatedWithIdAndToOne(XClass entityType, String propertyName) {
            Map map = (Map)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(entityType);
            return map == null ? null : (PropertyData)map.get(propertyName);
        }

        @Override
        public void addToOneAndIdProperty(XClass entityType, PropertyData property) {
            HashMap<String, PropertyData> map = (HashMap<String, PropertyData>)Configuration.this.propertiesAnnotatedWithIdAndToOne.get(entityType);
            if (map == null) {
                map = new HashMap<String, PropertyData>();
                Configuration.this.propertiesAnnotatedWithIdAndToOne.put(entityType, map);
            }
            map.put(property.getPropertyName(), property);
        }

        @Override
        public boolean useNewGeneratorMappings() {
            if (this.useNewGeneratorMappings == null) {
                String booleanName = this.getConfigurationProperties().getProperty(Configuration.USE_NEW_ID_GENERATOR_MAPPINGS);
                this.useNewGeneratorMappings = Boolean.valueOf(booleanName);
            }
            return this.useNewGeneratorMappings;
        }

        @Override
        public boolean useNationalizedCharacterData() {
            if (this.useNationalizedCharacterData == null) {
                String booleanName = this.getConfigurationProperties().getProperty("hibernate.use_nationalized_character_data");
                this.useNationalizedCharacterData = Boolean.valueOf(booleanName);
            }
            return this.useNationalizedCharacterData;
        }

        @Override
        public boolean forceDiscriminatorInSelectsByDefault() {
            if (this.forceDiscriminatorInSelectsByDefault == null) {
                String booleanName = this.getConfigurationProperties().getProperty("hibernate.discriminator.force_in_select");
                this.forceDiscriminatorInSelectsByDefault = Boolean.valueOf(booleanName);
            }
            return this.forceDiscriminatorInSelectsByDefault;
        }

        @Override
        public IdGenerator getGenerator(String name) {
            return this.getGenerator(name, null);
        }

        @Override
        public IdGenerator getGenerator(String name, Map<String, IdGenerator> localGenerators) {
            IdGenerator result;
            if (localGenerators != null && (result = localGenerators.get(name)) != null) {
                return result;
            }
            return (IdGenerator)Configuration.this.namedGenerators.get(name);
        }

        @Override
        public void addGenerator(IdGenerator generator) {
            IdGenerator old;
            if (!Configuration.this.defaultNamedGenerators.contains(generator.getName()) && (old = Configuration.this.namedGenerators.put(generator.getName(), generator)) != null) {
                LOG.duplicateGeneratorName(old.getName());
            }
        }

        @Override
        public void addGeneratorTable(String name, Properties params) {
            Properties old = Configuration.this.generatorTables.put(name, params);
            if (old != null) {
                LOG.duplicateGeneratorTable(name);
            }
        }

        @Override
        public Properties getGeneratorTableProperties(String name, Map<String, Properties> localGeneratorTables) {
            Properties result;
            if (localGeneratorTables != null && (result = localGeneratorTables.get(name)) != null) {
                return result;
            }
            return (Properties)Configuration.this.generatorTables.get(name);
        }

        @Override
        public Map<String, Join> getJoins(String entityName) {
            return (Map)Configuration.this.joins.get(entityName);
        }

        @Override
        public void addJoins(PersistentClass persistentClass, Map<String, Join> joins) {
            Map<String, Join> old = Configuration.this.joins.put(persistentClass.getEntityName(), joins);
            if (old != null) {
                LOG.duplicateJoins(persistentClass.getEntityName());
            }
        }

        @Override
        public AnnotatedClassType getClassType(XClass clazz) {
            AnnotatedClassType type = (AnnotatedClassType)((Object)Configuration.this.classTypes.get(clazz.getName()));
            if (type == null) {
                return this.addClassType(clazz);
            }
            return type;
        }

        @Override
        public AnnotatedClassType addClassType(XClass clazz) {
            AnnotatedClassType type = clazz.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (clazz.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (clazz.isAnnotationPresent(MappedSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
            Configuration.this.classTypes.put(clazz.getName(), type);
            return type;
        }

        @Override
        public Map<Table, List<String[]>> getTableUniqueConstraints() {
            HashMap<Table, List<String[]>> deprecatedStructure = new HashMap<Table, List<String[]>>(CollectionHelper.determineProperSizing(this.getUniqueConstraintHoldersByTable()), 0.75f);
            for (Map.Entry<Table, List<UniqueConstraintHolder>> entry : this.getUniqueConstraintHoldersByTable().entrySet()) {
                ArrayList<String[]> columnsPerConstraint = new ArrayList<String[]>(CollectionHelper.determineProperSizing(entry.getValue().size()));
                deprecatedStructure.put(entry.getKey(), columnsPerConstraint);
                for (UniqueConstraintHolder holder : entry.getValue()) {
                    columnsPerConstraint.add(holder.getColumns());
                }
            }
            return deprecatedStructure;
        }

        @Override
        public Map<Table, List<UniqueConstraintHolder>> getUniqueConstraintHoldersByTable() {
            return Configuration.this.uniqueConstraintHoldersByTable;
        }

        @Override
        public void addUniqueConstraints(Table table, List uniqueConstraints) {
            ArrayList<UniqueConstraintHolder> constraintHolders = new ArrayList<UniqueConstraintHolder>(CollectionHelper.determineProperSizing(uniqueConstraints.size()));
            int keyNameBase = this.determineCurrentNumberOfUniqueConstraintHolders(table);
            for (String[] columns : uniqueConstraints) {
                String keyName = "key" + keyNameBase++;
                constraintHolders.add(new UniqueConstraintHolder().setName(keyName).setColumns(columns));
            }
            this.addUniqueConstraintHolders(table, constraintHolders);
        }

        private int determineCurrentNumberOfUniqueConstraintHolders(Table table) {
            List<UniqueConstraintHolder> currentHolders = this.getUniqueConstraintHoldersByTable().get(table);
            return currentHolders == null ? 0 : currentHolders.size();
        }

        @Override
        public void addUniqueConstraintHolders(Table table, List<UniqueConstraintHolder> uniqueConstraintHolders) {
            List<UniqueConstraintHolder> holderList = this.getUniqueConstraintHoldersByTable().get(table);
            if (holderList == null) {
                holderList = new ArrayList<UniqueConstraintHolder>();
                this.getUniqueConstraintHoldersByTable().put(table, holderList);
            }
            holderList.addAll(uniqueConstraintHolders);
        }

        @Override
        public void addMappedBy(String entityName, String propertyName, String inversePropertyName) {
            Configuration.this.mappedByResolver.put(entityName + "." + propertyName, inversePropertyName);
        }

        @Override
        public String getFromMappedBy(String entityName, String propertyName) {
            return (String)Configuration.this.mappedByResolver.get(entityName + "." + propertyName);
        }

        @Override
        public void addPropertyReferencedAssociation(String entityName, String propertyName, String propertyRef) {
            Configuration.this.propertyRefResolver.put(entityName + "." + propertyName, propertyRef);
        }

        @Override
        public String getPropertyReferencedAssociation(String entityName, String propertyName) {
            return (String)Configuration.this.propertyRefResolver.get(entityName + "." + propertyName);
        }

        @Override
        public ReflectionManager getReflectionManager() {
            return Configuration.this.reflectionManager;
        }

        @Override
        public Map getClasses() {
            return Configuration.this.classes;
        }

        @Override
        public void addAnyMetaDef(AnyMetaDef defAnn) throws AnnotationException {
            if (Configuration.this.anyMetaDefs.containsKey(defAnn.name())) {
                throw new AnnotationException("Two @AnyMetaDef with the same name defined: " + defAnn.name());
            }
            Configuration.this.anyMetaDefs.put(defAnn.name(), defAnn);
        }

        @Override
        public AnyMetaDef getAnyMetaDef(String name) {
            return (AnyMetaDef)Configuration.this.anyMetaDefs.get(name);
        }

        private class TableColumnNameBinding
        implements Serializable {
            private final String tableName;
            private Map logicalToPhysical = new HashMap();
            private Map physicalToLogical = new HashMap();

            private TableColumnNameBinding(String tableName) {
                this.tableName = tableName;
            }

            public void addBinding(String logicalName, Column physicalColumn) {
                this.bindLogicalToPhysical(logicalName, physicalColumn);
                this.bindPhysicalToLogical(logicalName, physicalColumn);
            }

            private void bindLogicalToPhysical(String logicalName, Column physicalColumn) throws DuplicateMappingException {
                String physicalName;
                String logicalKey = logicalName.toLowerCase();
                String existingPhysicalName = this.logicalToPhysical.put(logicalKey, physicalName = physicalColumn.getQuotedName());
                if (existingPhysicalName != null) {
                    boolean areSamePhysicalColumn;
                    boolean bl = areSamePhysicalColumn = physicalColumn.isQuoted() ? existingPhysicalName.equals(physicalName) : existingPhysicalName.equalsIgnoreCase(physicalName);
                    if (!areSamePhysicalColumn) {
                        throw new DuplicateMappingException(" Table [" + this.tableName + "] contains logical column name [" + logicalName + "] referenced by multiple physical column names: [" + existingPhysicalName + "], [" + physicalName + "]", "column-binding", this.tableName + "." + logicalName);
                    }
                }
            }

            private void bindPhysicalToLogical(String logicalName, Column physicalColumn) throws DuplicateMappingException {
                String physicalName = physicalColumn.getQuotedName();
                String existingLogicalName = this.physicalToLogical.put(physicalName, logicalName);
                if (existingLogicalName != null && !existingLogicalName.equals(logicalName)) {
                    throw new DuplicateMappingException(" Table [" + this.tableName + "] contains physical column name [" + physicalName + "] represented by different logical column names: [" + existingLogicalName + "], [" + logicalName + "]", "column-binding", this.tableName + "." + physicalName);
                }
            }
        }

        private class TableDescription
        implements Serializable {
            final String logicalName;
            final Table denormalizedSupertable;

            TableDescription(String logicalName, Table denormalizedSupertable) {
                this.logicalName = logicalName;
                this.denormalizedSupertable = denormalizedSupertable;
            }
        }
    }
}

